/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.action;

import au.com.bytecode.opencsv.CSVReader;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.xwork.FileUploadUtils;
import com.miniorange.usermanagement.common.UserManagementPluginCommonConstants;
import com.miniorange.usermanagement.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.scheduler.UserDeactivaterScheduler;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import com.miniorange.usermanagement.confluence.utility.OfflineLicenseSettings;
import java.io.File;
import java.io.FileReader;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BulkGroupManagementAction
extends ConfluenceActionSupport {
    private static Log LOGGER = LogFactory.getLog(BulkGroupManagementAction.class);
    private ConfluenceUserManagementUtility UserManagementUtility;
    private UserManagementPluginHandler userManagementPluginHandler;
    private UserManagementPluginSettings settings;
    private CrowdService crowdService;
    private UserAccessor userAccessor;
    private String groupsToCreate;
    private Boolean userManagementGroupsSubmitted;
    private Boolean maxUsersLicense;
    private Boolean userManagementGroupsDeletionSubmitted;
    private Boolean usermanagementGroupsUploadSubmitted;
    private String groupManagementSelectedAction;
    private String creationSelection;
    private String groupsToDelete;
    private ArrayList<String> groupsToDeleteList;
    private ArrayList<String> groupToAddCsv;
    private Boolean uploadgroupSuccessfull = Boolean.FALSE;
    private ArrayList<String> groupList;
    private ArrayList<String> currentPageGroupsList;
    private String groupSearchKeyword;
    private Integer selectedPage;
    private Integer startIndex;
    private Integer endIndex;
    private Integer numberOfPages;
    private Integer numberOfRecordsPerPage;
    private Integer groupPerPage;
    private List<String> numberOfPagesList;
    private Boolean evaluationLicense;
    private OfflineLicenseSettings licenseSettings;
    private boolean isDatacenter;
    private boolean isOfflineLicensevalid = false;
    private UserDeactivaterScheduler userDeactivaterScheduler;
    private ConfluenceUserManagementUtility userManagementUtility;

    public BulkGroupManagementAction(UserAccessor userAccessor, ConfluenceUserManagementUtility userManagementUtility, UserManagementPluginHandler userManagementPluginHandler, UserManagementPluginSettings settings, UserDeactivaterScheduler userDeactivaterScheduler, ConfluenceUserManagementUtility confluenceUserManagement, CrowdService crowdService, OfflineLicenseSettings licenseSettings) {
        this.userAccessor = userAccessor;
        this.UserManagementUtility = userManagementUtility;
        this.userManagementPluginHandler = userManagementPluginHandler;
        this.settings = settings;
        this.userDeactivaterScheduler = userDeactivaterScheduler;
        this.userManagementUtility = confluenceUserManagement;
        this.crowdService = crowdService;
        this.licenseSettings = licenseSettings;
    }

    public Boolean doValidate() throws ParseException {
        String endIndexOfPage;
        String startIndexOfPage;
        LOGGER.debug("Settings Action doValidate");
        Boolean isError = Boolean.FALSE;
        HttpServletRequest request = this.getCurrentRequest();
        if (this.usermanagementGroupsUploadSubmitted == null) {
            this.usermanagementGroupsUploadSubmitted = Boolean.FALSE;
        }
        if (BooleanUtils.toBoolean(this.userManagementGroupsDeletionSubmitted)) {
            startIndexOfPage = "";
            endIndexOfPage = "";
        } else {
            startIndexOfPage = request.getParameter("startIndex");
            endIndexOfPage = request.getParameter("endIndex");
            this.groupSearchKeyword = request.getParameter("groupSearchKeywordUrl");
        }
        if (this.groupPerPage == null) {
            this.groupPerPage = request.getParameter("groupPerPageurl") == null ? UserManagementPluginCommonConstants.MO_NUMBER_OF_USER_PER_PAGE : Integer.valueOf(Integer.parseInt(request.getParameter("groupPerPageurl")));
        }
        this.numberOfRecordsPerPage = this.groupPerPage;
        this.groupSearchKeyword = StringUtils.isBlank(this.groupSearchKeyword) ? "" : UserManagementPluginSettings.sanitizeText(this.groupSearchKeyword).trim();
        if (StringUtils.isBlank(startIndexOfPage) && StringUtils.isBlank(endIndexOfPage)) {
            this.selectedPage = 1;
            this.startIndex = 0;
            this.endIndex = this.numberOfRecordsPerPage;
        } else {
            this.startIndex = Integer.parseInt(startIndexOfPage);
            this.endIndex = Integer.parseInt(endIndexOfPage);
            this.selectedPage = this.endIndex / this.groupPerPage;
        }
        this.groupList = (ArrayList)this.userManagementUtility.getAllGroups(this.groupSearchKeyword);
        this.currentPageGroupsList = (ArrayList)this.userManagementUtility.getSelectedDetailsForPagination(this.groupList, this.groupPerPage, this.startIndex, this.endIndex);
        this.numberOfPages = this.groupList.size() / this.groupPerPage;
        if (this.groupList.size() > this.numberOfPages * this.groupPerPage) {
            BulkGroupManagementAction bulkGroupManagementAction = this;
            Integer n = bulkGroupManagementAction.numberOfPages;
            Integer n2 = bulkGroupManagementAction.numberOfPages = Integer.valueOf(bulkGroupManagementAction.numberOfPages + 1);
        }
        if (this.usermanagementGroupsUploadSubmitted.booleanValue()) {
            try {
                this.handleUploadedCSVFile();
                this.uploadgroupSuccessfull = Boolean.TRUE;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (isError.booleanValue()) {
            this.initialization();
            return isError;
        }
        return isError;
    }

    public String execute() throws Exception {
        LOGGER.debug("initiating Bulk Group Management Action's doExecute");
        if (!this.userManagementUtility.isLicenseValid().booleanValue()) {
            LOGGER.debug("Invalid License ");
            return "invalid";
        }
        this.maxUsersLicense = this.userManagementUtility.getMaxUsers() == 0;
        if (!this.maxUsersLicense.booleanValue()) {
            this.evaluationLicense = this.userManagementUtility.isEvaluationLicense() != false && this.userManagementUtility.isValidEvaluationLicense() != false ? Boolean.TRUE : Boolean.FALSE;
        }
        this.doValidate();
        this.initialization();
        return "success";
    }

    public void initialization() throws ParseException {
        this.groupManagementSelectedAction = this.settings.getUserManagementSelectedAction();
        this.creationSelection = this.settings.getCreationSelection();
        this.groupsToCreate = this.settings.getGroupsToCreate();
        this.groupsToDeleteList = (ArrayList)this.settings.getGroupsToDelete();
        this.isOfflineLicensevalid = this.licenseSettings.isOfflineLicenseValid();
        this.isDatacenter = this.licenseSettings.isDatacenter();
    }

    public List<String> getAllGroups(String groupRegexPattern) {
        String startWith = "";
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)startWith)).returningAtMost(-1);
        ArrayList<String> existingGroups = new ArrayList<String>();
        Iterable groups = this.crowdService.search((Query)query);
        for (Group groupObject : groups) {
            if (!StringUtils.containsIgnoreCase(groupObject.getName(), groupRegexPattern.trim())) continue;
            existingGroups.add(groupObject.getName().trim());
        }
        return existingGroups;
    }

    public List<String> getSelectedDetailsForPagination(List<String> detailsList, Integer groupsPerPage, Integer startIndex, Integer endIndex) {
        ArrayList<String> selectedDetailsPagination = new ArrayList<String>();
        for (int i = startIndex.intValue(); i < startIndex + groupsPerPage && i <= endIndex && i < detailsList.size(); ++i) {
            selectedDetailsPagination.add(detailsList.get(i));
        }
        Collections.sort(selectedDetailsPagination);
        return selectedDetailsPagination;
    }

    private void handleUploadedCSVFile() throws Exception {
        block8: {
            LOGGER.debug("handleUploadedCSVFile for groups called");
            this.groupToAddCsv = new ArrayList();
            try {
                FileUploadUtils.UploadedFile file = FileUploadUtils.getSingleUploadedFile();
                if (file.getFile() == null) {
                    LOGGER.error("Uploaded Group CSV file is null");
                    this.addActionError("File is Empty");
                    break block8;
                }
                File csvFile = file.getFile();
                LOGGER.debug("Uploaded group CSV : " + csvFile.toString());
                CSVReader csvReader = null;
                csvReader = new CSVReader(new FileReader(csvFile));
                List<String[]> rows = csvReader.readAll();
                LOGGER.debug("Uploaded CSV group file size = " + rows.size());
                if (rows == null) break block8;
                LOGGER.debug("CSV Group file is not null starting thread");
                for (int i = 1; i < rows.size(); ++i) {
                    String groups = rows.get(i)[0].toString();
                    if (groups.isEmpty()) {
                        LOGGER.error(" groups is empty");
                        continue;
                    }
                    this.groupToAddCsv.add(groups);
                }
                try {
                    ConfluenceUser confluenceUser = null;
                    confluenceUser = AuthenticatedUserThreadLocal.get();
                    InetAddress ip = InetAddress.getLocalHost();
                    for (String groupsName : this.groupToAddCsv) {
                        if (groupsName.length() <= 0 || this.crowdService.getGroup(groupsName.trim()) != null) continue;
                        LOGGER.debug("Creating new Group with name : " + groupsName);
                        this.userAccessor.createGroup(groupsName);
                        this.userManagementPluginHandler.storeAuditLogs(confluenceUser.getName(), ip.getHostAddress(), "Group Created", "Created group by uploading csv file :" + groupsName);
                    }
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                }
                LOGGER.debug("Groups Imported Successfully");
                this.addActionError("Groups Imported Successfully ", new Object[]{"success", true, null});
            }
            catch (Exception e) {
                LOGGER.error("error while uploading file " + e);
            }
        }
    }

    public boolean getIsOfflineLicensevalid() {
        return this.isOfflineLicensevalid;
    }

    public void setIsOfflineLicensevalid(boolean isOfflineLicensevalid) {
        this.isOfflineLicensevalid = isOfflineLicensevalid;
    }

    public boolean getIsDatacenter() {
        return this.isDatacenter;
    }

    public void setIsDatacenter(boolean datacenter) {
        this.isDatacenter = datacenter;
    }

    public Boolean getUploadgroupSuccessfull() {
        return this.uploadgroupSuccessfull;
    }

    public void setUploadgroupSuccessfull(Boolean uploadgroupSuccessfull) {
        this.uploadgroupSuccessfull = uploadgroupSuccessfull;
    }

    public Boolean getUserManagementGroupsSubmitted() {
        return this.userManagementGroupsSubmitted;
    }

    public void setUserManagementGroupsSubmitted(Boolean userManagementGroupsSubmitted) {
        this.userManagementGroupsSubmitted = userManagementGroupsSubmitted;
    }

    public Boolean getUserManagementGroupsDeletionSubmitted() {
        return this.userManagementGroupsDeletionSubmitted;
    }

    public void setUserManagementGroupsDeletionSubmitted(Boolean userManagementGroupsDeletionSubmitted) {
        this.userManagementGroupsDeletionSubmitted = userManagementGroupsDeletionSubmitted;
    }

    public Boolean getUsermanagementGroupsUploadSubmitted() {
        return this.usermanagementGroupsUploadSubmitted;
    }

    public void setUsermanagementGroupsUploadSubmitted(Boolean usermanagementGroupsUploadSubmitted) {
        this.usermanagementGroupsUploadSubmitted = usermanagementGroupsUploadSubmitted;
    }

    public ArrayList<String> getGroupToAddCsv() {
        return this.groupToAddCsv;
    }

    public void setGroupToAddCsv(ArrayList<String> groupToAddCsv) {
        this.groupToAddCsv = groupToAddCsv;
    }

    public String getGroupsToDelete() {
        return this.groupsToDelete;
    }

    public void setGroupsToDelete(String groupsToDelete) {
        this.groupsToDelete = groupsToDelete;
    }

    public ArrayList<String> getGroupsToDeleteList() {
        return this.groupsToDeleteList;
    }

    public void setGroupsToDeleteList(ArrayList<String> groupsToDeleteList) {
        this.groupsToDeleteList = groupsToDeleteList;
    }

    public String getGroupManagementSelectedAction() {
        return this.groupManagementSelectedAction;
    }

    public void setGroupManagementSelectedAction(String groupManagementSelectedAction) {
        this.groupManagementSelectedAction = groupManagementSelectedAction;
    }

    public String getCreationSelection() {
        return this.creationSelection;
    }

    public void setCreationSelection(String creationSelection) {
        this.creationSelection = creationSelection;
    }

    public static Log getLOGGER() {
        return LOGGER;
    }

    public static void setLOGGER(Log LOGGER) {
        BulkGroupManagementAction.LOGGER = LOGGER;
    }

    public String getGroupsToCreate() {
        return this.groupsToCreate;
    }

    public void setGroupsToCreate(String groupsToCreate) {
        this.groupsToCreate = groupsToCreate;
    }

    public Boolean getMaxUsersLicense() {
        return this.maxUsersLicense;
    }

    public void setMaxUsersLicense(Boolean maxUsersLicense) {
        this.maxUsersLicense = maxUsersLicense;
    }

    public ArrayList<String> getGroupList() {
        return this.groupList;
    }

    public void setGroupList(ArrayList<String> groupList) {
        this.groupList = groupList;
    }

    public ArrayList<String> getCurrentPageGroupsList() {
        return this.currentPageGroupsList;
    }

    public void setCurrentPageGroupsList(ArrayList<String> currentPageGroupsList) {
        this.currentPageGroupsList = currentPageGroupsList;
    }

    public String getGroupSearchKeyword() {
        return this.groupSearchKeyword;
    }

    public void setGroupSearchKeyword(String groupSearchKeyword) {
        this.groupSearchKeyword = groupSearchKeyword;
    }

    public Integer getSelectedPage() {
        return this.selectedPage;
    }

    public void setSelectedPage(Integer selectedPage) {
        this.selectedPage = selectedPage;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public Integer getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(Integer endIndex) {
        this.endIndex = endIndex;
    }

    public Integer getNumberOfPages() {
        return this.numberOfPages;
    }

    public void setNumberOfPages(Integer numberOfPages) {
        this.numberOfPages = numberOfPages;
    }

    public Integer getNumberOfRecordsPerPage() {
        return this.numberOfRecordsPerPage;
    }

    public void setNumberOfRecordsPerPage(Integer numberOfRecordsPerPage) {
        this.numberOfRecordsPerPage = numberOfRecordsPerPage;
    }

    public Integer getGroupPerPage() {
        return this.groupPerPage;
    }

    public void setGroupPerPage(Integer groupPerPage) {
        this.groupPerPage = groupPerPage;
    }

    public List<String> getNumberOfPagesList() {
        this.numberOfPagesList = new ArrayList<String>();
        for (int i = 1; i <= this.numberOfPages; ++i) {
            this.numberOfPagesList.add("" + i);
        }
        return this.numberOfPagesList;
    }

    public void setNumberOfPagesList(List<String> numberOfPagesList) {
        this.numberOfPagesList = numberOfPagesList;
    }

    public Boolean getEvaluationLicense() {
        return this.evaluationLicense;
    }

    public void setEvaluationLicense(Boolean evaluationLicense) {
        this.evaluationLicense = evaluationLicense;
    }

    public UserDeactivaterScheduler getUserDeactivaterScheduler() {
        return this.userDeactivaterScheduler;
    }

    public void setUserDeactivaterScheduler(UserDeactivaterScheduler userDeactivaterScheduler) {
        this.userDeactivaterScheduler = userDeactivaterScheduler;
    }
}

