/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.scheduler;

import com.atlassian.confluence.core.InsufficientPrivilegeException;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.login.LoginInfo;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.directory.ssl.LdapHostnameVerificationSSLSocketFactory;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import com.atlassian.spring.container.ContainerManager;
import com.miniorange.usermanagement.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.scheduler.UserDeactivaterTask;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserDeactivaterScheduler
implements LifecycleAware {
    private static Log LOGGER = LogFactory.getLog(UserDeactivaterScheduler.class);
    private LoginManager loginManager;
    private ConfluenceUserManagementUtility UserManagementUtility;
    private UserAccessor userAccessor;
    private PermissionManager permissionManager;
    private UserManagementPluginSettings settings;
    private UserManagementPluginHandler pluginHandler;
    public static final String KEY = UserDeactivaterTask.class.getName() + ":instance";
    private static final String JOB_NAME = UserDeactivaterScheduler.class.getName() + ":job";
    private final PluginScheduler pluginScheduler;

    public UserDeactivaterScheduler(PluginScheduler pluginScheduler, UserManagementPluginSettings settings, ConfluenceUserManagementUtility userManagementUtility, UserAccessor userAccessor, LoginManager loginManager, PermissionManager permissionManager, UserManagementPluginHandler pluginHandler) {
        this.pluginScheduler = pluginScheduler;
        this.settings = settings;
        this.UserManagementUtility = userManagementUtility;
        this.userAccessor = userAccessor;
        this.permissionManager = permissionManager;
        this.loginManager = loginManager;
        this.pluginHandler = pluginHandler;
    }

    public void schedule() {
        LOGGER.error("Scheduleing job");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        InetAddress ip = null;
        try {
            ip = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        String jobName = JOB_NAME;
        long refreshIntervalInMiliseconds = this.settings.getScheduler_days() * 86400000L;
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2);
        int dayOfMonth = cal.get(5);
        GregorianCalendar calendarCustom = new GregorianCalendar(year, month, dayOfMonth, (int)this.settings.getCustomSchedulerTimeHour(), (int)this.settings.getCustomSchedulerTimeMinute());
        if (calendarCustom.getTimeInMillis() < cal.getTimeInMillis()) {
            LOGGER.debug("inside custom time < current time");
            ((Calendar)calendarCustom).add(5, (int)this.settings.getScheduler_days());
        }
        cal.setTime(new Date());
        cal.add(13, 3);
        SimpleDateFormat formatterScheduler = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        this.settings.setNextSchedulerDate(formatterScheduler.format(calendarCustom.getTime()));
        this.pluginHandler.storeAuditLogs(confluenceUser.getName(), ip.getHostAddress(), "Scheduler Enabled", "Enable Auto Deactivate User Scheduler.");
        this.pluginScheduler.scheduleJob(jobName, UserDeactivaterTask.class, (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put(KEY, UserDeactivaterScheduler.this);
            }
        }, calendarCustom.getTime(), refreshIntervalInMiliseconds);
    }

    public void unschedule() {
        LOGGER.error("Unscheduleing job");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        InetAddress ip = null;
        try {
            ip = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.pluginHandler.storeAuditLogs(confluenceUser.getName(), ip.getHostAddress(), "Scheduler Disabled", "Disable Auto Deactivate User Scheduler.");
        try {
            String jobName = JOB_NAME;
            this.pluginScheduler.unscheduleJob(jobName);
        }
        catch (IllegalArgumentException t) {
            LOGGER.debug("No JOB exist. Can't unschedule.");
        }
        catch (Throwable t) {
            LOGGER.debug("An Error occurred while unscheduleing JOB");
        }
    }

    @Override
    public void onStart() {
        this.schedule();
    }

    @Override
    public void onStop() {
        try {
            this.unschedule();
        }
        catch (IllegalArgumentException t) {
            LOGGER.debug("No JOB exist. Can't unschedule.");
        }
        catch (Throwable t) {
            LOGGER.debug("An Error occurred while unscheduleing JOB");
        }
    }

    public Boolean CheckLastLoginTime() throws ParseException, UnknownHostException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        LOGGER.debug("inside CheckLastLoginTime");
        ArrayList excludeGroups = (ArrayList)this.settings.getExcludeGroups();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        SimpleDateFormat formatterScheduler = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        this.settings.setPrevSchedulerDate(formatterScheduler.format(cal.getTime()));
        this.settings.setPreviousSchedulerFlag(Boolean.FALSE);
        cal.setTime(this.settings.getPrevSchedulerDate());
        cal.add(5, (int)this.settings.getScheduler_days());
        this.settings.setNextSchedulerDate(formatterScheduler.format(cal.getTime()));
        InetAddress ip = InetAddress.getLocalHost();
        if (this.UserManagementUtility.isEvaluationLicense().booleanValue()) {
            if (!this.UserManagementUtility.isValidEvaluationLicense().booleanValue()) {
                LOGGER.debug("Invalid License ");
                return null;
            }
        } else if (!this.UserManagementUtility.isSubscriptionLicense().booleanValue()) {
            LOGGER.debug("Invalid License ");
            return null;
        }
        if (this.settings.getAutoDeActivateUsers().booleanValue()) {
            String usernameSearchKeyword = "";
            long interval = this.settings.getNumberOfDays() * 86400000L;
            long creationInterval = this.settings.getNumberofDaysAfterUserCreation() * 86400000L;
            List<User> usernameList = this.UserManagementUtility.getUserFromConfluenceUsingUsername(Boolean.FALSE, false, usernameSearchKeyword, "AllUsers", new ArrayList<String>());
            Date date = new Date();
            long timeMilli = date.getTime();
            long Lastday = timeMilli - interval;
            for (User currentUser : usernameList) {
                LOGGER.debug("Checking User  :- " + currentUser.getName());
                if (this.userAccessor.hasMembership("confluence-administrators", currentUser.getName()) || this.userAccessor.isDeactivated(currentUser.getName())) continue;
                ConfluenceUser checkUser = this.userAccessor.getUserByName(currentUser.getName());
                LoginInfo loginInfo = this.loginManager.getLoginInfo((com.atlassian.user.User)checkUser);
                Boolean skipUserDeactivation = false;
                if (this.settings.getEnableExcludeGroups().booleanValue()) {
                    List userGroups = this.userAccessor.getGroupNames((com.atlassian.user.User)checkUser);
                    for (String userGroup : userGroups) {
                        for (String excludeGroup : excludeGroups) {
                            LOGGER.debug("userGroup = " + userGroup);
                            LOGGER.debug("excludeGroup = " + excludeGroup);
                            if (!userGroup.equals(excludeGroup)) continue;
                            skipUserDeactivation = true;
                            break;
                        }
                        if (!skipUserDeactivation.booleanValue()) continue;
                        break;
                    }
                }
                cal = Calendar.getInstance();
                Thread currentThread = Thread.currentThread();
                ClassLoader origCCL = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(LdapHostnameVerificationSSLSocketFactory.class.getClassLoader());
                AuthenticatedUserThreadLocal.set((ConfluenceUser)this.getConfluenceAdministrator());
                if (loginInfo.getLastSuccessfulLoginDate() != null) {
                    cal.setTime(loginInfo.getLastSuccessfulLoginDate());
                    long lastlogintime = cal.getTimeInMillis();
                    if (lastlogintime >= Lastday || skipUserDeactivation.booleanValue()) continue;
                    try {
                        this.userAccessor.deactivateUser((com.atlassian.user.User)this.userAccessor.getUserByName(currentUser.getName()));
                        this.pluginHandler.storeAuditLogs(currentUser.getName(), ip.getHostAddress(), "User Deactivated", "Deactivate User By Last Login Time using Scheduler.");
                    }
                    catch (InsufficientPrivilegeException t) {
                        LOGGER.debug("Error InsufficientPrivilegeException = " + t.toString());
                    }
                    catch (Throwable t) {
                        LOGGER.debug("Error in task else " + t.getMessage());
                    }
                    continue;
                }
                if (!this.settings.getAutoDeactivateNeverLoggedInUser().booleanValue() || loginInfo.getLastSuccessfulLoginDate() != null || skipUserDeactivation.booleanValue()) continue;
                try {
                    this.userAccessor.deactivateUser((com.atlassian.user.User)this.userAccessor.getUserByName(currentUser.getName()));
                    this.pluginHandler.storeAuditLogs(currentUser.getName(), ip.getHostAddress(), "User Deactivated", "Deactivate Never Logged-in User using Scheduler.");
                }
                catch (InsufficientPrivilegeException t) {
                    LOGGER.debug("Error InsufficientPrivilegeException = " + t.toString());
                }
                catch (Throwable t) {
                    LOGGER.debug("Error in task else " + t.getMessage());
                }
            }
        } else {
            LOGGER.debug("Disable auto Deactivate users");
            return false;
        }
        return true;
    }

    public ConfluenceUser getConfluenceAdministrator() {
        UserAccessor userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        List confluenceAdministrators = userAccessor.getMemberNamesAsList(userAccessor.getGroup("confluence-administrators"));
        if (confluenceAdministrators != null && confluenceAdministrators.size() > 0) {
            for (String user : confluenceAdministrators) {
                ConfluenceUser confluenceAdminUser = userAccessor.getUserByName(user);
                LOGGER.error("Confluence Admin User = " + confluenceAdminUser);
                if (this.permissionManager.isSystemAdministrator((com.atlassian.user.User)confluenceAdminUser) && !userAccessor.isDeactivated((com.atlassian.user.User)confluenceAdminUser)) {
                    return confluenceAdminUser;
                }
                LOGGER.debug("Confluence Admin User = " + confluenceAdminUser + " does not have system admin permission or user is deactivated, continue with search...");
            }
        }
        return null;
    }

    public PluginScheduler getPluginScheduler() {
        return this.pluginScheduler;
    }

    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    public LoginManager getLoginManager() {
        return this.loginManager;
    }

    public void setLoginManager(LoginManager loginManager) {
        this.loginManager = loginManager;
    }

    public ConfluenceUserManagementUtility getUserManagementUtility() {
        return this.UserManagementUtility;
    }

    public void setUserManagementUtility(ConfluenceUserManagementUtility userManagementUtility) {
        this.UserManagementUtility = userManagementUtility;
    }

    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }
}

