AJS.$(document).ready(function() {

    if ( window.history.replaceState ) {
        window.history.replaceState( null, null, window.location.href );
    }
    $(window).off('beforeunload');
    mOFetchGroups("groupSearchKey");
    mOFetchGroups("deactivateGroupSearchKeyTrigger");
    AJS.$("#exportUserId").tooltip({gravity: 'n'});

});

function deleteSelectedUser(username, showInfoDialog) {
        console.log("Calling deleteSelectedUser");
        jQuery.ajax({
            url: AJS.contextPath() + "/plugins/servlet/usermanagement/moapi",
            data: {
                "action": "BulkDeleteSelectedUser",
                "username": username
            },
            type: "GET",
            success: function (response) {
                console.log("Calling sucess");
                require('aui/flag')({
                    title: 'Deleting User',
                    type: 'success',
                    close: 'auto',
                    body: '<p>Sucessefully deleted User: '+username+'</p>'
                });
                setTimeout(function() {
                    location.reload();
                }, 5000);
            },
            error: function (response) {
                console.log("Calling error");

                if (response.responseText == "Error_User_Is_Admin") {
                    require('aui/flag')({
                        title: 'Deleting Admin User',
                        type: 'error',
                        close: 'auto',
                        body: '<p>Cant delete Admin User : ' + username + '</p>'
                    });
                }
                else if (response.responseText == "Error_User_License") {
                    require('aui/flag')({
                        title: 'No license found for app.',
                        type: 'error',
                        close: 'auto',
                        body: '<p>Cant delete User. : ' + username + '</p>'
                    });
                } else if (response.responseText == "Error_Admin_Privilege") {
                    require('aui/flag')({
                        title: 'You do not have administrator Privilege.',
                        type: 'error',
                        close: 'auto',
                        body: '<p>Cant delete User. : ' + username + '</p>'
                    });
                }
                else {
                    require('aui/flag')({
                        title: 'Deleting User',
                        type: 'error',
                        close: 'auto',
                        body: '<p>Issue with deleting User : ' + username + '</p>'
                    });
                }
            },
            async: false
        });
    }

function toggleAllUsers() {
    var isChecked = document.getElementById("selectAllUsers").checked;
    var startIndex = document.getElementById("startIndex").value;
    var endIndex = document.getElementById("endIndex").value - 1;

    for (var i=startIndex;i<=endIndex;i++) {
        document.getElementById("selectedUser"+i).checked = isChecked;
    }
}

function selectUserAction() {
    $('body').on('change','#bulkActiononuser', function() {
        switch (this.value) {
            case "Delete Selected Users":
                hideDevTriggerAction("addRemoveMembership");
                document.getElementById('bulkActionongroup').setAttribute("disabled","disabled");
                $("#bulkActionongroup").val("Action");
                break;

            case "Activate Selected Users":
            case "Deactivate Selected Users":
                document.getElementById('bulkActionongroup').removeAttribute("disabled");

                break;
        }
    });
}

function performBulkAction() {
    var action = document.getElementById("bulkActiononuser");
    var action1 = document.getElementById("bulkActionongroup");

    if (action.value =="Action" && action1.value == "Action"  ) {
        document.getElementById("bulkActiononuser").style.borderColor = "red";
        document.getElementById("bulkActionongroup").style.borderColor = "red";
        var dialog = new AJS.Dialog({
            width: 400,
            height: 150,
            id: "delete-dialog",
            closeOnOutsideClick: true
        });
        dialog.addPanel("Panel 1", "<p> Please select valid Bulk Action. <b> </b></p>", "panel-body");
        dialog.addLink("Retry", function (dialog) {
            dialog.hide();
        }, "#");

        dialog.show();
    }
    else {
        document.getElementById("bulkActiononuser").style.borderColor = "";
        document.getElementById("bulkActionongroup").style.borderColor = "";
        console.log("Selected Action : "+action.value);
        var startIndex = document.getElementById("startIndex").value;
        var endIndex = document.getElementById("endIndex").value - 1;
        var AllowedUsers = endIndex;
        jQuery.ajax({
            url: AJS.contextPath()+"/plugins/servlet/usermanagement/moapi",
            data: {
                "action": "CheckEvalLicense"
            },
            type: "GET",
            async: false,
            error: function (response) {
                if(response.responseText == "Error_User_eval_License"){

                    if(endIndex > 9){
                        AllowedUsers = 9;
                    }

                    console.log("evaluation found");
                    require('aui/flag')({
                        title: 'Evaluation License found',
                        type: 'info',
                        body: '<p>Features will work on only first 10 users</p>'
                    });

                }
            }
        });

        switch (action.value) {
            case "Delete Selected Users":
                console.log("delete selected users");

                var dialog = new AJS.Dialog({
                    width: 400,
                    height: 150,
                    id: "delete-dialog",
                    closeOnOutsideClick: true
                });
                dialog.addPanel("Panel 1", "<p>Are you sure you want to delete the user? <b> </b></p>", "panel-body");
                dialog.addButton("Yes", function (dialog) {

                    var isCustomerSelected = false;

                    for (var i=startIndex;i<=endIndex;i++) {
                        var isChecked = document.getElementById("selectedUser"+i).checked;
                        if (isChecked == true) {
                            isCustomerSelected = true;
                            if(i<=AllowedUsers)
                            {
                                deleteSelectedUser(document.getElementById("selectedUser"+i).value, false);
                            }

                        }
                    }
                    noUserSelectedErrorMsg(isCustomerSelected);

                    dialog.hide();

                    setTimeout(function() {
                        location.reload();
                    }, 5000);

                });
                dialog.addLink("No", function (dialog) {
                    dialog.hide();
                }, "#");

                dialog.show();

                break;
            case "Activate Selected Users":
                console.log("activate selected Users ");
                var isCustomerSelected = false;
                var groupsToAdd = $('#RemoveAddGroupSearchLabel').val();
                for (var i=startIndex;i<=endIndex;i++) {
                    var isChecked = document.getElementById("selectedUser"+i).checked;
                    if (isChecked == true) {
                        isCustomerSelected = true;
                        if(i<=AllowedUsers)
                        {
                            ActivateSelectedUser(document.getElementById("selectedUser"+i).value, false, groupsToAdd);
                        }
                    }
                }
                noUserSelectedErrorMsg(isCustomerSelected);

                setTimeout(function() {
                    location.reload();
                }, 5000);

                break;
            case "Deactivate Selected Users":
                console.log("deactivate selecetde users");
                var isCustomerSelected = false;
                var groupsToRemove = $('#RemoveAddGroupSearchLabel').val();

                for (var i=startIndex;i<=endIndex;i++) {
                    var isChecked = document.getElementById("selectedUser"+i).checked;
                    if (isChecked == true) {
                        isCustomerSelected = true;
                        if(i<=AllowedUsers)
                        {
                             DeactivateSelectedUser(document.getElementById("selectedUser"+i).value, false, groupsToRemove);
                        }

                    }
                }
                noUserSelectedErrorMsg(isCustomerSelected);

                setTimeout(function() {
                    location.reload();
                }, 5000);
                break;
        }

        switch (action1.value){
            case "Remove Groups from User":
                console.log("inside remove group from user");
                var isCustomerSelected = false;
                var groupsToRemove = $('#deactivateGroupSearchKeyTrigger').val();

                if(groupsToRemove === ""){
                    var dialog = new AJS.Dialog({
                        width: 400,
                        height: 150,
                        id: "delete-dialog",
                        closeOnOutsideClick: true
                    });
                    dialog.addPanel("Panel 1", "<p> Please select Groups to perform Bulk Action. <b> </b></p>", "panel-body");
                    dialog.addLink("Retry", function (dialog) {
                        dialog.hide();
                    }, "#");

                    dialog.show();
                    return;
                }

                for (var i=startIndex;i<=endIndex;i++) {
                    var isChecked = document.getElementById("selectedUser"+i).checked;
                    if (isChecked == true) {
                        isCustomerSelected = true;
                        if(i<=AllowedUsers)
                        {
                            removeUserFromGroups(document.getElementById("selectedUser"+i).value, false, groupsToRemove);
                        }

                    }
                }
                noUserSelectedErrorMsg(isCustomerSelected);
                setTimeout(function() {
                    location.reload();
                }, 5000);
                break;
            case "Add Groups to the User":
                console.log("inside add group to the user");
                var isCustomerSelected = false;
                var groupsToAdd = $('#deactivateGroupSearchKeyTrigger').val();

                if(groupsToAdd === ""){
                    var dialog = new AJS.Dialog({
                        width: 400,
                        height: 150,
                        id: "delete-dialog",
                        closeOnOutsideClick: true
                    });
                    dialog.addPanel("Panel 1", "<p> Please select Groups to perform Bulk Action. <b> </b></p>", "panel-body");
                    dialog.addLink("Retry", function (dialog) {
                        dialog.hide();
                    }, "#");

                    dialog.show();
                    return;
                }

                for (var i=startIndex;i<=endIndex;i++) {
                    var isChecked = document.getElementById("selectedUser"+i).checked;
                    if (isChecked == true) {
                        isCustomerSelected = true;
                        if(i<=AllowedUsers)
                        {
                            assignGroupsToUser(document.getElementById("selectedUser"+i).value, false, groupsToAdd);
                        }

                    }
                }
                noUserSelectedErrorMsg(isCustomerSelected);
                setTimeout(function() {
                    location.reload();
                }, 5000);
                break;
        }
    }
}

function removeUserFromGroups(username, showInfoDialog,groupsToRemove){
    console.log("Calling removeUserFromGroups");
    jQuery.ajax({
        url: AJS.contextPath()+"/plugins/servlet/usermanagement/moapi",
        data: {
            "action": "removeUserFromGroups",
            "username": username,
            "groupsToRemove": groupsToRemove
        },
        type: "GET",
        success: function (response) {
            console.log("Calling success removeUserFromGroups");
            require('aui/flag')({
                title: 'Remove Group',
                type: 'success',
                close: 'auto',
                body: '<p>Successfully Removed Groups of : '+username  +'</p>'

            });
        },
        error: function (response) {

            if(response.responseText == "Error_User_Is_Admin")
            {
                require('aui/flag')({
                    title: 'Remove Group',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Cant Remove Group of Admin User : '+username  +'</p>'
                });
            }else if(response.responseText == "Error_User_License"){
                require('aui/flag')({
                    title: 'No license found',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Cannot perform the requested operation</p>'
                });
            }
            else if( response.responseText == "Error_Admin_Privilege"){
                require('aui/flag')({
                    title: 'You do not have administrator privilege',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Cant Remove Group </p>'
                });
            }
            else if(response.responseText == "Error_Group_Not_Exists"){
                require('aui/flag')({
                    title: 'User not present in group',
                    type: 'error',
                    close: 'auto',
                    body: '<p>User not present In Selecetd Group </p>'
                });
            }
            else{
                console.log("Calling error removeUserFromGroups");
                require('aui/flag')({
                    title: 'Remove Group',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Issue with Removing Groups of User : '+username+'</p>'
                });
                return false;
            }
        },
        async: false
    });
}

function DeactivateSelectedUser(username, showInfoDialog,groupsToRemove){
    console.log("Calling DeactivateSelectedUser");
    jQuery.ajax({
        url: AJS.contextPath()+"/plugins/servlet/usermanagement/moapi",
        data: {
            "action": "BulkDeactivateSelectedUser",
            "username": username,
            "groupsToRemove": groupsToRemove
        },
        type: "GET",
        success: function (response) {
            console.log("Calling success DeactivateSelectedUser");
            require('aui/flag')({
                title: 'Deactivated User',
                type: 'success',
                close: 'auto',
                body: '<p>Successfully Deactivated : '+username  +'</p>'

            });
        },
        error: function (response) {

            if(response.responseText == "Error_User_Is_Admin")
            {
                require('aui/flag')({
                    title: 'Deactivating Admin User',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Cant Deactivate the Admin User : '+username  +'</p>'
                });
            }else if(response.responseText == "Error_User_License"){
                require('aui/flag')({
                    title: 'No license found',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Cannot perform the requested operation</p>'
                });
            }
            else if( response.responseText == "Error_Admin_Privilege"){
                require('aui/flag')({
                    title: 'You do not have administrator privilege',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Cant Deactivate User. : '+username  +'</p>'
                });
            }
            else if( response.responseText == "Error_User_Is_Inactive"){
                require('aui/flag')({
                    title: 'User is inactive',
                    type: 'error',
                    close: 'auto',
                    body: '<p>User Is Already Inactive : '+username  +'</p>'
                });
            }
            else{
                console.log("Calling error DeactivateSelectedUser");
                require('aui/flag')({
                    title: 'Deactivate User',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Issue with Deactivating User : '+username+'</p>'
                });
                return false;
            }
        },
        async: false
    });
}

function slectUserGroup() {

      console.log("inside slectUserGroup ")

        var action = document.getElementById("bulkActionongroup");

        switch (action.value) {
            case "Action":
                hideDevTriggerAction("addRemoveMembership");
                break;

            case "Remove Groups from User":
            case "Add Groups to the User":
                showDevTriggerAction("addRemoveMembership");
                break;

        }

}

function showDevTriggerAction (divid) {
    var value = document.getElementById(divid);
    if (value.style.display === "none") {
        AJS.$('#'+divid).show("slow");
    }
}

function hideDevTriggerAction (divid) {
    var value = document.getElementById(divid);
    if (value.style.display != "none"){
        AJS.$('#'+divid).hide("slow");
    }
}

function noUserSelectedErrorMsg(isCustomerSelected) {
    if (!isCustomerSelected) {
        require('aui/flag')({
            title: 'User Not selected',
            type: 'error',
            close: 'auto',
            body: '<p>Please Select the User to perform the Action </p>'
        });
    }
}

function ActivateSelectedUser(username, showInfoDialog, groupsToAdd) {
    console.log("Calling ActivateSelectedUser");
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/usermanagement/moapi",
        data: {
            "action": "BulkActivateSelectedUser",
            "username": username,
            "groupsToAdd": groupsToAdd
        },
        type: "GET",
        success: function (response) {
            console.log("Calling success ActivateSelectedUser");
            require('aui/flag')({
                title: 'Activated User',
                type: 'success',
                close: 'auto',
                body: '<p>Successfully Activated : '+username  +'</p>'
            });
        },
        error: function (response) {

            if( response.responseText == "Error_Admin_Privilege"){
                require('aui/flag')({
                    title: 'You do not have administrator privilege',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Cant Activate User. : '+username  +'</p>'
                });
            }
            else if(response.responseText == "Error_User_License"){
                require('aui/flag')({
                    title: 'No license found',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Cannot perform the requested operation</p>'
                });
            }
            else if(response.responseText == "Error_User_Is_Active"){
                require('aui/flag')({
                    title: 'Already Active User ',
                    type: 'error',
                    close: 'auto',
                    body: '<p>User is already activated :- '+ username+ ' </p>'
                });
            }
            else{
                console.log("Calling error ActivateSelectedUser");
                require('aui/flag')({
                    title: 'Activate User',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Issue with Activating User : '+username+'</p>'
                });
            }
        },
        async: false
    });
}

function assignGroupsToUser(username, showInfoDialog, groupsToAdd) {
    console.log("Calling assignGroupsToUser");
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/usermanagement/moapi",
        data: {
            "action": "assignGroupsToUser",
            "username": username,
            "groupsToAdd": groupsToAdd
        },
        type: "GET",
        success: function (response) {
            console.log("Calling success assignGroupsToUser");
            require('aui/flag')({
                title: 'Added to Group',
                type: 'success',
                close: 'auto',
                body: '<p>Successfully Added User ' +username+' to selected Groups. </p>'
            });
        },
        error: function (response) {

            if( response.responseText == "Error_Admin_Privilege"){
                require('aui/flag')({
                    title: 'You do not have administrator privilege',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Cant Add user '+username+' In Groups.</p>'
                });
            }
            else if(response.responseText == "Error_User_License"){
                require('aui/flag')({
                    title: 'No license found',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Cannot perform the requested operation</p>'
                });
            }
            else{
                console.log("Calling error assignGroupsToUser");
                require('aui/flag')({
                    title: 'Activate User',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Issue with Adding Groups to User : '+username+'</p>'
                });
            }
        },
        async: false
    });
}
