/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.utility;

import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.miniorange.usermanagement.common.UserManagementPluginSettings;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfluenceUserManagementUtility {
    private static Log LOGGER = LogFactory.getLog(ConfluenceUserManagementUtility.class);
    private CrowdService crowdService;
    private PluginLicenseManager pluginLicenseManager;
    private LoginManager loginManager;
    private UserAccessor userAccessor;
    private UserManagementPluginSettings settting;

    public ConfluenceUserManagementUtility(CrowdService crowdService, PluginLicenseManager pluginLicenseManager, LoginManager loginManager, UserAccessor userAccessor, UserManagementPluginSettings settting) {
        this.crowdService = crowdService;
        this.pluginLicenseManager = pluginLicenseManager;
        this.loginManager = loginManager;
        this.userAccessor = userAccessor;
        this.settting = settting;
    }

    public List<User> getUserFromConfluenceUsingUsername(Boolean fromUserManagement, Boolean sortByLastLogin, String usernameSearchKeyword, String userSearchFilter, List<String> groupSearchList) {
        LOGGER.debug("getUserFromConfluenceUsingUsername");
        ArrayList availableUser = new ArrayList();
        Object activeUser = null;
        Object inactiveUser = null;
        ArrayList<List> userLists = new ArrayList<List>();
        ArrayList usersList = new ArrayList();
        List finalUserList = new ArrayList();
        ArrayList<User> userListToReturn = new ArrayList<User>();
        ArrayList<User> userListToReturnNull = new ArrayList<User>();
        ArrayList<User> userListToReturnNotNull = new ArrayList<User>();
        String groupSearchKey = "";
        MembershipQuery queryForGroup = null;
        EntityQuery query = null;
        if (groupSearchList.size() > 0) {
            for (int i = 0; i < groupSearchList.size(); ++i) {
                groupSearchKey = groupSearchList.get(i);
                if (!StringUtils.isNotBlank(groupSearchKey)) continue;
                if (StringUtils.equalsIgnoreCase(userSearchFilter, "AllUsers") || userSearchFilter.isEmpty()) {
                    LOGGER.debug("Get all Users using Group Filter");
                    queryForGroup = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withNames(new String[]{groupSearchKey}).returningAtMost(-1);
                } else if (StringUtils.equalsIgnoreCase(userSearchFilter, "ActiveUsers")) {
                    LOGGER.debug("Get active users using Group Filter");
                    queryForGroup = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withNames(new String[]{groupSearchKey}).returningAtMost(-1);
                } else if (StringUtils.equalsIgnoreCase(userSearchFilter, "InactiveUsers")) {
                    LOGGER.debug("Get inactive users using Group Filter");
                    queryForGroup = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withNames(new String[]{groupSearchKey}).returningAtMost(-1);
                }
                userLists.add((List)this.crowdService.search(queryForGroup));
            }
            if (userLists.size() > 0) {
                usersList.addAll((Collection)userLists.get(0));
                ListIterator iter = userLists.listIterator(0);
                while (iter.hasNext()) {
                    usersList.retainAll((Collection)iter.next());
                }
            }
            finalUserList = usersList;
        } else {
            if (StringUtils.equalsIgnoreCase(userSearchFilter, "AllUsers") || userSearchFilter.isEmpty()) {
                LOGGER.debug("Get all User");
                query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)usernameSearchKeyword)).returningAtMost(-1);
            } else if (StringUtils.equalsIgnoreCase(userSearchFilter, "ActiveUsers")) {
                LOGGER.debug("Get active users");
                query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.ACTIVE).containing((Object)true), Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)usernameSearchKeyword)})).returningAtMost(-1);
            } else if (StringUtils.equalsIgnoreCase(userSearchFilter, "InactiveUsers")) {
                LOGGER.debug("Get inactive users");
                query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.ACTIVE).containing((Object)false), Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)usernameSearchKeyword)})).returningAtMost(-1);
            }
            finalUserList = (List)this.crowdService.search((Query)query);
        }
        Collections.sort(finalUserList);
        HashMap<Long, User> userListWithLastLogin = new HashMap<Long, User>();
        for (User user : finalUserList) {
            ConfluenceUser checkUser = this.userAccessor.getUserByName(user.getName());
            if (this.loginManager.getLoginInfo((com.atlassian.user.User)checkUser).getLastSuccessfulLoginDate() == null) {
                userListToReturnNull.add(user);
                continue;
            }
            if (fromUserManagement.booleanValue()) {
                try {
                    Long l = this.loginManager.getLoginInfo((com.atlassian.user.User)checkUser).getLastSuccessfulLoginDate().getTime();
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                    String startDateString = this.settting.getStart_date_lastLoginTime();
                    Date startDate = formatter.parse(startDateString);
                    String endDateString = this.settting.getEnd_date_lastLoginTime();
                    Date endDate = formatter.parse(endDateString);
                    if (l < startDate.getTime() || l > endDate.getTime() + 86400000L) continue;
                    userListToReturnNotNull.add(user);
                    userListWithLastLogin.put(this.loginManager.getLoginInfo((com.atlassian.user.User)checkUser).getLastSuccessfulLoginDate().getTime(), user);
                }
                catch (Exception exception) {
                    LOGGER.error("error :" + exception.getMessage());
                }
                continue;
            }
            userListToReturnNotNull.add(user);
            userListWithLastLogin.put(this.loginManager.getLoginInfo((com.atlassian.user.User)checkUser).getLastSuccessfulLoginDate().getTime(), user);
        }
        if (BooleanUtils.toBoolean(sortByLastLogin)) {
            Set sorted = userListWithLastLogin.entrySet();
            ArrayList sortedList = new ArrayList(sorted);
            Collections.sort(sortedList, Comparator.comparing(Map.Entry::getKey));
            for (Map.Entry entry : sortedList) {
                userListToReturn.add((User)entry.getValue());
            }
            Collections.reverse(userListToReturn);
            userListToReturn.addAll(userListToReturnNull);
            return userListToReturn;
        }
        userListToReturn.addAll(userListToReturnNotNull);
        userListToReturn.addAll(userListToReturnNull);
        return userListToReturn;
    }

    public String getCurrentIpAddress(HttpServletRequest request) {
        String remoteAddr = "";
        if (request != null && (StringUtils.isBlank(remoteAddr = request.getHeader("X-FORWARDED-FOR")) || StringUtils.isEmpty(remoteAddr))) {
            remoteAddr = request.getRemoteAddr();
        }
        return remoteAddr;
    }

    public List<String> getAllGroups(String groupRegexPattern) {
        String startWith = "";
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)startWith)).returningAtMost(-1);
        ArrayList<String> existingGroups = new ArrayList<String>();
        Iterable groups = this.crowdService.search((Query)query);
        for (Group groupObject : groups) {
            if (!StringUtils.containsIgnoreCase(groupObject.getName(), groupRegexPattern.trim())) continue;
            existingGroups.add(groupObject.getName().trim());
        }
        return existingGroups;
    }

    public List<String> getSelectedDetailsForPagination(List<String> detailsList, Integer groupsPerPage, Integer startIndex, Integer endIndex) {
        ArrayList<String> selectedDetailsPagination = new ArrayList<String>();
        for (int i = startIndex.intValue(); i < startIndex + groupsPerPage && i <= endIndex && i < detailsList.size(); ++i) {
            selectedDetailsPagination.add(detailsList.get(i));
        }
        Collections.sort(selectedDetailsPagination);
        return selectedDetailsPagination;
    }

    public int getMaxUsers() {
        int t = 0;
        try {
            if (this.pluginLicenseManager.getLicense().isDefined()) {
                t = (Integer)((PluginLicense)this.pluginLicenseManager.getLicense().get()).getEdition().get();
            }
        }
        catch (Exception e) {
            return -1;
        }
        return t;
    }

    public Boolean isValidEvaluationLicense() {
        return ((PluginLicense)this.pluginLicenseManager.getLicense().get()).isValid();
    }

    public Boolean isEvaluationLicense() {
        if (this.isLicenseDefined().booleanValue()) {
            PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            LOGGER.debug("pluginLicense.isEvaluation() :- " + pluginLicense.isEvaluation());
            return pluginLicense.isEvaluation();
        }
        return Boolean.FALSE;
    }

    public Boolean isSubscriptionLicense() {
        if (this.isLicenseDefined().booleanValue()) {
            PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            LOGGER.debug("pluginLicense.isSubscription() :- " + pluginLicense.isSubscription());
            if (pluginLicense.isSubscription()) {
                return pluginLicense.isSubscription();
            }
            if (!pluginLicense.isEvaluation() || this.isLicenseValid().booleanValue()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public Boolean isLicenseDefined() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean isLicenseValid() {
        if (this.pluginLicenseManager.getLicense().isDefined() && (!((PluginLicense)this.pluginLicenseManager.getLicense().get()).isValid() || ((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().isDefined())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    public PluginLicenseManager getPluginLicenseManager() {
        return this.pluginLicenseManager;
    }

    public void setPluginLicenseManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }
}

