/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.action;

import au.com.bytecode.opencsv.CSVReader;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.PermissionException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.xwork.FileUploadUtils;
import com.miniorange.usermanagement.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportExportAction
extends ConfluenceActionSupport {
    private static Log LOGGER = LogFactory.getLog(ImportExportAction.class);
    private ConfluenceUserManagementUtility UserManagementUtility;
    private Boolean maxUsersLicense;
    private Integer totalUpdations = 0;
    private Integer totalCreations = 0;
    private DirectoryManager directoryManager;
    private UserAccessor userAccessor;
    private CrowdDirectoryService crowdDirectoryService;
    private CrowdService crowdService;
    private Boolean usermanagementuploadSubmitted;
    private Boolean uploadSuccessful = Boolean.FALSE;
    private UserManagementPluginHandler pluginHandler;
    private Boolean evaluationLicense;

    public ImportExportAction(ConfluenceUserManagementUtility userManagementUtility, DirectoryManager directoryManager, UserAccessor userAccessor, CrowdDirectoryService crowdDirectoryService, CrowdService crowdService, UserManagementPluginHandler pluginHandler) {
        this.UserManagementUtility = userManagementUtility;
        this.directoryManager = directoryManager;
        this.userAccessor = userAccessor;
        this.crowdDirectoryService = crowdDirectoryService;
        this.crowdService = crowdService;
        this.pluginHandler = pluginHandler;
    }

    public String execute() {
        LOGGER.debug(" ImportExportAction inside Do execute");
        if (this.usermanagementuploadSubmitted == null) {
            this.usermanagementuploadSubmitted = Boolean.FALSE;
        }
        if (!this.UserManagementUtility.isLicenseValid().booleanValue()) {
            LOGGER.debug("Invalid License ");
            return "invalid";
        }
        if (this.usermanagementuploadSubmitted.booleanValue()) {
            LOGGER.debug("Inside usermanagementuploadSubmitted");
            try {
                this.handleUploadedCSVFile();
                this.uploadSuccessful = Boolean.TRUE;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.maxUsersLicense = this.UserManagementUtility.getMaxUsers() == 0;
        if (!this.maxUsersLicense.booleanValue()) {
            this.evaluationLicense = this.UserManagementUtility.isEvaluationLicense() != false && this.UserManagementUtility.isValidEvaluationLicense() != false ? Boolean.TRUE : Boolean.FALSE;
        }
        return "success";
    }

    private void handleUploadedCSVFile() throws IOException, PermissionException, OperationNotPermittedException, UserNotFoundException, DirectoryNotFoundException, OperationFailedException, InvalidUserException, InvalidCredentialException, UserAlreadyExistsException {
        block59: {
            LOGGER.debug("handleUploadedCSVFile called");
            CSVReader csvReader = null;
            try {
                FileUploadUtils.UploadedFile file = FileUploadUtils.getSingleUploadedFile();
                if (file.getFile() == null) {
                    LOGGER.error("Upoaded CSV file is null");
                    this.addActionError("File is Empty");
                    break block59;
                }
                File csvFile = file.getFile();
                LOGGER.debug("Upoaded CSV : " + csvFile.toString());
                csvReader = new CSVReader(new FileReader(csvFile));
                int UserNameIndex = 10;
                int UserEmailIndex = 10;
                int FullNameIndex = 10;
                int GroupsIndex = 10;
                int StatusIndex = 10;
                int LastLoginTimeIndex = 10;
                int DirectoryIndex = 10;
                String[] nextLine = csvReader.readNext();
                if (nextLine != null) {
                    int colCount = nextLine.length;
                    block31: for (int i = 0; i < colCount; ++i) {
                        switch (nextLine[i].toString()) {
                            case "Username": 
                            case "username": {
                                UserNameIndex = i;
                                continue block31;
                            }
                            case "Email": 
                            case "email": {
                                UserEmailIndex = i;
                                continue block31;
                            }
                            case "FullName": 
                            case "fullname": {
                                FullNameIndex = i;
                                continue block31;
                            }
                            case "Groups": 
                            case "groups": {
                                GroupsIndex = i;
                                continue block31;
                            }
                            case "Status": 
                            case "status": {
                                StatusIndex = i;
                                continue block31;
                            }
                            case "Directory": 
                            case "directory": {
                                DirectoryIndex = i;
                                continue block31;
                            }
                            case "LastLoginDate": 
                            case "lastlogindate": {
                                LastLoginTimeIndex = i;
                            }
                        }
                    }
                }
                List<String[]> rows = csvReader.readAll();
                LOGGER.debug("Uploaded CSV file size = " + rows.size());
                if (rows == null) break block59;
                LOGGER.debug("CSV file is not null starting thread");
                ConfluenceUser user = null;
                int updations = 0;
                int creations = 0;
                this.totalCreations = creations;
                this.totalUpdations = updations;
                for (int i = 0; i < rows.size(); ++i) {
                    String str;
                    String Directory2;
                    String Groups;
                    String UserEmail;
                    String UserName;
                    if (UserNameIndex != 10) {
                        UserName = rows.get(i)[UserNameIndex].toString();
                        if (UserName.isEmpty()) {
                            LOGGER.error(" Username is empty cant create user  ");
                            continue;
                        }
                    } else {
                        LOGGER.error(" Username is empty cant create user  ");
                        continue;
                    }
                    if (UserEmailIndex != 10) {
                        UserEmail = rows.get(i)[UserEmailIndex].toString();
                        if (UserEmail.isEmpty()) {
                            LOGGER.error(" Email is empty cant create user  ");
                            continue;
                        }
                    } else {
                        LOGGER.error(" Email is empty cant create user  ");
                        continue;
                    }
                    String FullName = FullNameIndex != 10 ? rows.get(i)[FullNameIndex].toString() : UserName;
                    List<Object> defaultGroupList = new ArrayList();
                    if (GroupsIndex != 10) {
                        Groups = rows.get(i)[GroupsIndex].toString().replaceAll(",+\\s+", ",");
                        if (!Groups.isEmpty()) {
                            defaultGroupList = Arrays.asList(StringUtils.split(Groups, ","));
                        } else {
                            Groups = "";
                            defaultGroupList = Collections.singletonList("");
                        }
                    } else {
                        Groups = "";
                        defaultGroupList = Collections.singletonList("");
                    }
                    String Status2 = StatusIndex != 10 ? rows.get(i)[StatusIndex].toString() : "";
                    Long Directory_ID = null;
                    Directory UserDirectory = null;
                    if (DirectoryIndex != 10) {
                        Directory2 = rows.get(i)[DirectoryIndex].toString();
                        if (!Directory2.isEmpty()) {
                            try {
                                UserDirectory = this.directoryManager.findDirectoryByName(Directory2.trim());
                                Directory_ID = UserDirectory.getId();
                            }
                            catch (DirectoryNotFoundException e) {
                                LOGGER.error("Directory of user  Doesn't exist", e);
                            }
                        } else {
                            Directory2 = "";
                        }
                    } else {
                        Directory2 = "";
                    }
                    String LastLoginTime = LastLoginTimeIndex != 10 ? rows.get(i)[LastLoginTimeIndex].toString() : "";
                    if (defaultGroupList.size() > 0 && (str = (String)defaultGroupList.get(0)).length() > 0) {
                        str = str.substring(1);
                        defaultGroupList.set(0, str);
                        str = (String)defaultGroupList.get(defaultGroupList.size() - 1);
                        str = str.substring(0, str.length() - 1);
                        defaultGroupList.set(defaultGroupList.size() - 1, str);
                    }
                    InetAddress ip = InetAddress.getLocalHost();
                    List<Object> groupsKeepAsItIs = defaultGroupList;
                    if (this.userAccessor.exists(UserName)) {
                        User crowdUser;
                        LOGGER.debug("User " + UserName + " Already Exists. Updating user info.");
                        LOGGER.debug("user email = " + UserEmail + " full name = " + FullName);
                        Boolean isAdmin = Boolean.FALSE;
                        user = this.userAccessor.getUserByName(UserName);
                        isAdmin = this.permissionManager.isSystemAdministrator((com.atlassian.user.User)user);
                        if (isAdmin.booleanValue()) continue;
                        if (!this.userAccessor.isDeactivated((com.atlassian.user.User)user) && (Status2.equalsIgnoreCase("Inactive") || Status2.equalsIgnoreCase("false"))) {
                            LOGGER.debug("deactivating user from import action :" + user);
                            this.userAccessor.deactivateUser((com.atlassian.user.User)user);
                            this.pluginHandler.storeAuditLogs(UserName, ip.getHostAddress(), "Imported Users", "User Deactivated");
                        }
                        if (this.userAccessor.isDeactivated((com.atlassian.user.User)user) && (Status2.equalsIgnoreCase("Active") || Status2.equalsIgnoreCase("true"))) {
                            LOGGER.debug("activating user from import action :" + user);
                            this.userAccessor.reactivateUser((com.atlassian.user.User)user);
                            this.pluginHandler.storeAuditLogs(UserName, ip.getHostAddress(), "Imported Users", "User Activated");
                        }
                        if (this.canGroupsBeUpdated(user) && GroupsIndex != 10) {
                            List currentGroups = this.userAccessor.getGroupNames((com.atlassian.user.User)user);
                            LOGGER.debug("Current Groups of the user " + currentGroups.toString());
                            ArrayList<String> groupsToRemove = new ArrayList<String>();
                            for (String groupName : currentGroups) {
                                if (groupsKeepAsItIs.contains(groupName) || groupName.contains("confluence-administrators")) continue;
                                groupsToRemove.add(groupName);
                            }
                            LOGGER.debug("Groups to Remove from " + UserName + " are :- " + ((Object)groupsToRemove).toString());
                            this.removeUserFromGroups(UserName, groupsToRemove, ip.getHostAddress());
                            ArrayList groupsToAssign = (ArrayList)this.createAndAssignNewGroupsUser(groupsKeepAsItIs);
                            if (!currentGroups.toString().equals(groupsToAssign.toString())) {
                                LOGGER.debug("groupsToAssign := " + groupsToAssign);
                                this.addUserToGroups(UserName, groupsToAssign);
                                this.pluginHandler.storeAuditLogs(UserName, ip.getHostAddress(), "Imported Users", "User Updated. Added User to Groups:-" + groupsToAssign);
                                this.totalUpdations = ++updations;
                            }
                        }
                        if ((crowdUser = this.crowdService.getUser(user.getName())).getDisplayName().equals(FullName) && crowdUser.getEmailAddress().equals(UserEmail)) continue;
                        UserTemplate userTemplate = new UserTemplate(crowdUser);
                        Long dirId = userTemplate.getDirectoryId();
                        userTemplate.setEmailAddress(UserEmail);
                        userTemplate.setDisplayName(FullName);
                        this.directoryManager.updateUser(dirId.longValue(), userTemplate);
                        this.pluginHandler.storeAuditLogs(UserName, ip.getHostAddress(), "Imported Users", "User Updated. Updated User Profile. ");
                        this.totalUpdations = ++updations;
                        continue;
                    }
                    LOGGER.debug("User " + UserName + " does Not Exist. Creating User ");
                    if (Directory2.isEmpty()) {
                        Directory internalDir = this.directoryManager.findDirectoryByName("Confluence Internal Directory");
                        Directory_ID = internalDir.getId();
                    }
                    try {
                        UserTemplate newuser = new UserTemplate(UserName, Directory_ID.longValue());
                        this.pluginHandler.storeAuditLogs(UserName, ip.getHostAddress(), "Imported Users", "User Created Successfuly. ");
                        newuser.setDisplayName(FullName);
                        newuser.setEmailAddress(UserEmail);
                        newuser.setDirectoryId(Directory_ID.longValue());
                        if (Status2.equalsIgnoreCase("Inactive")) {
                            newuser.setActive(Boolean.FALSE.booleanValue());
                        } else {
                            newuser.setActive(Boolean.TRUE.booleanValue());
                        }
                        this.directoryManager.addUser(Directory_ID.longValue(), newuser, PasswordCredential.NONE);
                        this.totalCreations = ++creations;
                    }
                    catch (PermissionException e) {
                        e.printStackTrace();
                    }
                    ArrayList groupsToAssignToNewUser = (ArrayList)this.createAndAssignNewGroupsUser(defaultGroupList);
                    this.addUserToGroups(UserName, groupsToAssignToNewUser);
                }
                LOGGER.debug("User Imported Successfully");
                this.addActionError("Users Imported Successfully ", new Object[]{"success", true, null});
                LOGGER.debug("Updations = " + this.totalUpdations + " Creations = " + this.totalCreations);
            }
            catch (Exception e) {
                LOGGER.error("error while uploading file " + e);
            }
        }
    }

    private boolean canGroupsBeUpdated(ConfluenceUser confluenceUser) {
        LOGGER.debug("checking if groups of the user can be updated");
        User user = this.crowdService.getUser(confluenceUser.getName());
        Directory directory = this.crowdDirectoryService.findDirectoryById(user.getDirectoryId());
        return directory != null && directory.getAllowedOperations().contains(OperationType.UPDATE_GROUP);
    }

    private void removeUserFromGroups(String username, List<String> groupsToRemove, String ip) throws OperationNotPermittedException {
        LOGGER.debug("Removing user from groups");
        User user = this.crowdService.getUser(username);
        for (String group : groupsToRemove) {
            LOGGER.debug("Removing user " + username + " from " + group);
            LOGGER.debug("Removing user [" + username + "] from group [" + group + "]");
            Group grp = this.crowdService.getGroup(group);
            this.crowdService.removeUserFromGroup(user, grp);
            this.pluginHandler.storeAuditLogs(username, ip, "Imported Users", "User Updated.. Removed User from Groups:- " + groupsToRemove);
        }
    }

    public void addUserToGroups(String username, List<String> groupsToAssign) throws OperationNotPermittedException {
        LOGGER.debug("Adding user to groups");
        try {
            User user = this.crowdService.getUser(username);
            for (String group : groupsToAssign) {
                if (group.length() <= 0) continue;
                LOGGER.debug("Adding user " + username + " to " + group);
                LOGGER.debug("Adding user [" + username + "] to group [" + group + "]");
                Group grp = this.crowdService.getGroup(group);
                this.crowdService.addUserToGroup(user, grp);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error adding user to groups");
            e.printStackTrace();
        }
    }

    private List<String> createAndAssignNewGroupsUser(List<String> roleValuesList) {
        ArrayList<String> groupsToAssign = new ArrayList<String>();
        try {
            for (String groupsName : roleValuesList) {
                if (groupsName.length() <= 0) continue;
                if (this.crowdService.getGroup(groupsName.trim()) == null) {
                    LOGGER.debug("Creating new Group with name : " + groupsName);
                    this.userAccessor.createGroup(groupsName);
                }
                groupsToAssign.add(groupsName);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return groupsToAssign;
    }

    public ConfluenceUserManagementUtility getUserManagementUtility() {
        return this.UserManagementUtility;
    }

    public void setUserManagementUtility(ConfluenceUserManagementUtility userManagementUtility) {
        this.UserManagementUtility = userManagementUtility;
    }

    public Boolean getMaxUsersLicense() {
        return this.maxUsersLicense;
    }

    public void setMaxUsersLicense(Boolean maxUsersLicense) {
        this.maxUsersLicense = maxUsersLicense;
    }

    public Boolean getUsermanagementuploadSubmitted() {
        return this.usermanagementuploadSubmitted;
    }

    public void setUsermanagementuploadSubmitted(Boolean usermanagementuploadSubmitted) {
        this.usermanagementuploadSubmitted = usermanagementuploadSubmitted;
    }

    public Integer getTotalUpdations() {
        return this.totalUpdations;
    }

    public void setTotalUpdations(Integer totalUpdations) {
        this.totalUpdations = totalUpdations;
    }

    public Integer getTotalCreations() {
        return this.totalCreations;
    }

    public void setTotalCreations(Integer totalCreations) {
        this.totalCreations = totalCreations;
    }

    public Boolean getUploadSuccessful() {
        return this.uploadSuccessful;
    }

    public void setUploadSuccessful(Boolean uploadSuccessful) {
        this.uploadSuccessful = uploadSuccessful;
    }

    public Boolean getEvaluationLicense() {
        return this.evaluationLicense;
    }

    public void setEvaluationLicense(Boolean evaluationLicense) {
        this.evaluationLicense = evaluationLicense;
    }
}

