/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.web.context.HttpContext;
import com.miniorange.usermanagement.common.UserManagementPluginSettings;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class DownloadCSVSampleAction
extends ConfluenceActionSupport {
    private static Log LOGGER = LogFactory.getLog(DownloadCSVSampleAction.class);
    private static final String EXAMPLE_CSV_PATH = "/csvtempate/example_csv.csv";
    private static final String EXAMPLE_CSV_PATH_Group_Management = "/csvtempate/group_example_csv.csv";
    private HttpContext staticHttpContext;
    private UserManagementPluginSettings settings;

    public DownloadCSVSampleAction(HttpContext staticHttpContext) {
        this.staticHttpContext = staticHttpContext;
    }

    public String execute() throws Exception {
        LOGGER.debug("Downloading Sample CSV file.");
        try {
            String exampleCSV;
            String requestUrl = this.getCurrentRequest().getHeader("referer");
            if (requestUrl.contains("group")) {
                exampleCSV = IOUtils.toString(UserManagementPluginSettings.class.getResourceAsStream(EXAMPLE_CSV_PATH_Group_Management), "UTF-8");
                this.staticHttpContext.getResponse().setHeader("Content-Disposition", "attachment; filename=\"group_example_csv.csv\"");
            } else {
                exampleCSV = IOUtils.toString(UserManagementPluginSettings.class.getResourceAsStream(EXAMPLE_CSV_PATH), "UTF-8");
                this.staticHttpContext.getResponse().setHeader("Content-Disposition", "attachment; filename=\"example_csv.csv.csv\"");
            }
            this.staticHttpContext.getResponse().setHeader("Cache-Control", "max-age=0");
            this.staticHttpContext.getResponse().setHeader("Pragma", "");
            this.staticHttpContext.getResponse().setContentType("application/octet-stream");
            this.staticHttpContext.getResponse().getOutputStream().write(exampleCSV.getBytes());
            return null;
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while downloading the csv file.", e);
            return "input";
        }
    }

    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }
}

