/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.google.gson.Gson;
import com.miniorange.usermanagement.common.CommonAuditLogDetails;
import com.miniorange.usermanagement.common.UserManagementPluginCommonConstants;
import com.miniorange.usermanagement.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.scheduler.AuditLogScheduler;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuditLogsAction
extends ConfluenceActionSupport {
    private static Log LOGGER = LogFactory.getLog(AuditLogsAction.class);
    private UserManagementPluginSettings settings;
    private UserManagementPluginHandler pluginHandler;
    CommonAuditLogDetails backToObject;
    private Boolean auditLogsUserDetailsSubmitted;
    private AuditLogScheduler auditLogScheduler;
    private String auditLogUsernameSearchKeyword;
    private String auditLogIpSearchKeyword;
    private String filterUsersByPeriod;
    private String filterUsersByAction;
    private List<String> auditLogs;
    private List<CommonAuditLogDetails> listOfAuditLogsObjects = new ArrayList<CommonAuditLogDetails>();
    private List<CommonAuditLogDetails> auditLogsToDisplay = new ArrayList<CommonAuditLogDetails>();
    private List<String> auditLogsAfterAllFilters = new ArrayList<String>();
    private Boolean autoDeleteAuditLogs;
    private Boolean autoDeleteAuditLogsDetailsSubmitted;
    private String autoDeleteLogsAfterDays;
    private List<String> numberOfPagesList;
    private Integer numberOfRecordsPerPage;
    private List<String> currentPageUsersList;
    private Integer selectedPage;
    private Integer startIndex;
    private Integer endIndex;
    private Integer numberOfPages;

    public AuditLogsAction(UserManagementPluginSettings settings, UserManagementPluginHandler pluginHandler, AuditLogScheduler auditLogScheduler) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.auditLogScheduler = auditLogScheduler;
    }

    public String execute() throws Exception {
        LOGGER.debug("AuditLogsAction doExecute called");
        HttpServletRequest request = this.getCurrentRequest();
        String startIndexAsString = "";
        String endIndexAsString = "";
        if (BooleanUtils.toBoolean(this.autoDeleteAuditLogsDetailsSubmitted)) {
            this.settings.setAutoDeleteAuditLogs(BooleanUtils.toBoolean(this.autoDeleteAuditLogs));
            if (BooleanUtils.toBoolean(this.autoDeleteAuditLogs)) {
                int days = Integer.parseInt(this.autoDeleteLogsAfterDays);
                this.settings.setAutoDeleteLogsAfterDays(days);
                LOGGER.debug("Scheduling Task");
                this.auditLogScheduler.schedule();
            } else {
                this.settings.setAutoDeleteAuditLogs(false);
                LOGGER.debug("Un-scheduling Task");
                this.auditLogScheduler.unschedule();
            }
        }
        if (StringUtils.isBlank(this.auditLogUsernameSearchKeyword)) {
            this.auditLogUsernameSearchKeyword = "";
        }
        if (StringUtils.isBlank(this.auditLogIpSearchKeyword)) {
            this.auditLogIpSearchKeyword = "";
        }
        if (BooleanUtils.toBoolean(this.auditLogsUserDetailsSubmitted)) {
            startIndexAsString = "";
            endIndexAsString = "";
        } else {
            String usernameSearchKeyword = request.getParameter("logsUsernameSearchKeywordUrl");
            String ipSearchKeyword = request.getParameter("logsIpSearchKeywordUrl");
            String actionSearchFilter = request.getParameter("actionSearchFilter");
            String periodSearchFilter = request.getParameter("periodSearchFilter");
            if (StringUtils.isNotBlank(usernameSearchKeyword)) {
                this.auditLogUsernameSearchKeyword = usernameSearchKeyword.trim();
            }
            if (StringUtils.isNotBlank(ipSearchKeyword)) {
                this.auditLogIpSearchKeyword = ipSearchKeyword.trim();
            }
            if (StringUtils.isNotBlank(actionSearchFilter)) {
                this.filterUsersByAction = actionSearchFilter.trim();
            }
            if (StringUtils.isNotBlank(periodSearchFilter)) {
                this.filterUsersByPeriod = periodSearchFilter.trim();
            }
            startIndexAsString = request.getParameter("startIndex");
            endIndexAsString = request.getParameter("endIndex");
        }
        this.auditLogUsernameSearchKeyword = this.auditLogUsernameSearchKeyword.trim();
        this.auditLogIpSearchKeyword = this.auditLogIpSearchKeyword.trim();
        this.numberOfRecordsPerPage = UserManagementPluginCommonConstants.MO_NUMBER_OF_USER_PER_PAGE;
        if (StringUtils.isBlank(startIndexAsString) && StringUtils.isBlank(endIndexAsString)) {
            this.selectedPage = 1;
            this.startIndex = 1;
            this.endIndex = this.numberOfRecordsPerPage;
        } else {
            this.startIndex = Integer.parseInt(startIndexAsString);
            this.endIndex = Integer.parseInt(endIndexAsString);
            this.selectedPage = this.endIndex / UserManagementPluginCommonConstants.MO_NUMBER_OF_USER_PER_PAGE;
        }
        if (StringUtils.isBlank(this.filterUsersByAction)) {
            this.filterUsersByAction = "All Actions";
        }
        if (StringUtils.isBlank(this.filterUsersByPeriod)) {
            this.filterUsersByPeriod = "All Days";
        }
        this.auditLogs = this.settings.getAuditLogs();
        LOGGER.debug("auditLogs = " + this.auditLogs);
        LOGGER.info("auditLogUsernameSearchKeyword =  " + this.auditLogUsernameSearchKeyword);
        LOGGER.info("auditLogIpSearchKeyword =  " + this.auditLogIpSearchKeyword);
        LOGGER.info("filterUsersByAction=  " + this.filterUsersByAction);
        LOGGER.info("filterUsersByPeriod =  " + this.filterUsersByPeriod);
        this.auditLogsAfterAllFilters = this.settings.getLogsToDisplay(this.auditLogs, this.auditLogUsernameSearchKeyword, this.auditLogIpSearchKeyword, this.filterUsersByAction, this.filterUsersByPeriod);
        this.currentPageUsersList = this.getSelectedDetailsForPaginationForLogs(this.auditLogsAfterAllFilters, this.startIndex - 1, this.endIndex - 1);
        Gson gson = new Gson();
        for (int counter = 0; counter < this.currentPageUsersList.size(); ++counter) {
            this.backToObject = gson.fromJson(this.currentPageUsersList.get(counter), CommonAuditLogDetails.class);
            this.auditLogsToDisplay.add(this.backToObject);
        }
        LOGGER.debug("auditLogsAfterAllFilters = " + this.auditLogsAfterAllFilters);
        LOGGER.debug("current auditLog list = " + this.currentPageUsersList);
        LOGGER.debug("auditLogsToDisplay = " + this.auditLogsToDisplay);
        this.numberOfPages = this.auditLogsAfterAllFilters.size() / UserManagementPluginCommonConstants.MO_NUMBER_OF_USER_PER_PAGE;
        if (this.auditLogsAfterAllFilters.size() > this.numberOfPages * UserManagementPluginCommonConstants.MO_NUMBER_OF_USER_PER_PAGE) {
            AuditLogsAction auditLogsAction = this;
            Integer n = auditLogsAction.numberOfPages;
            Integer n2 = auditLogsAction.numberOfPages = Integer.valueOf(auditLogsAction.numberOfPages + 1);
        }
        LOGGER.debug("number of pages = " + this.numberOfPages);
        this.initializeAuditLogs();
        return "success";
    }

    public List<String> getSelectedDetailsForPaginationForLogs(List<String> detailsList, Integer startIndex, Integer endIndex) {
        ArrayList<String> selectedDetailsPagination = new ArrayList<String>();
        for (int counter = startIndex.intValue(); counter <= endIndex && counter < detailsList.size(); ++counter) {
            selectedDetailsPagination.add(detailsList.get(counter));
        }
        LOGGER.debug("Selected Details : " + selectedDetailsPagination);
        return selectedDetailsPagination;
    }

    private void initializeAuditLogs() {
        this.autoDeleteAuditLogs = this.settings.getAutoDeleteAuditLogs();
        this.autoDeleteLogsAfterDays = this.settings.getAutoDeleteLogsAfterDays().toString();
    }

    public Boolean getAuditLogsUserDetailsSubmitted() {
        return this.auditLogsUserDetailsSubmitted;
    }

    public void setAuditLogsUserDetailsSubmitted(Boolean auditLogsUserDetailsSubmitted) {
        this.auditLogsUserDetailsSubmitted = auditLogsUserDetailsSubmitted;
    }

    public Boolean getAutoDeleteAuditLogs() {
        return this.autoDeleteAuditLogs;
    }

    public void setAutoDeleteAuditLogs(Boolean autoDeleteAuditLogs) {
        this.autoDeleteAuditLogs = autoDeleteAuditLogs;
    }

    public Boolean getAutoDeleteAuditLogsDetailsSubmitted() {
        return this.autoDeleteAuditLogsDetailsSubmitted;
    }

    public void setAutoDeleteAuditLogsDetailsSubmitted(Boolean autoDeleteAuditLogsDetailsSubmitted) {
        this.autoDeleteAuditLogsDetailsSubmitted = autoDeleteAuditLogsDetailsSubmitted;
    }

    public String getAutoDeleteLogsAfterDays() {
        return this.autoDeleteLogsAfterDays;
    }

    public void setAutoDeleteLogsAfterDays(String autoDeleteLogsAfterDays) {
        this.autoDeleteLogsAfterDays = autoDeleteLogsAfterDays;
    }

    public List<String> getAuditLogs() {
        return this.auditLogs;
    }

    public void setAuditLogs(List<String> auditLogs) {
        this.auditLogs = auditLogs;
    }

    public String getAuditLogUsernameSearchKeyword() {
        return this.auditLogUsernameSearchKeyword;
    }

    public void setAuditLogUsernameSearchKeyword(String auditLogUsernameSearchKeyword) {
        this.auditLogUsernameSearchKeyword = auditLogUsernameSearchKeyword;
    }

    public String getAuditLogIpSearchKeyword() {
        return this.auditLogIpSearchKeyword;
    }

    public void setAuditLogIpSearchKeyword(String auditLogIpSearchKeyword) {
        this.auditLogIpSearchKeyword = auditLogIpSearchKeyword;
    }

    public String getFilterUsersByPeriod() {
        return this.filterUsersByPeriod;
    }

    public void setFilterUsersByPeriod(String filterUsersByPeriod) {
        this.filterUsersByPeriod = filterUsersByPeriod;
    }

    public String getFilterUsersByAction() {
        return this.filterUsersByAction;
    }

    public void setFilterUsersByAction(String filterUsersByAction) {
        this.filterUsersByAction = filterUsersByAction;
    }

    public List<String> getAuditLogsAfterAllFilters() {
        return this.auditLogsAfterAllFilters;
    }

    public void setAuditLogsAfterAllFilters(List<String> auditLogsAfterAllFilters) {
        this.auditLogsAfterAllFilters = auditLogsAfterAllFilters;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public Integer getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(Integer endIndex) {
        this.endIndex = endIndex;
    }

    public Integer getSelectedPage() {
        return this.selectedPage;
    }

    public void setSelectedPage(Integer selectedPage) {
        this.selectedPage = selectedPage;
    }

    public Integer getNumberOfPages() {
        return this.numberOfPages;
    }

    public void setNumberOfPages(Integer numberOfPages) {
        this.numberOfPages = numberOfPages;
    }

    public List<String> getNumberOfPagesList() {
        this.numberOfPagesList = new ArrayList<String>();
        for (int i = 1; i <= this.numberOfPages; ++i) {
            this.numberOfPagesList.add("" + i);
        }
        return this.numberOfPagesList;
    }

    public void setNumberOfPagesList(List<String> numberOfPagesList) {
        this.numberOfPagesList = numberOfPagesList;
    }

    public List<String> getCurrentPageUsersList() {
        return this.currentPageUsersList;
    }

    public void setCurrentPageUsersList(List<String> currentPageUsersList) {
        this.currentPageUsersList = currentPageUsersList;
    }

    public Integer getNumberOfRecordsPerPage() {
        return this.numberOfRecordsPerPage;
    }

    public void setNumberOfRecordsPerPage(Integer numberOfRecordsPerPage) {
        this.numberOfRecordsPerPage = numberOfRecordsPerPage;
    }

    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    public UserManagementPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(UserManagementPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public CommonAuditLogDetails getBackToObject() {
        return this.backToObject;
    }

    public void setBackToObject(CommonAuditLogDetails backToObject) {
        this.backToObject = backToObject;
    }

    public List<CommonAuditLogDetails> getListOfAuditLogsObjects() {
        return this.listOfAuditLogsObjects;
    }

    public void setListOfAuditLogsObjects(List<CommonAuditLogDetails> listOfAuditLogsObjects) {
        this.listOfAuditLogsObjects = listOfAuditLogsObjects;
    }

    public List<CommonAuditLogDetails> getAuditLogsToDisplay() {
        return this.auditLogsToDisplay;
    }

    public void setAuditLogsToDisplay(List<CommonAuditLogDetails> auditLogsToDisplay) {
        this.auditLogsToDisplay = auditLogsToDisplay;
    }
}

