/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.util;

import com.atlassian.plugin.spring.scanner.ProductFilter;
import com.atlassian.plugin.spring.scanner.util.ProductFilterUtil;
import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class AnnotationIndexReader {
    private static final Log log = LogFactory.getLog(AnnotationIndexReader.class);

    public static List<String> readIndexFile(String resourceFile, Bundle bundle) {
        URL url = bundle.getResource(resourceFile);
        return AnnotationIndexReader.readIndexFile(url);
    }

    public static List<String> readIndexFile(String resourceFile, ClassLoader classLoader) {
        URL url = classLoader.getResource(resourceFile);
        List<String> strings = AnnotationIndexReader.readIndexFile(url);
        if (log.isDebugEnabled()) {
            log.debug("Read annotation index file: " + resourceFile);
            log.debug("Printing out found annotated beans: ");
            log.debug(strings);
        }
        return strings;
    }

    public static List<String> readAllIndexFilesForProduct(String resourceFile, Bundle bundle) {
        ArrayList<String> entries = new ArrayList<String>();
        URL url = bundle.getResource(resourceFile);
        entries.addAll(AnnotationIndexReader.readIndexFile(url));
        ProductFilter filter = ProductFilterUtil.getFilterForCurrentProduct(bundle.getBundleContext());
        if (null != filter) {
            entries.addAll(AnnotationIndexReader.readIndexFile(filter.getPerProductFile(resourceFile), bundle));
        }
        return entries;
    }

    public static List<String> readAllIndexFilesForProduct(String resourceFile, ClassLoader classLoader, @Nullable BundleContext bundleContext) {
        ArrayList<String> entries = new ArrayList<String>();
        URL url = classLoader.getResource(resourceFile);
        entries.addAll(AnnotationIndexReader.readIndexFile(url));
        ProductFilter filter = ProductFilterUtil.getFilterForCurrentProduct(bundleContext);
        if (null != filter) {
            entries.addAll(AnnotationIndexReader.readIndexFile(filter.getPerProductFile(resourceFile), classLoader));
        }
        return entries;
    }

    public static List<String> readIndexFile(URL url) {
        ArrayList<String> resources = new ArrayList<String>();
        try {
            BufferedReader reader;
            if (null == url) {
                return resources;
            }
            try {
                reader = new BufferedReader(new InputStreamReader(url.openStream(), Charsets.UTF_8));
            }
            catch (FileNotFoundException e) {
                return resources;
            }
            String line = reader.readLine();
            while (line != null) {
                resources.add(line);
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read index file [" + url.toString() + "]", e);
        }
        return resources;
    }

    public static Properties readPropertiesFile(URL url) {
        Properties resources = new Properties();
        try {
            BufferedReader reader;
            if (null == url) {
                return resources;
            }
            try {
                reader = new BufferedReader(new InputStreamReader(url.openStream(), Charsets.UTF_8));
            }
            catch (FileNotFoundException e) {
                return resources;
            }
            resources.load(reader);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read properties file [" + url.toString() + "]", e);
        }
        return resources;
    }

    public static String[] splitProfiles(String profiles) {
        return StringUtils.isNotBlank(profiles) ? StringUtils.split(profiles, ',') : new String[]{};
    }

    public static Iterable<String> getIndexFilesForProfiles(String[] profileNames, String indexFileName) {
        ArrayList<String> filesToRead = new ArrayList<String>();
        if (profileNames.length > 0) {
            for (String profileName : profileNames) {
                if (!StringUtils.isNotBlank(profileName = StringUtils.defaultIfBlank(profileName, "").trim())) continue;
                String fileToRead = "META-INF/plugin-components/profile-" + profileName + "/" + indexFileName;
                filesToRead.add(fileToRead);
            }
        } else {
            String fileToRead = "META-INF/plugin-components/" + indexFileName;
            filesToRead.add(fileToRead);
        }
        return filesToRead;
    }
}

