AJS.$(function () {
    AJS.$(".aui-nav li").removeClass("aui-nav-selected");
    AJS.$("#userrestriction").addClass("aui-nav-selected");

    if(document.getElementById("restrictGroupEnabled").checked){
        AJS.$("#groupsList").show();
    }else{
        AJS.$("#groupsList").hide();
    }

    AJS.$("#restrictGroupEnabled").change(function(){
        var restrictGroupEnabled = document.getElementById("restrictGroupEnabled").checked;
        if(restrictGroupEnabled){
            AJS.$("#groupsList").show("slow");
        }else{
            AJS.$("#groupsList").hide("slow");
        }
    });

    if(document.getElementById("readOnlyGroupsEnabled").checked){
        AJS.$("#readOnlyGroupsDiv").show();
    }else{
        AJS.$("#readOnlyGroupsDiv").hide();
    }

    AJS.$("#readOnlyGroupsEnabled").change(function(){
        var readOnlyGroupsEnabled = document.getElementById("readOnlyGroupsEnabled").checked;
        if(readOnlyGroupsEnabled){
            AJS.$("#readOnlyGroupsDiv").show("slow");
        }else{
            AJS.$("#readOnlyGroupsDiv").hide("slow");
        }
    });

    if(document.getElementById("restrictTokenGenerationGroupEnabled").checked){
        AJS.$("#restrictTokenGenerationGroupsDiv").show();
    }else{
        AJS.$("#restrictTokenGenerationGroupsDiv").hide();
    }

    AJS.$("#restrictTokenGenerationGroupEnabled").change(function(){
        var restrictTokenGenerationGroupEnabled = document.getElementById("restrictTokenGenerationGroupEnabled").checked;
        if(restrictTokenGenerationGroupEnabled){
            AJS.$("#restrictTokenGenerationGroupsDiv").show("slow");
        }else{
            AJS.$("#restrictTokenGenerationGroupsDiv").hide("slow");
        }
    });


    AJS.$(document).on("submit","#userrestriction-setting", function (e) {
        e.preventDefault();
        console.log("User Restriction Setttings Submitted");
        postForm(AJS.$("#userrestriction-setting"));
    });

    function postForm(form){

            console.log("Calling user restriction servlet");
            var apiKey;
            AJS.$.ajax({
                url: AJS.contextPath()+"/plugins/servlet/restauth/userrestriction",
                type: 'POST',
                data: form.serialize(),
                async: false,
                success: function(data) {
                    showSuccessMessage("Settings Saved Successfully");
                },
                error: function(response) {
                    showErrorMessage(response.responseJSON.error.message);
                }
            });

    }

    function showErrorMessage(message){
        AJS.flag({
            title: 'Error!',
            type: 'error',
            close:'auto',
            body: '<p>'+message+'</p><br/>'
        });
    }
    function showSuccessMessage(message){
        AJS.flag({
            title: 'Success',
            type: 'success',
            close:'auto',
            body: '<p>'+message+'</p><br/>'
        });
    }
 });