AJS.$(function() {
	//Show correct menu items as selected
	AJS.$('.aui-nav li').removeClass('aui-nav-selected');
	AJS.$('#tokensettings').addClass('aui-nav-selected');
	AJS.$('#mo-oauth').addClass('aui-nav-selected');
	AJS.$('#mo-apitoken').addClass('aui-nav-selected');


    if(!document.getElementById("set-max-expiry").checked){
        AJS.$("#max-expiry-settings").hide();
    }

	AJS.$(document).on('submit', '#api-keys-expiry-form', async function(e) {
		e.preventDefault();
		console.log('API Key Settings submitted successfully');
		var response = await postForm(AJS.$('#api-keys-expiry-form'));
		var message;
        message = 'Setting saved Successfully';
		showSuccessMessage(message);
	});

	AJS.$("#set-max-expiry").change(function(){
	    var setMaxExpiry = document.getElementById("set-max-expiry").checked;
	    if(setMaxExpiry){
            AJS.$("#max-expiry-settings").show("slow");
	    }else{
	        AJS.$("#max-expiry-settings").hide("slow");
	    }
	});

	if(!document.getElementById("set-max-tokens").checked){
		AJS.$("#max-token-settings").hide();
	}

    AJS.$("#set-max-tokens").change(function(){
    	    var setMaxToken = document.getElementById("set-max-tokens").checked;
    	    if(setMaxToken){
                AJS.$("#max-token-settings").show("slow");
    	    }else{
    	        AJS.$("#max-token-settings").hide("slow");
    	    }
    	});

	function postForm(form) {
		return new Promise(function(resolve) {
			console.log('Calling create api key servlet');

			AJS.$.ajax({
				url: AJS.contextPath() + '/plugins/servlet/moapitokens/settings',
				type: 'POST',
				data: form.serialize(),
				async: false,
				success: function(data) {
					resolve(data);
				},
				error: function(response) {
					showErrorMessage(response.responseJSON.error.message);
				}
			});
		});
	}

	function showSuccessMessage(message) {
		AJS.flag({
			title: 'Success',
			type: 'success',
			close: 'auto',
			body: '<p>' + message + '</p><br/>'
		});
	}

	function showErrorMessage(message) {
		AJS.flag({
			title: 'Error!',
			type: 'error',
			close: 'auto',
			body: '<p>' + message + '</p><br/>'
		});
	}
});
