AJS.$(function () {
    AJS.$(".aui-nav li").removeClass("aui-nav-selected");
    AJS.$("#mo-rate-limiting").addClass("aui-nav-selected");

    if(!document.getElementById("enable-rate-limiting").checked){
        AJS.$("#rate-limiting-settings").hide();
    }

    AJS.$("#enable-rate-limiting").change(function(){
        var enableRateLimiting = document.getElementById("enable-rate-limiting").checked;
        if(enableRateLimiting){
            AJS.$("#rate-limiting-settings").show("slow");
        }else{
            AJS.$("#rate-limiting-settings").hide("slow");
        }
    });
    AJS.$("#max-request-count").change(function(){
        changeRateLimitingDetails();
    });

    AJS.$("#interval-count").change(function(){
        changeRateLimitingDetails();
    });

    AJS.$("#maximum-interval").change(function(){
        changeRateLimitingDetails();
    });

    AJS.$(document).on("submit","#rate-limiting-form", function (e) {
        e.preventDefault();
        postForm(AJS.$("#rate-limiting-form"));
    });

    function postForm(form){
        AJS.$.ajax({
            url: AJS.contextPath()+"/plugins/servlet/restauth/ratelimiting",
            type: 'POST',
            data: form.serialize(),
            async: false,
            success: function(data) {
                showSuccessMessage("Rate Limiting Settings Saved Successfully");
            },
            error: function(response) {
                showErrorMessage(response.responseJSON.error.message);
            }
        });

    }

    function showErrorMessage(message){
        AJS.flag({
            title: 'Error!',
            type: 'error',
            close:'auto',
            body: '<p>'+message+'</p><br/>'
        });
    }
    function showSuccessMessage(message){
        AJS.flag({
            title: 'Success',
            type: 'success',
            close:'auto',
            body: '<p>'+message+'</p><br/>'
        })
    }

    function changeRateLimitingDetails() {
        var numberOfRequest = document.getElementById("max-request-count").value;
        var rateLimitingIntervalCount = document.getElementById("interval-count").value;
        var rateLimitingInterval;
        switch (document.getElementById("maximum-interval").value){
            case "1":
                rateLimitingInterval = "Minutes";
                break;
            default:
                rateLimitingInterval = "Hours";
                break;
        }

        var msg = numberOfRequest+" requests are allowed within "+rateLimitingIntervalCount+" "+rateLimitingInterval;
        document.getElementById('rate-limiting-details').innerHTML = msg;
    }


});