AJS.$(function () {

    // AJS.$(document).ready(function () {
        if (document.getElementById("oauthType").value != null) {
            var oauthType = document.getElementById("oauthType").value;
            console.log("inside active ribbon");
            switch (oauthType) {
                case "Authorization":
                    AJS.$("#card1-selected").show();
                    AJS.$("#card2-selected").hide();
                    AJS.$("#card3-selected").hide();
                    break;
                case "Client-Creds":
                    AJS.$("#card1-selected").hide();
                    AJS.$("#card2-selected").show();
                    AJS.$("#card3-selected").hide();
                    break;
                case "JWT":
                    AJS.$("#card1-selected").hide();
                    AJS.$("#card2-selected").hide();
                    AJS.$("#card3-selected").show();
                    break;
                default:
                    AJS.$("#card1-selected").hide();
                    AJS.$("#card2-selected").hide();
                    AJS.$("#card3-selected").hide();
                    break;
            }
        }
    // });

    AJS.$("#card1").on('click', function(e) {
        var oauthType = document.getElementById("oauthType").value;
        document.getElementById("currentSelection").value = "Authorization";
        changeWarningMsg();
        if(oauthType == "Authorization" || oauthType == ''){
            postForm(AJS.$("#oauth-type"))
            openAuthorizationSettings();
        }else{
            AJS.dialog2("#oauth-type-dialog").show();
        }
    });

    AJS.$("#card2").on('click', function(e) {
        var oauthType = document.getElementById("oauthType").value;
        document.getElementById("currentSelection").value = "Client-Creds";
        changeWarningMsg();
        if(oauthType == "Client-Creds" || oauthType == ''){
            postForm(AJS.$("#oauth-type"))
            openClientCredsSettings();
        }else{
            AJS.dialog2("#oauth-type-dialog").show();
        }
    });

    AJS.$("#card3").on('click', function(e) {
        var oauthType = document.getElementById("oauthType").value;
        document.getElementById("currentSelection").value = "JWT";
        changeWarningMsg();
        if(oauthType == "JWT" || oauthType == ''){
            postForm(AJS.$("#oauth-type"))
            openJWTSettings();
        }else{
            AJS.dialog2("#oauth-type-dialog").show();
        }
    });

    // Hides the dialog
    AJS.$("#dialog-submit-button").on('click', function (e) {
        console.log("Inside form submit button");
        postForm(AJS.$("#oauth-type"))
        var oauthType = document.getElementById("currentSelection").value;
        switch (oauthType){
            case "Authorization":
                openAuthorizationSettings();
                break;
            case "Client-Creds":
                openClientCredsSettings();
                break;
            case "JWT":
                openJWTSettings();
                break;
            default:
                console.log("In default menu");
                break;
        }
        AJS.dialog2("#oauth-type-dialog").hide();
    });

    AJS.$("#dialog-close-button").on('click', function (e) {
        AJS.dialog2("#oauth-type-dialog").hide();
    });


    function postForm(form) {
        console.log("Inside form submit" + document.getElementById("currentSelection").value);

        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/restauth/oauthtype",
            type: 'POST',
            data: form.serialize(),
            async: false,
            success: function (data) {
                console.log("Submitted");
            },
            error: function (response) {
                console.log("Error while submitting the oauth type");
            }
        });
    }

    function openAuthorizationSettings(){
        window.onbeforeunload = null;
        var platform = document.getElementById("platform").value;
        if(platform == "confluence")
            window.open(AJS.contextPath() + '/admin/plugins/restauth/configure.action','_self');
        else
            window.open(AJS.contextPath() + '/secure/admin/restauth.configure.jspa','_self');
    }

    function openClientCredsSettings(){
        window.onbeforeunload = null;
        var platform = document.getElementById("platform").value
        if(platform == "confluence")
            window.open(AJS.contextPath() + '/admin/plugins/restauth/clientcredentials.action','_self');
        else
            window.open(AJS.contextPath() + '/secure/admin/restauth.clientcredentials.jspa','_self');
    }

    function openJWTSettings(){
        window.onbeforeunload = null;
        window.open(AJS.contextPath() + '/plugins/servlet/restauth/jwt','_self');
    }

    function changeWarningMsg(){
        console.log("INside change warning msg pop up")
        var current_conf, current_select;

        switch(document.getElementById("oauthType").value){
            case "Authorization":
                current_conf = "Authorization Grant";
                break;
            case "Client-Creds":
                current_conf = "Client Credential Grant";
                break;
            case "JWT":
                current_conf = "JWT";
                break;
            default:
                console.log("In default menu");
                break;
        }

        switch(document.getElementById("currentSelection").value){
            case "Authorization":
                current_select = "Authorization Grant";
                break;
            case "Client-Creds":
                current_select = "Client Credential Grant";
                break;
            case "JWT":
                current_select = "JWT";
                break;
            default:
                console.log("In default menu");
                break;
        }
        var msg1 = "Tokens are now been validated through "+current_conf+"."
        var msg2 = "Are you sure you want to swtich from <strong>"+current_conf+" to "+current_select+" ?</strong>" ;
        document.getElementById('warning-msg-1').innerHTML = msg1;
        document.getElementById('warning-msg-2').innerHTML = msg2;
    }

});
