AJS.$(function() {
	//Show correct menu items as selected
	//AJS.$('.aui-nav li').removeClass('aui-nav-selected');
	AJS.$('#mo-oauth').addClass('aui-nav-selected');
	AJS.$('#managetokens').addClass('aui-nav-selected');
	AJS.$('#mo-apitoken').addClass('aui-nav-selected');

	AJS.$('#show-api-key-dialog-button').click(function(e) {
	console.log("api key button is pressed");
	var maxTokenCount = $("#maxTokenCount").val();
    var maxTokenEnabled = $("#maxTokenEnabled").val();
    var isAdmin = $("#isAdmin").val();
	var rowCount = $('#apiKeysTable >tbody >tr').length;
	if(isAdmin == 'false' && maxTokenEnabled == 'true' && rowCount >= maxTokenCount){
            e.preventDefault();
            AJS.dialog2("#warning-dialog").show();
	}
    else{
	    AJS.$('#username-div').hide();
            e.preventDefault();
            AJS.dialog2('#api-key-dialog').show();
	}
	});

    AJS.$("#api-token-configure").click(function(){
        AJS.dialog2("#api-config-pop-up").hide();
    });
    AJS.$("#api-config-pop-up-info-close-button").click(function(){
        AJS.dialog2("#api-config-pop-up").hide();
    })

    AJS.$("#api-config-pop-up-understand").click(function(e){
        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/rest/auth/moapi",
            data: {
                "action": "disablePopUp",
                "submitted": true,
            },
            type: "GET",
            async: false,
            success: function (response) {
                console.log("success");
                AJS.dialog2("#api-config-pop-up").hide();
            }
        });
        location.reload();
    });
	//Show the create api key dialog and universal api key note
	AJS.$('#show-universal-api-key-dialog-button').click(function(e) {
		e.preventDefault();
		AJS.$('#keyType').hide();
		AJS.$('#username-div').hide();
		var form = AJS.$('#create-api-keys-form');
		AJS.$('<input>')
			.attr({
				type: 'hidden',
				id: 'universal-key',
				name: 'isUniversal',
				value: true
			})
			.appendTo(form);
		AJS.$('#universal-note').css('display', 'block');
		AJS.dialog2('#api-key-dialog').show();
	});

	AJS.$('#show-other-user-api-key-dialog-button').click(function(e) {
		e.preventDefault();
		AJS.$('#username-div').show();
		AJS.$('#userName').auiSelect2({
			placeholder: 'Select the User',
			ajax: {
				url: AJS.contextPath() + '/plugins/servlet/rest/auth/moapi',
				data: function(params) {
					var query = {
						search: params,
						action: 'fetchUsers'
					};

					// Query parameters will be ?search=[term]&type=public
					return query;
				},
				results: function(data, page) {
					return {
						results: data.results
					};
				}
			}
		});
		AJS.dialog2('#api-key-dialog').show();
	});

	AJS.$('#expiryTime').change(function() {
		if (this.value === 'custom') {
			AJS.$('#custom_expiry_interval').show();
		} else {
			AJS.$('#custom_expiry_interval').hide();
		}
	});

	AJS.$('#keyType').change(function() {
		if (AJS.$('#keyType').val() === 'bearer') {
			AJS.$('#keyTypeDescription').html('Authorization: Bearer apikey');
		} else {
			AJS.$('#keyTypeDescription').html('Authorization: Basic username:apikey');
		}
	});

	//Closes the create api key dialog and reloads the page to show the new keys
	AJS.$('#close-api-key-dialog-button').click(function(e) {
		AJS.dialog2('#api-key-dialog').hide();
		window.location.reload();
	});

	AJS.$('#close-warning-dialog-button').click(function(e) {
        AJS.dialog2('#warning-dialog').hide();
    });

	AJS.$(document).on('keydown', '#name', function(e) {
		if (e.keyCode === 13) {
			AJS.$('#create-api-keys-form').submit();
		}
	});

	AJS.$(document).on('submit', '#create-api-keys-form', async function(e) {
		e.preventDefault();
		console.log('Create API Key submitted');
		var apiKey = await postForm(AJS.$('#create-api-keys-form'));
		console.log('API Key: ' + apiKey);
		AJS.$('#api-key-div').show();
		AJS.$('#key').val(apiKey.key);
		AJS.$('#create-api-key-button').hide();
	});

	//Copy the generated API key
	AJS.$(document).on('click', '#copy-api-key-button', function(e) {
		e.preventDefault();
		copyToClipboard(AJS.$('#key'), AJS.$('#copied-text'));
	});

	AJS.$('.delete-button').click(function(e) {
		e.preventDefault();
		var id = this.id;
		console.log("the id is " + id);
		AJS.$('#id').val(id.split('deleteIdp-')[1]);
        console.log("split is " + AJS.$('#id').val(id.split('deleteIdp-')[1]));
		AJS.dialog2('#delete-api-key-dialog').show();
	});

	AJS.$(document).on('submit', '#delete-api-keys-form', async function(e) {
		e.preventDefault();
		var id = AJS.$('#id').val();
		console.log("id = " + id);
		var currentUserToDisplayTokens = AJS.$("#currentUserToDisplayTokens").val();
		console.log("currentUserToDisplayTokens = " + currentUserToDisplayTokens);
		var apiKey = await deleteApiKeyRequest(id,currentUserToDisplayTokens);
		console.log('API Key: ' + apiKey);
		showSuccessMessage(apiKey.message);
		AJS.dialog2('#delete-api-key-dialog').hide();
		AJS.$('#div-' + id).remove();
	});

	AJS.$('#close-delete-api-key-dialog-button').click(function(e) {
		AJS.dialog2('#delete-api-key-dialog').hide();
	});

	function deleteApiKeyRequest(id,currentUserToDisplayTokens) {
		return new Promise(function(resolve) {
			console.log('Calling delete api key servlet');
			AJS.$.ajax({
				url:
					AJS.contextPath() +
					'/plugins/servlet/moapitokens/manage?' +
					AJS.$.param({
						id: id,
						currentUserToDisplayTokens : currentUserToDisplayTokens
					}),
				type: 'DELETE',
				async: false,
				success: function(data) {
					resolve(data);
				},
				error: function(response) {
					showErrorMessage(response.responseJSON.error.message);
				}
			});
		});
	}

	function postForm(form) {
		return new Promise(function(resolve) {
			console.log('Calling create api key servlet');

			AJS.$.ajax({
				url: AJS.contextPath() + '/plugins/servlet/moapitokens/manage',
				type: 'POST',
				data: form.serialize(),
				async: false,
				success: function(data) {
					resolve(data);
				},
				error: function(response) {
					
					showErrorMessage(response.responseJSON.error.message);
				}
			});
		});
	}

	function copyToClipboard(element, copyMessage) {
		element.select();
		document.execCommand('copy');
		copyMessage.show();
		setTimeout(function() {
			AJS.$(copyMessage).hide('slow');
		}, 5000);
	}

	function showErrorMessage(message) {
		AJS.flag({
			title: 'Error!',
			type: 'error',
			close: 'auto',
			body: '<p>' + message + '</p><br/>'
		});
	}

	function showSuccessMessage(message) {
		AJS.flag({
			title: 'Success',
			type: 'success',
			close: 'auto',
			body: '<p>' + message + '</p><br/>'
		});
	}
});

// Shows the dialog when the "Show dialog" button is clicked
