setTimeout(function()
{
  checkLicenseValidity();
} , 200);

var licenseFlag = null;

function checkLicenseValidity()
{
    console.log("check License validity called");
    var path = window.location.href;
    if(path.includes("/plugins/servlet/upm"))
    {
        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/rest/auth/moapi",
            data: {
                "action":"getLicenseValidity"
            },
            type: "GET",
            success: function (response) {
                if(response.validity === "expiring")
                {
                    licenseFlag = AJS.flag({
                    title: 'License expiring soon',
                    type: 'warning',
                    close: 'auto',
                    body: '<p>' + "The license for <b>mO API Token/OAuth Authentication for Confluence</b> expires in"+
                           '<b> less than 1 Month</b>.'  + ' Click the renew button in the addon listing to renew.</p>'+
                           '<br>'+
                           "<button class='aui-button' onclick='disableLicenseExpiringWarning()'>Don't show again</button>"
                    });
                }else if(response.validity === "expired")
                {
                     licenseFlag = AJS.flag({
                     title: 'License Expired',
                     type: 'error',
                     close: 'auto',
                     body: '<p>' + "The license for <b>mO API Token/OAuth Authentication for Confluence</b> has"+
                           '<b> expired</b>.'  + ' Click the renew button in the addon listing to renew.</p>'+
                           '<br>'+
                           "<button class='aui-button' onclick='disableLicenseExpiredWarning()'>Don't show again</button>"
                     });
                }
            }
        });
    }
}

function disableLicenseExpiringWarning()
{
    console.log("disable license expiring waring called:")
    AJS.$.ajax({
        url: AJS.contextPath() + "/plugins/servlet/rest/auth/moapi",
        data: {
            "action":"disableLicenseWarning",
            "licenseStatus" : "expiring"
        },
        type: "POST",
        success: function(response)
        {
             licenseFlag.close();
        }
    });
}

function disableLicenseExpiredWarning()
{
    console.log("disable license expired waring called:")
    AJS.$.ajax({
        url: AJS.contextPath() + "/plugins/servlet/rest/auth/moapi",
        data: {
            "action":"disableLicenseWarning",
            "licenseStatus" : "expired"
        },
        type: "POST",
        success: function(response)
        {
             licenseFlag.close();
        }
    });
}

