AJS.$(function () {
    //Show correct menu items as selected
    AJS.$(".aui-nav li").removeClass("aui-nav-selected");
    AJS.$("#oauth_provider_settings").addClass("aui-nav-selected");
    AJS.$("#mo-oauth").addClass("aui-nav-selected");
    AJS.$("#oauth_provider_tab").addClass("aui-nav-selected");
    AJS.$('#jwt_tab').addClass('aui-nav-selected');
    AJS.$('#jwt').addClass('aui-nav-selected');

    AJS.$(document).on("submit","#jwtForm", function (e) {
        e.preventDefault();
        console.log("JWT provider setttings form Submitted");
        postForm(AJS.$("#jwtForm"));
    });

});

function postForm(form) {

    AJS.$.ajax({
        url: AJS.contextPath() + "/plugins/servlet/restauth/jwt",
        type: 'POST',
        data: form.serialize(),
        async: false,
        success: function (data) {
            showSuccessMessage("Settings Saved Successfully");
        },
        error: function (response) {
            showErrorMessage(response.responseJSON.error.message);
        }
    });
}

function showErrorMessage(message){
    AJS.flag({
        title: 'Error!',
        type: 'error',
        close:'auto',
        body: '<p>'+message+'</p><br/>'
    });
}

function showSuccessMessage(message){
    AJS.flag({
        title: 'Success',
        type: 'success',
        close:'auto',
        body: '<p>'+message+'</p><br/>'
    });
}
