AJS.$(function () {
    AJS.$(".aui-nav li").removeClass("aui-nav-selected");
    AJS.$("#iprestriction").addClass("aui-nav-selected");


    if(document.getElementById("restrictIPEnabled").checked){
        AJS.$("#ip-details").show();
    }else{
        AJS.$("#ip-details").hide();
    }

    AJS.$("#restrictIPEnabled").change(function(){
        var restrictIPEnabled = document.getElementById("restrictIPEnabled").checked;
        if(restrictIPEnabled){
            AJS.$("#ip-details").show("slow");
        }else{
            AJS.$("#ip-details").hide("slow");
        }
    });


    AJS.$(document).on("submit","#iprestriction-setting", function (e) {
        e.preventDefault();
        console.log("IP Restriction Setttings Submitted");
        postForm(AJS.$("#iprestriction-setting"));
    });
});

    function postForm(form){

        console.log("Calling user restriction servlet");
        var apiKey;
        AJS.$.ajax({
            url: AJS.contextPath()+"/plugins/servlet/restauth/iprestriction",
            type: 'POST',
            data: form.serialize(),
            async: false,
            success: function(data) {
                showSuccessMessage("Settings Saved Successfully");
            },
            error: function(response) {
                showErrorMessage(response.responseJSON.error.message);
            }
        });

    }
    function postIP(val, id){
        AJS.$.ajax({
            url: AJS.contextPath()+"/plugins/servlet/restauth/iprestriction",
            type: 'POST',
            data: {val: val},
            async: false,
            success: function(data) {
                var element = document.getElementById(id);
                element.style.borderColor='#dfe1e6';
            },
            error: function(response) {
                var element = document.getElementById(id);
                element.style.borderColor="red";
            }
        });
    }

    function showErrorMessage(message){
        AJS.flag({
            title: 'Error!',
            type: 'error',
            close:'auto',
            body: '<p>'+message+'</p><br/>'
        });
    }
    function showSuccessMessage(message){
        AJS.flag({
            title: 'Success',
            type: 'success',
            close:'auto',
            body: '<p>'+message+'</p><br/>'
        });
    }




function restrictIPChange(){
    if(AJS.$("#restrictIPEnabled").is(":checked")){
        AJS.$("#ipaddress-div").show();
    }else{
        AJS.$("#ipaddress-div").hide();
    }
}
