AJS.$(function () {
    //Show correct menu items as selected
    AJS.$(".aui-nav li").removeClass("aui-nav-selected");
    AJS.$("#oauth_provider_settings").addClass("aui-nav-selected");
    AJS.$("#mo-oauth").addClass("aui-nav-selected");
    AJS.$("#oauth_provider_tab").addClass("aui-nav-selected");
    AJS.$('#authorization_grant').addClass('aui-nav-selected');
    AJS.$('#authorization_grant_tab').addClass('aui-nav-selected');

    AJS.$("#waiting-message").hide();
    // console.log("selected Index = " +AJS.$("#oauthProvider").attr("selectedIndex"))
    if(!AJS.$("#oauthProvider").val()){
        AJS.$("#section1").hide();
        AJS.$("#oauth-settings").hide();
        AJS.$("#fetchToken").hide();
    }
    if(AJS.$("#oauthProvider").val()){
        AJS.$("#section2").hide();
        if(AJS.$("#oauthProvider").val() == "custom"){
            AJS.$("#setup-guide").hide();
        }
    }
    AJS.$("#continue-to-setup").hide();
    AJS.$("#introspectionResponse-div").hide();

    loadSettings();
    AJS.$("#oauthProvider").change(function () {
        console.log("oAuth Provider Changed");
        AJS.$(".provider-fields").hide();
        AJS.$("#oauth-settings").hide();
        AJS.$("#fetchToken").hide();
        AJS.$("#continue-to-setup").show("slow");
        removeRequired('provider-fields');
        loadSettings();
    });

    AJS.$("#copy-redirect-uri").click(function(){
        var $temp = $("<input>");
        var element = AJS.$("#redirect-uri");
         $("body").append($temp);
         $temp.val($(element).html()).select();
         document.execCommand("copy");
         $temp.remove();
         AJS.$("#copy-redirect-uri").text("Copied");
    })

    AJS.$("#close-username-attr-dialog").click(function(e){
        e.preventDefault();
        AJS.dialog2("#get-username-attr-dialog").hide();
    })

    AJS.$("#continue-to-setup").click(function(){
        AJS.$("#oauth-settings").show();
        AJS.$("#continue-to-setup").hide("slow");
        AJS.$("#fetchToken").show();
    })

    AJS.$("#fetchToken").click(function(){
        fetchToken();
    });

    AJS.$("#fetchTokenButton").click(function(){
        if(checkMandatoryFeilds()){
            fetchToken();
        }
    });

    AJS.$("#getUsernameAttributeButton").click(function(e){
        if(checkMandatoryFeilds()){
            e.preventDefault();
            AJS.dialog2('#get-username-attr-dialog').show();
            loadSettings();
        }
    });

    AJS.$("#get-response").click(function(e){
        e.preventDefault();
        var introspection_endpoint = AJS.$("#introspection-endpoint-for-request").val();
        var access_token = AJS.$("#accessToken").val();
        var isAzureAD = AJS.$('#oauthProvider').val() === "Azure AD";
        if(!introspection_endpoint || !access_token){
            showErrorMessage("Please enter all the fields");
            return;
        }if(isAzureAD && !checkAzureAdTenantID(access_token)){
             showErrorMessage("Invalid Tenant ID");
        }else{
            sendGETRequest(introspection_endpoint,access_token);
        }

    });

    AJS.$('#close-get-username-attr-dialog').click(function(e) {
        e.preventDefault();
        AJS.dialog2('#get-username-attr-dialog').hide();
    });

        function fetchToken(){
            var fetchTokenUrl = AJS.contextPath() + '/plugins/servlet/restauth/authorize';
            var authEndpoint = AJS.$("#auth-endpoint").val();
            var tokenEndpoint = AJS.$("#token-endpoint").val();
            var parameters = "?action=configuration&authEndpoint="+authEndpoint+"&tokenEndpoint="+tokenEndpoint+"&clientID="+AJS.$("#clientID").val()+"&clientSecret="+AJS.$("#clientSecret").val()+"&scope="+AJS.$("#scope").val()+"&state="+AJS.$("#state").val()
            var myWindow = window.open(fetchTokenUrl+parameters, "Fetch OAuth 2.0 access token", "scrollbars=1 width=800, height=600");
        }

        function showErrorMessage(message){
            AJS.flag({
                type: 'error',
                close:'auto',
                body: '<p>'+message+'</p>'
            });
        }

        function sendGETRequest(introspection_endpoint, access_token){
            AJS.$.ajax({
                url : AJS.contextPath() + "/plugins/servlet/rest/auth/moapi",
                type : "GET",
                data :{
                    "action":"introspectionCall",
                    "endpoint":introspection_endpoint,
                    "token":access_token
                },
                beforeSend: function(request){
                    AJS.$('#waiting-message').show();
                },
                complete: function(){
                    AJS.$('#waiting-message').hide();
                },
                dataType : "json",
                success : function(response){
                    AJS.$("#introspectionResponse").html(JSON.stringify(response, undefined, 2));
                    AJS.$("#waiting-message").hide();
                    AJS.$("#introspectionResponse-div").show();
                },
                error : function(response){
                    showErrorMessage(JSON.stringify(response, undefined, 2));
                    AJS.$("#introspectionResponse").html(JSON.stringify(response, undefined, 2));
                    AJS.$("#waiting-message").hide();
                }
            });
        }



    AJS.$("#rest-api-setup-guides").click(function(){
        var oauthProvider = AJS.$('#oauthProvider').val();
        var OAuthUrl = AJS.contextPath() + '/plugins/servlet/rest/auth/downloadappguides';
        OAuthUrl += "?oauthProvider=" + oauthProvider;
        window.open(OAuthUrl, '_blank');
    });

    function checkAzureAdTenantID(token){
        try{
            var payloadJson = parseJwt(token);
            if(payloadJson.tid !== AJS.$("#azureAdTenantID").val()){
                return false;
            }else{
                return true;
            }
        }catch(err){
           showErrorMessage("Could not parse the token");
            return false;
        }
    }

    function parseJwt (token) {
        var base64Url = token.split('.')[1];
        var base64 = base64Url.replace(/-/g, '+').replace(/_/g, '/');
        var jsonPayload = decodeURIComponent(atob(base64).split('').map(function(c) {
            return '%' + ('00' + c.charCodeAt(0).toString(16)).slice(-2);
        }).join(''));

        return JSON.parse(jsonPayload);
    };

    function loadSettings(){
        var oauthProvider = AJS.$("#oauthProvider").val();
        AJS.$("#setup-guide").show();
        switch (oauthProvider) {
            case "Keycloak":
                showFields('keycloak_fields');
                var keycloak_host = AJS.$("#keycloak_host").val();
                var keycloak_realm = AJS.$("#keycloak_realm").val();
                AJS.$("#introspection_endpoint").text("{Host}/auth/realms/{Realm}/protocol/openid-connect/userinfo");
                AJS.$("#introspection-endpoint-for-request").val(keycloak_host+"/auth/realms/"+ keycloak_realm +"/protocol/openid-connect/userinfo");
                AJS.$("#auth-endpoint").val(keycloak_host+"/auth/realms/"+keycloak_realm+"/protocol/openid-connect/auth");
                AJS.$("#token-endpoint").val(keycloak_host+"/auth/realms/"+keycloak_realm+"/protocol/openid-connect/token");
                break;
            case "Salesforce":
                showFields('salesforce_fields');
                var salesforce_domain = AJS.$("#salesforce_domain").val();
                AJS.$("#introspection_endpoint").text("https://{Domain Name}/oauth2/userInfo");
                AJS.$("#introspection-endpoint-for-request").val("https://"+salesforce_domain+"/oauth2/userInfo");
                AJS.$("#auth-endpoint").val("https://login.salesforce.com/services/oauth2/authorize");
                AJS.$("#token-endpoint").val("https://login.salesforce.com/services/oauth2/token");
				break;
			case "Google":
                AJS.$("#introspection_endpoint").text("https://www.googleapis.com/oauth2/v1/userinfo?alt=json&");
                AJS.$("#introspection-endpoint-for-request").val("https://www.googleapis.com/oauth2/v1/userinfo?alt=json&");
                AJS.$("#auth-endpoint").val("https://accounts.google.com/o/oauth2/auth");
                AJS.$("#token-endpoint").val("https://www.googleapis.com/oauth2/v3/token");
				break;
		    case "Azure AD":
                showFields("azure_ad_fields");
		        var tenantID = AJS.$("#azureAdTenantID").val();
                AJS.$("#introspection_endpoint").text("https://graph.microsoft.com/v1.0/me");
                AJS.$("#introspection-endpoint-for-request").val("https://graph.microsoft.com/v1.0/me");
                AJS.$("#auth-endpoint").val("https://login.microsoftonline.com/"+tenantID+"/oauth2/v2.0/authorize");
                AJS.$("#token-endpoint").val("https://login.microsoftonline.com/"+tenantID+"/oauth2/token");
                break;
            case "Azure B2C":
                AJS.$("#introspection_endpoint").text("https://graph.microsoft.com/v1.0/me");
                AJS.$("#introspection-endpoint-for-request").val("https://graph.microsoft.com/v1.0/me");
                AJS.$("#auth-endpoint").val("https://login.microsoftonline.com/"+tenantID+"/oauth2/v2.0/authorize");
                AJS.$("#token-endpoint").val("https://login.microsoftonline.com/"+tenantID+"/oauth2/token");
                break;
            case "Discord":
                AJS.$("#introspection_endpoint").text("https://discordapp.com/api/users/@me");
                AJS.$("#introspection-endpoint-for-request").val("https://discordapp.com/api/users/@me");
                AJS.$("#auth-endpoint").val("https://discordapp.com/api/oauth2/authorize");
                AJS.$("#token-endpoint").val("https://discordapp.com/api/oauth2/token");
                break;
            case "Facebook":
                AJS.$("#introspection_endpoint").text("https://graph.facebook.com/me/?fields=id,name,email,age_range,first_name,gender,last_name,link&access_token=");
                AJS.$("#introspection-endpoint-for-request").val("https://graph.facebook.com/me/?fields=id,name,email,age_range,first_name,gender,last_name,link&access_token=");
                AJS.$("#auth-endpoint").val("https://www.facebook.com/dialog/oauth");
                AJS.$("#token-endpoint").val("https://graph.facebook.com/v2.8/oauth/access_token");
                break;
            case "Github":
                AJS.$("#introspection_endpoint").text("https://api.github.com/user");
                AJS.$("#introspection-endpoint-for-request").val("https://api.github.com/user");
                AJS.$("#auth-endpoint").val("https://github.com/login/oauth/authorize");
                AJS.$("#token-endpoint").val("https://github.com/login/oauth/access_token");
                break;
            case "Github Enterprise":
                AJS.$("#introspection_endpoint").text("https://api.github.com/user");
                AJS.$("#introspection-endpoint-for-request").val("https://api.github.com/user");
                AJS.$("#auth-endpoint").val("https://github.com/login/oauth/authorize");
                AJS.$("#token-endpoint").val("https://github.com/login/oauth/access_token");
                break;
            case "Gitlab":
                AJS.$("#introspection_endpoint").text("https://gitlab.com/api/v4/user");
                AJS.$("#introspection-endpoint-for-request").val("https://gitlab.com/api/v4/user");
                AJS.$("#auth-endpoint").val("https://gitlab.com/oauth/authorize");
                AJS.$("#token-endpoint").val("https://gitlab.com/oauth/token");
                break;
            case "Meetup":
                AJS.$("#introspection_endpoint").text("https://api.meetup.com/2/member/self/");
                AJS.$("#introspection-endpoint-for-request").val("https://api.meetup.com/2/member/self/");
                AJS.$("#auth-endpoint").val("https://secure.meetup.com/oauth2/authorize");
                AJS.$("#token-endpoint").val("https://secure.meetup.com/oauth2/access");
                break;
            case "Slack":
                AJS.$("#introspection_endpoint").text("https://slack.com/api/users.identity?token=");
                AJS.$("#introspection-endpoint-for-request").val("https://slack.com/api/users.identity?token=");
                AJS.$("#auth-endpoint").val("https://slack.com/oauth/authorize");
                AJS.$("#token-endpoint").val("https://secure.meetup.com/oauth2/access");
                break;
            case "AWS Cognito" :
                showFields('aws_cognito_fields');
                var awsCognitoDomainName = AJS.$("#awsCognitoDomainName").val();
                AJS.$("#introspection_endpoint").text("https://{Domain Name}/oauth2/userInfo");
                AJS.$("#introspection-endpoint-for-request").val("https://"+awsCognitoDomainName+"/oauth2/userInfo");
                AJS.$("#auth-endpoint").val("https://"+awsCognitoDomainName+"/oauth2/authorize");
                AJS.$("#token-endpoint").val("https://"+awsCognitoDomainName+"/oauth2/token");
                break;
            case "Okta" :
                showFields('okta_fields');
                var oktaDomainName = AJS.$("#oktaDomainName").val();
                AJS.$("#introspection_endpoint").text("https://{Domain Name}/oauth2/default/v1/userinfo");
                AJS.$("#introspection-endpoint-for-request").val("https://"+oktaDomainName+"/oauth2/default/v1/userinfo");
                AJS.$("#auth-endpoint").val("https://"+oktaDomainName+"/oauth2/default/v1/authorize");
                AJS.$("#token-endpoint").val("https://"+oktaDomainName+"/oauth2/default/v1/token");
                break;
//            case "Jwt" :
//                AJS.$("#introspection_endpoint_div").hide();
//                showFields('jwt_fields');
//                AJS.$("#introspection-endpoint-for-request").val("https://graph.microsoft.com/v1.0/me");
//                break;
            case "custom":
                AJS.$("#introspection_endpoint_div").hide();
                AJS.$("#setup-guide").hide();
                showFields('custom_fields');
                AJS.$("#introspection-endpoint-for-request").val(AJS.$("#introspectionEndpoint").val());
                AJS.$("#auth-endpoint").val(AJS.$("#authEndpointForCustomProvider").val());
                AJS.$("#token-endpoint").val(AJS.$("#tokenEndpointForCustomProvider").val());
                break;
        }
    }

    function showFields(divisionId) {
        AJS.$("#"+divisionId).show();
        addRequired(divisionId);
    }
    function removeRequired(divisonId){
        var inputs, index;
        inputs = document.getElementById(divisonId).getElementsByTagName('input');
        for (index = 0; index < inputs.length; ++index) {
            inputs[index].removeAttribute("required");
        }
    }

    AJS.$("#change-provider").click(function (){
        AJS.$("#section1").hide();
        AJS.$("#section2").show();
        AJS.$(".provider-fields").hide();
        AJS.$("#oauth-settings").hide();
        AJS.$("#fetchToken").hide();
        removeRequired('provider-fields');
    });

    AJS.$('#AWS_Cognito').click(function() { loadForm("AWS Cognito"); });
    AJS.$('#Azure_AD').click(function() { loadForm("Azure AD"); });
    AJS.$('#Azure_B2C').click(function() { loadForm("Azure B2C"); });
    AJS.$('#Discord').click(function() { loadForm("Discord"); });
    AJS.$('#Facebook').click(function() { loadForm("Facebook"); });
    AJS.$('#Github').click(function() { loadForm("Github"); });
    AJS.$('#Github_Enterprise').click(function() { loadForm("Github Enterprise"); });
    AJS.$('#Gitlab').click(function() { loadForm("Gitlab"); });
    AJS.$('#Google').click(function() { loadForm("Google"); });
    AJS.$('#Keycloak').click(function() { loadForm("Keycloak"); });
    AJS.$('#Meetup').click(function() { loadForm("Meetup"); });
    AJS.$('#Okta').click(function() { loadForm("Okta"); });
    AJS.$('#Salesforce').click(function() { loadForm("Salesforce"); });
    AJS.$('#Slack').click(function() { loadForm("Slack"); });
    AJS.$('#Custom').click(function() { loadForm("custom"); });


    function loadForm(provider){
        AJS.$("#oauthProvider").val(provider);
        AJS.$('#section2').hide();
        AJS.$('#section1').show();
        AJS.$("#continue-to-setup").show("slow");
        loadSettings();
    }

    function addRequired(divisionId){
        var inputs, index;
        inputs = document.getElementById(divisionId).getElementsByTagName('input');
        for (index = 0; index < inputs.length; ++index) {
            inputs[index].setAttribute("required",true);
        }
    }

    function checkMandatoryFeilds(){
        var clientid = document.getElementById("clientID").value
        var clientsecret = document.getElementById("clientSecret").value
        var scope = document.getElementById("scope").value
        if(clientid == '' || clientsecret == '' || scope == ''){
            showErrorMessage("Please enter valid clientId, clientSecret and scope")
            return false;
        }
        return true;
    }

});

function viewSetupGuides(){
    {
        const oauthProvider =  document.getElementById('oauthProvider').value;
        switch (oauthProvider) {
            case "Keycloak":
                window.open("https://www.miniorange.com/atlassian/rest-api-authentication-using-keycloak-as-oauth-provider", "_blank");
                break;
            case "Salesforce":
                window.open("https://www.miniorange.com/atlassian/rest-api-authentication-using-salesforce-as-oauth-provider", "_blank");
                break;
            case "Google":
                window.open("https://www.miniorange.com/atlassian/rest-api-authentication-using-google-apps-as-oauth-provider", "_blank");
                break;
            case "Azure AD":
                window.open("https://www.miniorange.com/atlassian/rest-api-authentication-using-azure-ad-as-oauth-provider", "_blank");
                break;
            case "Azure B2C":
                window.open("https://plugins.miniorange.com/rest-api-authentication-using-azure-b2c-as-oauth-provider", "_blank");
                break;
            case "Discord":
                window.open("https://plugins.miniorange.com/rest-api-authentication-using-discord-as-oauth-provider", "_blank");
                break;
            case "Facebook":
                window.open("https://plugins.miniorange.com/rest-api-authentication-using-facebook-as-oauth-provider", "_blank");
                break;
            case "Github":
                window.open("https://plugins.miniorange.com/rest-api-authentication-using-github-as-oauth-provider", "_blank");
                break;
            case "Github Enterprise":
                window.open("https://plugins.miniorange.com/rest-api-authentication-using-github-enterprise-as-oauth-provider", "_blank");
                break;
            case "Gitlab":
                window.open("https://plugins.miniorange.com/rest-api-authentication-using-gitlab-as-oauth-provider", "_blank");
                break;
            case "Meetup":
                window.open("https://plugins.miniorange.com/rest-api-authentication-using-meetup-as-oauth-provider", "_blank");
                break;
            case "Slack":
                window.open("https://plugins.miniorange.com/rest-api-authentication-using-slack-as-oauth-provider", "_blank");
                break;
            case "AWS Cognito" :
                window.open("https://www.miniorange.com/atlassian/rest-api-authentication-using-aws-cognito-as-oauth-provider", "_blank");
                break;
            case "Okta" :
                window.open("https://plugins.miniorange.com/rest-api-authentication-using-okta-as-oauth-provider", "_blank");
                break;
            default:
                window.open("https://plugins.miniorange.com/jira-rest-api-setup-guides", "_blank");
                break;
        }
    }
}

