AJS.$(function () {
    AJS.$(".aui-nav li").removeClass("aui-nav-selected");
    AJS.$("#auditLog").addClass("aui-nav-selected");
    AJS.$("#mo-auditLog").addClass("aui-nav-selected");

    AJS.$("#perform-search").click(function(){
        search();
    });

    AJS.$("#clear-logs").click(function(){
        clearLogs();
    });

    AJS.$("#export-logs").click(function(){
       exportLogs();
    });


    AJS.$(document).on('submit', '#auditLogSchedulerDetails', async function(e) {
    		e.preventDefault();
    		console.log('TimeStamp for Audit Logs deletion configured');
            AJS.$("#autoDeletionWarningMsg").hide();
            var data = await postForm(AJS.$('auditLogSchedulerDetails'));

    });

    AJS.$("#enableAuditLogs").change(function(){
        var enableAuditLogs = document.getElementById("enableAuditLogs").checked;
        if(enableAuditLogs){
            AJS.$("#schedularSettings").prop('disabled',false);
        }else{
            AJS.$("#schedularSettings").prop('disabled',true);
        }
    });

    AJS.$("#numberOfEntries").change(function(){
        var numberOfEntries = document.getElementById("numberOfEntries").value;
        if(numberOfEntries > 10000){
            AJS.$("#warning-icon").show("slow");
            document.getElementById("numberOfEntries-description").innerHTML = "The latest "+numberOfEntries+" logs will be retained.";
        }else{
            AJS.$("#warning-icon").hide("slow");
            document.getElementById("numberOfEntries-description").innerHTML = "The latest "+numberOfEntries+" logs will be retained.";
        }
    });

    AJS.$("#pastDays").change(function(){
        var pastDays = document.getElementById("pastDays").value;
        document.getElementById("pastDays-description").innerHTML = "The AuditLog entries past "+pastDays+" days will be cleared.";
    });

    toggleAuditLogs();
});

function search(){
    location.href = AJS.contextPath() + "/plugins/servlet/restauth/auditlog?filterLogsByPeriod="+AJS.$("#filterLogsByPeriod").val();
}

function changeAuditIndex(index)
{
  document.getElementById("currentIndex").value = index;
  location.href = AJS.contextPath() + "/plugins/servlet/restauth/auditlog?filterLogsByPeriod="+AJS.$("#filterLogsByPeriod").val()+"&currentIndex=" + AJS.$("#currentIndex").val();
}

function exportLogs(){
       location.href = AJS.contextPath() + "/plugins/servlet/restauth/exportlogs"
}

function exportOldLogs() {
    location.href = AJS.contextPath() + "/plugins/servlet/restauth/exportlogs?logType='old'";
}

function clearLogs(){
    if(confirm("Are you sure you want to clear all the logs?")){

        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/rest/auth/moapi?action=clearLogs",
            type: 'GET',
            async: false,
            success: function(response) {
                showSuccessMessage("Logs cleared Successfully");
            },
            error: function(response) {
                showErrorMessage("Error occurred while clearing the logs");
            }
        });
        setTimeout(function(){
            location.reload();
        },500);
   }
}

function postForm(form) {
        var pastDays = AJS.$("#pastDays").val();
        var numberOfEntries = AJS.$("#numberOfEntries").val();

		return new Promise(function(resolve) {

                AJS.$.ajax({
				url: AJS.contextPath() + '/plugins/servlet/restauth/auditlog',
				type: 'POST',
				data: {
				    "pastDays" : pastDays,
                    "numberOfEntries":numberOfEntries
				},
				async: false,
				success: function(data) {
					resolve(data);
					console.log("Success");
					showSuccessMessage(data.responseText);
				},
				error: function(response) {
                     if(response.status == 200)
                     {
                      console.log("Success");
                      showSuccessMessage(response.responseText);
                     }
                     else{
                     console.log("Error");
					 showErrorMessage(response.responseText);
					}
				}
			});
		});
	}

function displayAuditLogSettings()
{
    console.log("Displaying Audit Logs Settings");
    AJS.dialog2("#audit_log_settings").show();
    if (document.getElementById("numberOfEntries").value > 10000) {
        AJS.$("#warning-icon").show();
    } else {
        AJS.$("#warning-icon").hide();
    }
}

AJS.$(document).on('click', '#close-audit-log-scheduler-settings', async function(e) {
    		e.preventDefault();
    		console.log('Hiding Audit Logs Scheduler Settings');
    		AJS.dialog2("#audit_log_settings").hide();
            location.reload();
 });

function toggleAuditLogs(){
    AJS.$("#enableAuditLogs").change(function(){
            var enableAuditLogs = document.getElementById("enableAuditLogs").checked;
            if(enableAuditLogs){
                message = "Audit Logs enabled successfully";
            }else{
                message = "Audit Logs disabled successfully";
            }
            AJS.$.ajax({
                url: AJS.contextPath() + "/plugins/servlet/rest/auth/moapi",
                data: {
                    "action" : "enableAuditLogs",
                    "enableAuditLogs" : enableAuditLogs,
                },
                type: "GET",
                error: function (response) {
                    showErrorMessage("Could not enable Audit logs");
                },
                success: function(response)
                {
                    showSuccessMessage(message);
                }

            });
        });
}

function showErrorMessage(message){
        AJS.flag({
            title: 'Error!',
            type: 'error',
            close:'auto',
            body: '<p>'+message+'</p><br/>'
        });
    }
    function showSuccessMessage(message){
        AJS.flag({
            title: 'Success',
            type: 'success',
            close:'auto',
            body: '<p>'+message+'</p><br/>'
        })
    }

