/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.servlet;

import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.handler.MoOfflineLicenseHandler;
import com.miniorange.rest.auth.commons.util.MoHttpUtils;
import com.miniorange.rest.auth.commons.util.MoRESTUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoTestConfig
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoTestConfig.class);
    private final TemplateRenderer templateRenderer;
    private MoOfflineLicenseHandler moOfflineLicenseHandler;
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final I18nResolver i18nResolver;
    private static HttpURLConnection connection;
    private MoRESTAuthSettings settings;
    private MoHttpUtils moHttpUtils;
    private String response;
    private final String URL = this.getBaseUrl() + "/rest/api/group";
    private boolean isDatacenter;

    public MoTestConfig(TemplateRenderer templateRenderer, MoOfflineLicenseHandler moOfflineLicenseHandler, UserManager userManager, LoginUriProvider loginUriProvider, I18nResolver i18nResolver, MoRESTAuthSettings settings, MoHttpUtils moHttpUtils) {
        this.templateRenderer = templateRenderer;
        this.moOfflineLicenseHandler = moOfflineLicenseHandler;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.i18nResolver = i18nResolver;
        this.settings = settings;
        this.moHttpUtils = moHttpUtils;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOGGER.debug("inside doGet of TestConfig");
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null || !this.isAdministrator()) {
            this.redirectToLogin(req, resp);
            return;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("req", req);
        context.put("apiUrl", this.URL);
        context.put("isAdmin", this.isAdministrator());
        context.put("apistatus", "--");
        context.put("apiresponse", "--");
        context.put("oauthType", this.settings.getOauthTokenType());
        context.put("isDatacenter", this.settings.isDatacenter());
        resp.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("vm/testconfig.vm", context, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOGGER.debug("inside doPost of TestConfig");
        UserProfile user = this.userManager.getRemoteUser();
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (user == null || !this.isAdministrator()) {
            MoHttpUtils.sendError(resp, 403, this.i18nResolver.getText("restauth.error.forbidden"));
        }
        String apiKey = req.getParameter("apikey");
        String tokenType = req.getParameter("tokenType");
        LOGGER.debug("tokenType = " + tokenType);
        if (apiKey.isEmpty()) {
            // empty if block
        }
        if (this.settings.getHideSensitiveInformation().booleanValue()) {
            String screenedApiKey = this.moHttpUtils.screenAuthorizationToken(apiKey);
            LOGGER.debug("Api key is " + screenedApiKey);
        } else {
            LOGGER.debug("apikey = " + apiKey);
        }
        List<String> response = this.sendGETRequest(apiKey, this.URL, tokenType);
        String apiResponse = response.get(1);
        if (apiResponse.contains("401")) {
            apiResponse = "Invalid API KEY or the User is not Authenticated";
        }
        context.put("req", req);
        context.put("apiUrl", this.URL);
        context.put("apistatus", response.get(0));
        context.put("apiresponse", apiResponse);
        context.put("oauthType", this.settings.getOauthTokenType());
        context.put("isAdmin", this.isAdministrator());
        context.put("isDatacenter", this.settings.isDatacenter());
        resp.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("vm/testconfig.vm", context, (Writer)resp.getWriter());
    }

    private boolean isAdministrator() {
        UserProfile userProfile = this.userManager.getRemoteUser();
        return this.userManager.isAdmin(userProfile.getUserKey());
    }

    private void redirectToLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String LoginUri = MoRESTUtils.sanitizeText(this.loginUriProvider.getLoginUri(MoHttpUtils.getUri(req)).toASCIIString());
        resp.sendRedirect(LoginUri);
    }

    private List<String> sendGETRequest(String apiKey, String apiUrl, String tokenType) {
        int status = 400;
        StringBuffer responseContent = new StringBuffer();
        ArrayList<String> response = new ArrayList<String>();
        if (tokenType.equals("basic")) {
            if (!apiKey.contains("mo-api") && !apiKey.contains("mo-uni")) {
                StringBuffer message = new StringBuffer().append("Entered Key does not seem to be of the basic type, please try selecting Bearer as the token type");
                response.add(Integer.toString(status));
                response.add(responseContent.append(message).toString());
                return response;
            }
            apiKey = Base64.getEncoder().encodeToString(apiKey.getBytes());
        }
        try {
            String line;
            URL url = new URL(apiUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.addRequestProperty("Authorization", "Bearer " + apiKey);
            connection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:57.0) Gecko/20100101 Firefox/57.0");
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            status = connection.getResponseCode();
            BufferedReader reader = status > 299 ? new BufferedReader(new InputStreamReader(connection.getErrorStream())) : new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = reader.readLine()) != null) {
                responseContent.append(line);
            }
            reader.close();
            LOGGER.debug("response = " + responseContent);
            LOGGER.debug("status = " + status);
        }
        catch (Exception e) {
            LOGGER.debug("Exception occurred in test config = " + e);
        }
        response.add(Integer.toString(status));
        response.add(responseContent.toString());
        return response;
    }

    public String getBaseUrl() {
        SettingsManager settingsManager = (SettingsManager)ContainerManager.getComponent((String)"settingsManager");
        return settingsManager.getGlobalSettings().getBaseUrl();
    }
}

