/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.servlet;

import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.json.jsonorg.JSONTokener;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.user.User;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.page.Pager;
import com.google.gson.JsonParseException;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.dto.ApiKey;
import com.miniorange.rest.auth.commons.exceptions.MoPluginException;
import com.miniorange.rest.auth.commons.handler.MoRESTPluginHandler;
import com.miniorange.rest.auth.commons.handler.UtilDecisionHandler;
import com.miniorange.rest.auth.commons.util.MoHashUtils;
import com.miniorange.rest.auth.commons.util.MoHttpUtils;
import com.miniorange.rest.auth.commons.util.MoPluginConstants;
import com.miniorange.rest.auth.commons.util.PlatformUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoManageAPITokensViaRestAPI
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoManageAPITokensViaRestAPI.class);
    private final I18nResolver i18nResolver;
    private PlatformUtils platformUtils;
    private UserAccessor userAccessor;
    private MoRESTAuthSettings settings;
    private MoRESTPluginHandler moRESTPluginHandler;
    private MoHttpUtils moHttpUtils;
    private UserManager userManager;

    public MoManageAPITokensViaRestAPI(I18nResolver i18nResolver, UserAccessor userAccessor, MoRESTAuthSettings settings, MoRESTPluginHandler moRESTPluginHandler, MoHttpUtils moHttpUtils, UserManager userManager) {
        this.i18nResolver = i18nResolver;
        this.userAccessor = userAccessor;
        this.settings = settings;
        this.moRESTPluginHandler = moRESTPluginHandler;
        this.moHttpUtils = moHttpUtils;
        this.userManager = userManager;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, MoPluginException, JsonParseException {
        LOGGER.debug("Configure API tokens via Rest API servlet called from doGet");
        try {
            Enumeration headerNames = request.getHeaderNames();
            String value = "";
            String key = "";
            String username = "";
            String apiKey = "";
            String encodedKey = "";
            String expiryInterval = "0";
            String expiryIntervalCount = "0";
            String authorization = request.getHeader("Authorization");
            if (authorization == null) {
                this.showErrorMessage(response, 401, "Credentials are required to fetch the API token");
                return;
            }
            while (headerNames.hasMoreElements()) {
                key = (String)headerNames.nextElement();
                if (!StringUtils.equalsIgnoreCase("Authorization", key)) continue;
                value = request.getHeader(key);
                encodedKey = value = value.split(" ")[1];
                value = new String(org.apache.commons.codec.binary.Base64.decodeBase64((byte[])value.getBytes()), StandardCharsets.UTF_8);
                LOGGER.debug("The decoded key is  " + value);
                break;
            }
            String platform = this.i18nResolver.getText("my.plugin.platform");
            this.platformUtils = UtilDecisionHandler.getPlatFormUtils(platform);
            StringBuffer jb = new StringBuffer();
            String line = null;
            BufferedReader reader = request.getReader();
            while ((line = reader.readLine()) != null) {
                jb.append(line);
            }
            JSONTokener jsonTokener = new JSONTokener(jb.toString());
            JSONObject json = new JSONObject(jsonTokener);
            String keyName = json.getString("name");
            String expiryTime = json.getString("expiryTime");
            if (!expiryTime.equals("never")) {
                expiryInterval = json.getString("expiryInterval");
                expiryIntervalCount = json.getString("expiryIntervalCount");
            }
            if (expiryTime.equals("never")) {
                expiryTime = "";
            }
            expiryInterval = expiryInterval.equals("days") ? "5" : (expiryInterval.equals("months") ? "2" : "1");
            Boolean isExpiryValid = this.isExpiryValid(expiryTime, expiryInterval, expiryIntervalCount);
            LOGGER.debug("isExpiryValid:-" + isExpiryValid);
            if (value.split(":").length == 2) {
                LOGGER.debug("Api token is entered");
                String[] arr = value.split(":");
                username = arr[0];
                apiKey = arr[1];
                Boolean result = this.validateApiKey(username, apiKey);
                if (result.booleanValue()) {
                    ConfluenceUserImpl user = (ConfluenceUserImpl)this.userAccessor.getUserByName(username);
                    if (user != null) {
                        LOGGER.debug("Valid user");
                        if (this.checkUserPermissions(username).booleanValue()) {
                            LOGGER.error("Permissions denied");
                            this.showErrorMessage(response, 403, "User does not have permission to execute this operation");
                            return;
                        }
                        if (this.maxTokenCountReached(username).booleanValue()) {
                            LOGGER.debug("Maximum Token count exceeded");
                            this.showErrorMessage(response, 403, "Unable to create new token. Maximum tokens limit reached. Please delete expired/unused tokens to create new ones. Please contact your administrator if you want to increase the maximum token limit.");
                            return;
                        }
                        LOGGER.debug("Generating API token");
                        String name = this.moRESTPluginHandler.generateRandomAlphaNumericKey(24);
                        ApiKey apiKey1 = null;
                        apiKey1 = isExpiryValid == false ? this.moRESTPluginHandler.saveApiKey(keyName, username, "bearer", "custom", this.settings.getMaximumExpiryInterval(), this.settings.getMaximumExpiryCount(), platform, false) : this.moRESTPluginHandler.saveApiKey(keyName, username, "bearer", expiryTime, expiryInterval, expiryIntervalCount, platform, false);
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("Token Type", "Bearer");
                        jsonObject.put("Api Key ", apiKey1.getKey());
                        jsonObject.put("expires on", apiKey1.getExpiryDate());
                        this.showSuccessMessage(response, jsonObject, "Successfully generated api key");
                        return;
                    }
                    LOGGER.error("Invalid user");
                    this.showErrorMessage(response, 401, "Invalid user:- No user  or more than one user found with this username/email address");
                    return;
                }
                LOGGER.error("Invalid Api key entered");
                this.showErrorMessage(response, 401, "Entered api key does not match the keys configured for the user");
                return;
            }
            if (this.moRESTPluginHandler.isConfigured().booleanValue()) {
                LOGGER.debug("Access token is received");
                String userInfoResponse = this.moHttpUtils.verifyToken(encodedKey);
                if (userInfoResponse.equals("Verification failed")) {
                    this.showErrorMessage(response, 401, "Token verification failed");
                    return;
                }
                String userFetched = this.moRESTPluginHandler.getUsernameInResponse(userInfoResponse);
                ConfluenceUserImpl user = this.findUserbyUsernameOrEmail(userFetched);
                if (user == null) {
                    LOGGER.error("Invalid user");
                    this.showErrorMessage(response, 400, "No user or more than one user found with this username/email address");
                    return;
                }
                LOGGER.debug("Valid user found");
                if (this.checkUserPermissions(userFetched).booleanValue()) {
                    LOGGER.error("Permissions denied");
                    this.showErrorMessage(response, 403, "User does not have permission to execute this operation");
                    return;
                }
                if (this.maxTokenCountReached(userFetched).booleanValue()) {
                    LOGGER.debug("Maximum Token count exceeded");
                    this.showErrorMessage(response, 403, "Unable to create new token. Maximum tokens limit reached. Please delete expired/unused tokens to create new ones. Please contact your administrator if you want to increase the maximum token limit.");
                    return;
                }
                LOGGER.debug("Generating API key");
                String name = this.moRESTPluginHandler.generateRandomAlphaNumericKey(24);
                ApiKey apiKey2 = null;
                apiKey2 = isExpiryValid == false ? this.moRESTPluginHandler.saveApiKey(keyName, user.getName(), "bearer", "custom", this.settings.getMaximumExpiryInterval(), this.settings.getMaximumExpiryCount(), platform, false) : this.moRESTPluginHandler.saveApiKey(keyName, user.getName(), "bearer", expiryTime, expiryInterval, expiryIntervalCount, platform, false);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("Token Type", "Bearer");
                jsonObject.put("Api Key", apiKey2.getKey());
                jsonObject.put("expires on", apiKey2.getExpiryDate());
                this.showSuccessMessage(response, jsonObject, "Successfully generated Api token");
                return;
            }
            LOGGER.error("API token is not used or is invalid or OAuth provider is not configured");
            this.showErrorMessage(response, 400, "Api token is not used or is invalid or  Oauth provider is not configured");
            return;
        }
        catch (MoPluginException e) {
            LOGGER.error("An error occurred while verifying access token");
            this.showErrorMessage(response, 401, "An error occurred while verifying access token " + e.getMessage());
            return;
        }
        catch (JsonParseException e) {
            LOGGER.error("An error occurred while reading response from the provider" + (Object)((Object)e));
            this.showErrorMessage(response, 500, "Response from the provider is not correct json " + e.getMessage());
            return;
        }
        catch (Exception e) {
            LOGGER.error("Exception occured and it is " + e);
            this.showErrorMessage(response, 500, e.getMessage());
            return;
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse response) {
        LOGGER.debug("do post method called");
    }

    private void showErrorMessage(HttpServletResponse response, int errorCode, String description) {
        JSONObject json = new JSONObject();
        try {
            json.put("Status", "ERROR");
            json.put("Description", description);
            response.setStatus(errorCode);
            response.setContentType("application/json");
            response.getOutputStream().write(json.toString().getBytes(StandardCharsets.UTF_8));
            response.getOutputStream().close();
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while showing error messages. ", (Throwable)e);
        }
    }

    private boolean validateApiKey(String username, String apiKey) {
        LOGGER.debug("Validating API Key");
        byte[] salt = this.settings.getSalt(username);
        String hashedKey = MoHashUtils.hash(apiKey, salt);
        String encodedString = Base64.getEncoder().encodeToString(hashedKey.getBytes());
        ArrayList<List<String>> apiKeys = new ArrayList<List<String>>(this.moRESTPluginHandler.getApiKeysAfterMigration(username).values());
        for (List list : apiKeys) {
            if (!list.contains(encodedString)) continue;
            return list.contains(encodedString);
        }
        return false;
    }

    private Boolean isExpiryValid(String expiryTime, String expiryInterval, String expiryIntervalCount) {
        Date maxExpiryDate;
        if (!this.settings.getMaxExpiryTime()) {
            return true;
        }
        if (StringUtils.isBlank(expiryTime)) {
            return false;
        }
        String maximumExpiryCount = this.settings.getMaximumExpiryCount();
        String maximumExpiryInterval = this.settings.getMaximumExpiryInterval();
        Date currentDate = new Date();
        Date inputExpiryDate = this.moRESTPluginHandler.calculateExpiryDate(currentDate, expiryTime, expiryInterval, expiryIntervalCount);
        return !inputExpiryDate.after(maxExpiryDate = this.moRESTPluginHandler.calculateExpiryDate(currentDate, expiryTime, maximumExpiryInterval, maximumExpiryCount));
    }

    private void showSuccessMessage(HttpServletResponse response, JSONObject message, String description) {
        JSONObject json = new JSONObject();
        try {
            json.put("Status", "Success");
            json.put("Message", message);
            json.put("Description", description);
            response.setStatus(200);
            response.setContentType("application/json");
            response.getOutputStream().write(json.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            LOGGER.error("An exception occured while creating tokens");
            e.printStackTrace();
        }
    }

    public ConfluenceUserImpl findUserbyUsernameOrEmail(String usernameOrEmail) {
        ConfluenceUserImpl user = (ConfluenceUserImpl)this.userAccessor.getUserByName(usernameOrEmail);
        if (user != null) {
            return user;
        }
        LOGGER.debug("email = " + usernameOrEmail);
        String username = this.searchUserByEmail(usernameOrEmail);
        LOGGER.debug("found username = " + username);
        if (username == null) {
            return null;
        }
        return (ConfluenceUserImpl)this.userAccessor.getUserByName(username);
    }

    public String searchUserByEmail(String email) {
        LOGGER.debug("Searching for Confluence user with email : " + email);
        int count = 0;
        String username = "";
        SearchResult searchResult = this.userAccessor.getUsersByEmail(email);
        Pager pager = searchResult.pager();
        for (User user : pager) {
            username = user.getName();
            ++count;
        }
        if (count > 1) {
            LOGGER.debug("Multiple users with same email found");
            return null;
        }
        LOGGER.debug("Found user by email = " + username);
        return username;
    }

    public Boolean maxTokenCountReached(String username) {
        Integer apiKeyCount = this.moRESTPluginHandler.getApiKeysAfterMigration(username).size();
        Integer maxTokenCount = Integer.parseInt(this.settings.getMaximumTokenCount());
        Boolean maxTokenEnabled = this.settings.getMaxToken();
        UserProfile userProfile = this.userManager.getUserProfile(username);
        boolean isAdmin = this.userManager.isAdmin(userProfile.getUserKey());
        List<ApiKey> universalKeys = this.moRESTPluginHandler.getApiKeys(MoPluginConstants.ApiConstants.UNIVERSAL_API_KEYS.getKey());
        return !isAdmin && maxTokenEnabled != false && apiKeyCount + universalKeys.size() >= maxTokenCount;
    }

    public Boolean checkUserPermissions(String username) {
        UserProfile user = this.userManager.getUserProfile(username);
        boolean isAdmin = this.userManager.isAdmin(user.getUserKey());
        boolean usersAllowedToCreateTokens = this.settings.getAllowUsersToCreateTokens();
        boolean restrictTokenGenerationGroupEnabled = this.settings.getRestrictTokenGenerationGroupEnabled();
        boolean userIsInPermittedGroups = false;
        List restrictTokenGenerationGroupsList = (List)this.settings.getRestrictTokenGenerationGroups();
        if (!restrictTokenGenerationGroupsList.isEmpty()) {
            for (String restrictTokenGenerationGroup : restrictTokenGenerationGroupsList) {
                if (!this.userManager.isUserInGroup(username, restrictTokenGenerationGroup)) continue;
                userIsInPermittedGroups = true;
                break;
            }
        }
        return !isAdmin && (!usersAllowedToCreateTokens || restrictTokenGenerationGroupEnabled && !userIsInPermittedGroups);
    }
}

