/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.filter;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.message.I18nResolver;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.handler.MoRESTPluginHandler;
import com.miniorange.rest.auth.commons.util.MoHttpUtils;
import com.miniorange.rest.auth.commons.util.MoPluginConstants;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoUserRestrictionFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoUserRestrictionFilter.class);
    private UserAccessor userAccessor;
    private MoRESTAuthSettings settings;
    private MoRESTPluginHandler pluginHandler;
    private I18nResolver i18nResolver;
    private MoHttpUtils moHttpUtils;

    public MoUserRestrictionFilter(UserAccessor userAccessor, MoRESTAuthSettings settings, I18nResolver i18nResolver, MoRESTPluginHandler pluginHandler, MoHttpUtils moHttpUtils) {
        this.userAccessor = userAccessor;
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.i18nResolver = i18nResolver;
        this.moHttpUtils = moHttpUtils;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        LOGGER.debug("User Restriction Filter is called");
        try {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            if (!this.settings.isLicenseValid().booleanValue() || !this.settings.isLicenseDefined()) {
                chain.doFilter(request, response);
                return;
            }
            if (!this.pluginHandler.isAuthenticationEnabled()) {
                chain.doFilter(request, response);
                return;
            }
            Cookie guestCookie = MoUserRestrictionFilter.getCookie(req, MoPluginConstants.SettingsConstants.GUEST_COOKIE.getKey());
            if (guestCookie != null) {
                LOGGER.info("Guest login cookie is present, skipping authentication");
                chain.doFilter(request, response);
                return;
            }
            String authorizationHeader = req.getHeader("Authorization");
            if (StringUtils.isNotBlank(authorizationHeader)) {
                String[] tokenComponents = StringUtils.split(authorizationHeader);
                String method = tokenComponents[0];
                String authorizationToken = tokenComponents[1];
                LOGGER.debug("Hide sensitive information is set to " + this.settings.getHideSensitiveInformation());
                if (this.settings.getHideSensitiveInformation().booleanValue()) {
                    String encryptedAuthorizationToken = this.moHttpUtils.screenAuthorizationToken(authorizationToken);
                    LOGGER.debug("authrorization header = " + method + " " + encryptedAuthorizationToken);
                } else {
                    LOGGER.debug("authorizationHeader = " + authorizationHeader);
                }
                if (StringUtils.equalsIgnoreCase(method, "oauth")) {
                    LOGGER.debug("Confluence internal OAuth 1.0 call skipping authentication");
                    chain.doFilter(request, response);
                    return;
                }
            }
            String username = AuthenticatedUserThreadLocal.getUsername();
            Map<String, String> apiUrls = this.settings.getPublicApiUrls();
            String requestURI = req.getRequestURI();
            requestURI = requestURI.replace(req.getContextPath(), "");
            if (apiUrls != null && username == null) {
                for (String value : apiUrls.values()) {
                    if (!requestURI.contains(value)) continue;
                    MoHttpUtils.sendError(resp, 401, this.i18nResolver.getText("restauth.error.authentication.missing.token"));
                    return;
                }
            }
            if (StringUtils.isBlank(authorizationHeader)) {
                LOGGER.debug("Authorization Header is not present. Skipping Authentication");
                chain.doFilter(request, response);
                return;
            }
            if (!this.settings.getRestrictGroupEnabled().booleanValue() && !this.settings.getReadOnlyGroupsEnabled().booleanValue()) {
                this.pluginHandler.saveAuditLogs(username, req.getRemoteAddr(), req.getRequestURI(), req.getMethod(), "Successful");
                LOGGER.debug("the group restriction is not enabled");
                chain.doFilter(request, response);
                return;
            }
            LOGGER.debug("Username {}", (Object)username);
            LOGGER.debug("Checking if allowed access to API");
            if (this.settings.getRestrictGroupEnabled().booleanValue() && this.restrictUser(username)) {
                LOGGER.debug("User is not the member of configured group for API Access");
                this.pluginHandler.saveAuditLogs(username, req.getRemoteAddr(), req.getRequestURI(), req.getMethod(), "Access Forbidden");
                MoHttpUtils.sendError(resp, 403, this.i18nResolver.getText("restauth.error.userrestriction"));
                return;
            }
            LOGGER.debug("Checking if read only groups");
            if (this.settings.getReadOnlyGroupsEnabled().booleanValue() && this.checkIfUserBelongsToReadOnlyGroup(username).booleanValue() && !req.getMethod().equals("GET")) {
                LOGGER.debug("User does not have permission to execute this operation");
                this.pluginHandler.saveAuditLogs(username, req.getRemoteAddr(), req.getRequestURI(), req.getMethod(), "Access Forbidden");
                MoHttpUtils.sendError(resp, 401, "User does not have permission to execute this operation");
                return;
            }
            this.pluginHandler.saveAuditLogs(username, req.getRemoteAddr(), req.getRequestURI(), req.getMethod(), "Successful");
            chain.doFilter(request, response);
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred in User restriction filter = " + e);
            chain.doFilter(request, response);
            return;
        }
    }

    public Boolean checkIfUserBelongsToReadOnlyGroup(String username) {
        ArrayList readOnlyGroups = (ArrayList)this.settings.getReadOnlyGroups();
        for (String group : readOnlyGroups) {
            if (!this.hasMembership(group, username)) continue;
            return true;
        }
        return false;
    }

    public boolean restrictUser(String username) {
        ArrayList groupList = (ArrayList)this.settings.getGroups();
        for (String group : groupList) {
            if (!this.hasMembership(group, username)) continue;
            return false;
        }
        return true;
    }

    public static Cookie getCookie(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                return cookie;
            }
        }
        return null;
    }

    private boolean hasMembership(String group, String username) {
        List groupNames = this.userAccessor.getGroupNamesForUserName(username);
        return groupNames.contains(group);
    }

    public String screenAuthorizationToken(String token) {
        if (token.length() <= 3) {
            token.replaceAll(".", "*");
        } else {
            StringBuilder sb = new StringBuilder(token);
            int authorizationTokenLength = token.length();
            int midAuthorizationToken = authorizationTokenLength / 2;
            sb.setCharAt(midAuthorizationToken, '*');
            sb.setCharAt(midAuthorizationToken - 1, '*');
            sb.setCharAt(midAuthorizationToken + 1, '*');
            token = sb.toString();
        }
        return token;
    }

    public void destroy() {
    }
}

