/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.filter;

import com.atlassian.confluence.security.seraph.ConfluenceUserPrincipal;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.User;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.page.Pager;
import com.google.gson.JsonParseException;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.dto.APIAuditRecord;
import com.miniorange.rest.auth.commons.exceptions.MoPluginException;
import com.miniorange.rest.auth.commons.handler.ApiKeyAuthenticationHandler;
import com.miniorange.rest.auth.commons.handler.MoRESTDecisionHandler;
import com.miniorange.rest.auth.commons.handler.MoRESTPluginHandler;
import com.miniorange.rest.auth.commons.util.MoHttpUtils;
import com.miniorange.rest.auth.commons.util.MoOAuthUtils;
import com.miniorange.rest.auth.commons.util.MoPluginConstants;
import com.miniorange.rest.auth.commons.util.MoRESTUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoRestAPIFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoRestAPIFilter.class);
    private UserAccessor userAccessor;
    private UserManager userManager;
    private MoRESTAuthSettings settings;
    private MoRESTPluginHandler pluginHandler;
    private MoRESTDecisionHandler decisionHandler;
    private ApiKeyAuthenticationHandler apiKeyAuthenticationHandler;
    private I18nResolver i18nResolver;
    private CrowdService crowdService;
    private MoHttpUtils moHttpUtils;
    private MoOAuthUtils moOAuthUtils;

    public MoRestAPIFilter(UserAccessor userAccessor, UserManager userManager, MoRESTAuthSettings settings, MoRESTPluginHandler pluginHandler, MoRESTDecisionHandler decisionHandler, ApiKeyAuthenticationHandler apiKeyAuthenticationHandler, I18nResolver i18nResolver, CrowdService crowdService, MoHttpUtils moHttpUtils, MoOAuthUtils moOAuthUtils) {
        this.userAccessor = userAccessor;
        this.userManager = userManager;
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.decisionHandler = decisionHandler;
        this.apiKeyAuthenticationHandler = apiKeyAuthenticationHandler;
        this.i18nResolver = i18nResolver;
        this.crowdService = crowdService;
        this.moHttpUtils = moHttpUtils;
        this.moOAuthUtils = moOAuthUtils;
    }

    public void init(FilterConfig filterConfig) {
    }

    /*
     * Unable to fully structure code
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block53: {
            MoRestAPIFilter.LOGGER.debug("Filter is called");
            req = (HttpServletRequest)request;
            resp = (HttpServletResponse)response;
            if (!this.settings.isLicenseValid().booleanValue() || !this.settings.isLicenseDefined()) {
                MoRestAPIFilter.LOGGER.error("No valid license found");
                chain.doFilter(request, response);
                return;
            }
            if (!this.pluginHandler.isAuthenticationEnabled()) {
                chain.doFilter(request, response);
                return;
            }
            requestURI = req.getRequestURI();
            authorizationHeader = req.getHeader("Authorization");
            access_token = req.getParameter("access_token");
            MoRestAPIFilter.LOGGER.debug("Request uri = " + req.getRequestURI());
            if (StringUtils.isBlank(authorizationHeader) && StringUtils.isBlank(access_token)) {
                MoRestAPIFilter.LOGGER.debug("Authorization Header is not present. Skipping Authentication");
                chain.doFilter(request, response);
                return;
            }
            bypassUrl = this.bypassApiUrls(request);
            if (bypassUrl.booleanValue()) {
                chain.doFilter(request, response);
                return;
            }
            if (StringUtils.isNotBlank(authorizationHeader)) {
                tokenComponents = StringUtils.split(authorizationHeader);
                method = tokenComponents[0];
                MoRestAPIFilter.LOGGER.debug("Method {}", (Object)method);
                if (StringUtils.equalsIgnoreCase(method, "oauth")) {
                    MoRestAPIFilter.LOGGER.debug("Confluence internal OAuth 1.0 call skipping authentication");
                    chain.doFilter(request, response);
                    return;
                }
                authorizationToken = tokenComponents[1];
                if (this.settings.getHideSensitiveInformation().booleanValue()) {
                    encryptedAuthorizationToken = this.moHttpUtils.screenAuthorizationToken(authorizationToken);
                    MoRestAPIFilter.LOGGER.debug("Authorization header = " + method + " " + encryptedAuthorizationToken);
                } else {
                    MoRestAPIFilter.LOGGER.debug("Authorization header = " + method + " " + authorizationToken);
                }
            } else {
                authorizationToken = access_token;
                if (this.settings.getHideSensitiveInformation().booleanValue()) {
                    encryptedAuthorizationToken = this.moHttpUtils.screenAuthorizationToken(authorizationToken);
                    MoRestAPIFilter.LOGGER.debug("Access Token {}" + encryptedAuthorizationToken);
                } else {
                    MoRestAPIFilter.LOGGER.debug("Access Token {}" + authorizationToken);
                }
                method = "Bearer";
            }
            if (StringUtils.isBlank(authorizationToken)) {
                MoHttpUtils.sendError(resp, 401, this.i18nResolver.getText("restauth.error.authentication.missing.token"));
            }
            try {
                decodedKey = new String(Base64.decodeBase64((byte[])authorizationToken.getBytes()), StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                MoRestAPIFilter.LOGGER.debug("could not decode the key");
                decodedKey = "";
            }
            apiAudit = new APIAuditRecord();
            if (this.settings.getRestrictIPEnabled() && this.settings.getRestrictedIP().size() != 0 && !this.pluginHandler.verifyIp(req)) {
                MoRestAPIFilter.LOGGER.debug("Not a valid ip address");
                MoHttpUtils.sendError(resp, 403, this.i18nResolver.getText("restauth.error.iprestriction"));
                return;
            }
            shouldContinue = this.decisionHandler.shouldContinue(method, decodedKey);
            if (!shouldContinue) {
                chain.doFilter(request, response);
                return;
            }
            apiAudit.setApiUri(req.getRequestURI());
            if (decodedKey.split(":").length == 2) {
                try {
                    apiAudit = this.apiKeyAuthenticationHandler.performApiKeyAuthentication(decodedKey, apiAudit);
                    if (StringUtils.equals(apiAudit.getStatus(), MoPluginException.PluginErrorCode.PASSING_FOR_PAT.name())) {
                        if (this.settings.getAllowPATTokens().booleanValue()) {
                            MoRestAPIFilter.LOGGER.debug("By passing RESTAPI Filter for PAT tokens");
                            chain.doFilter(request, response);
                            return;
                        }
                        MoHttpUtils.sendError(resp, 400, "PAT Tokens are disabled");
                        return;
                    }
                    if (!StringUtils.equals(apiAudit.getStatus(), MoPluginConstants.Status.SUCCESS.name())) {
                        MoRestAPIFilter.LOGGER.error("Failed to authenticate the request");
                        throw new MoPluginException(MoPluginException.PluginErrorCode.valueOf(apiAudit.getStatus()));
                    }
                    this.setRateLimitingHeaders(apiAudit, (HttpServletResponse)response);
                    username = apiAudit.getUsername();
                    MoRestAPIFilter.LOGGER.debug("Username after validating API Key " + username);
                    user = this.findUserbyUsernameOrEmail(username);
                    if (user == null) {
                        MoHttpUtils.sendError(resp, 400, "No user found with this username/email address");
                        return;
                    }
                    isUserAuthenticated = this.authenticateUser(req, resp, username);
                    if (!isUserAuthenticated) {
                        MoRestAPIFilter.LOGGER.error("Failed to authenticate the user");
                        MoHttpUtils.sendError(resp, 401, "Failed to authenticate the user");
                        return;
                    }
                    break block53;
                }
                catch (MoPluginException e) {
                    username = apiAudit.getUsername();
                    MoRestAPIFilter.LOGGER.debug("Exception occurred while authenticating the token = " + e);
                    user = this.findUserbyUsernameOrEmail(username);
                    if (e.getErrorCode().equals((Object)MoPluginException.PluginErrorCode.INVALID_API_KEY)) {
                        MoHttpUtils.sendError(resp, 401, e.getMessage());
                        return;
                    }
                    if (e.getErrorCode().equals((Object)MoPluginException.PluginErrorCode.RATE_LIMIT_EXCEEDED)) {
                        this.setRateLimitingHeaders(apiAudit, (HttpServletResponse)response);
                        MoHttpUtils.sendError(resp, 429, e.getMessage());
                        return;
                    }
                    this.setRateLimitingHeaders(apiAudit, (HttpServletResponse)response);
                    MoHttpUtils.sendError(resp, 400, e.getMessage());
                    return;
                }
            }
            if (this.pluginHandler.isConfigured().booleanValue()) {
                MoRestAPIFilter.LOGGER.debug("Authenticating with Configured Oauth2.0 provider");
                try {
                    action = this.settings.getOauthTokenType();
                    if (StringUtils.isBlank(action)) {
                        action = "";
                    }
                    username = "";
                    clientID = "";
                    user = null;
                    var19_31 = action;
                    var20_33 = -1;
                    switch (var19_31.hashCode()) {
                        case 73895: {
                            if (!var19_31.equals("JWT")) break;
                            var20_33 = 0;
                            break;
                        }
                        case 1893505123: {
                            if (!var19_31.equals("Client-Creds")) break;
                            var20_33 = 1;
                        }
                    }
                    switch (var20_33) {
                        case 0: {
                            username = this.moOAuthUtils.jwtTokenVerification(authorizationToken);
                            break;
                        }
                        case 1: {
                            clientID = this.moOAuthUtils.clientCredTokenVerification(authorizationToken, req, resp);
                            break;
                        }
                        default: {
                            username = MoOAuthUtils.oauthTokenVerification(authorizationToken, req, resp);
                            if (username != null) break;
                            MoHttpUtils.sendError(resp, 400, "No user found with this username/email address");
                            return;
                        }
                    }
                    if (!action.equals("Client-Creds")) {
                        var19_31 = username;
                        var20_33 = -1;
                        switch (var19_31.hashCode()) {
                            case 1427165652: {
                                if (!var19_31.equals("expiredToken")) break;
                                var20_33 = 0;
                                break;
                            }
                            case 516913730: {
                                if (!var19_31.equals("invalidToken")) break;
                                var20_33 = 1;
                            }
                        }
                        switch (var20_33) {
                            case 0: {
                                MoHttpUtils.sendError(resp, 401, "Token Expired: The token provided is expired.");
                                return;
                            }
                            case 1: {
                                MoHttpUtils.sendError(resp, 400, "Token Invalid: Error while validating the token.");
                                return;
                            }
                        }
                        user = this.findUserbyUsernameOrEmail(username);
                        if (user == null) {
                            MoRestAPIFilter.LOGGER.debug("No user found with username {}", (Object)username);
                            MoHttpUtils.sendError(resp, 400, "No user found with this username/email address");
                            return;
                        }
                        MoRestAPIFilter.LOGGER.debug("username in response {}", (Object)user.getName());
                        if (StringUtils.isBlank(username)) {
                            throw new MoPluginException(MoPluginException.PluginErrorCode.INCORRECT_USERNAME);
                        }
                        isUserAuthenticated = this.authenticateUser(req, resp, user.getName());
                        if (isUserAuthenticated) ** GOTO lbl188
                        throw new MoPluginException(MoPluginException.PluginErrorCode.UNKNOWN);
                    }
                    service_acc = this.settings.getServiceAccountUsername();
                    MoRestAPIFilter.LOGGER.debug("Service account is: " + service_acc);
                    client_id = this.settings.getClientCredClientId();
                    if (StringUtils.equals(client_id, clientID)) {
                        MoRestAPIFilter.LOGGER.debug("service account username" + service_acc);
                        this.authenticateUser(req, resp, service_acc);
                    }
                    MoHttpUtils.sendError(resp, 401, "Expired Token / invalid_client_ID");
                    return;
                }
                catch (MoPluginException e) {
                    MoRestAPIFilter.LOGGER.error("An error occurred while verifying access token ", (Throwable)e);
                    userInfoResponse = this.moHttpUtils.verifyToken(authorizationToken);
                    if (userInfoResponse.equals("verificationFailed")) {
                        return;
                    }
                    username = this.pluginHandler.getUsernameInResponse(userInfoResponse);
                    user = this.findUserbyUsernameOrEmail(username);
                    MoHttpUtils.sendError(resp, 401, e.getMessage());
                    return;
                }
                catch (JsonParseException e) {
                    MoRestAPIFilter.LOGGER.error("An error occurred while reading response from provider ", (Throwable)e);
                    MoHttpUtils.sendError(resp, 500, "Response from provider is not correct json");
                    return;
                }
            } else {
                MoRestAPIFilter.LOGGER.debug("API token is not used or is invalid and OAuth provider is not configured. Skipping Authentication");
            }
        }
        chain.doFilter(request, response);
    }

    public String searchUserByEmail(String email) {
        LOGGER.debug("Searching for Confluence user with email : " + email);
        int count = 0;
        String username = "";
        SearchResult searchResult = this.userAccessor.getUsersByEmail(email);
        Pager pager = searchResult.pager();
        for (User user : pager) {
            username = user.getName();
            ++count;
        }
        if (count > 1) {
            LOGGER.debug("Multiple users with same email found");
            return null;
        }
        LOGGER.debug("Found user by email = " + username);
        return username;
    }

    public ConfluenceUserImpl findUserbyUsernameOrEmail(String usernameOrEmail) {
        ConfluenceUserImpl user = (ConfluenceUserImpl)this.userAccessor.getUserByName(usernameOrEmail);
        if (user != null) {
            return user;
        }
        LOGGER.debug("email = " + usernameOrEmail);
        String username = this.searchUserByEmail(usernameOrEmail);
        LOGGER.debug("found username = " + username);
        if (username == null) {
            return null;
        }
        return (ConfluenceUserImpl)this.userAccessor.getUserByName(username);
    }

    private Boolean checkIfUserBelongsToReadOnlyGroup(String username) {
        List readOnlyGroups = (List)this.settings.getReadOnlyGroups();
        List userGroups = this.userAccessor.getGroupNamesForUserName(username);
        for (String readOnlyGroup : readOnlyGroups) {
            for (String userGroup : userGroups) {
                if (!userGroup.equals(readOnlyGroup)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean authenticateUser(HttpServletRequest req, HttpServletResponse response, String username) throws IOException {
        ConfluenceUser user = this.userAccessor.getUserByName(username = MoRESTUtils.sanitizeText(username));
        if (user == null) {
            LOGGER.error("Could not find the user with username {}", (Object)username);
            MoHttpUtils.sendError(response, 404, "Could not find the user in Confluence");
            return false;
        }
        ConfluenceUserPrincipal userPrincipal = new ConfluenceUserPrincipal(user);
        HttpSession session = req.getSession(true);
        session.setAttribute("seraph_defaultauthenticator_user", (Object)userPrincipal);
        AuthenticatedUserThreadLocal.set((ConfluenceUser)user);
        LOGGER.debug("User with username {} is authenticated successfully", (Object)username);
        return true;
    }

    public Boolean bypassApiUrls(ServletRequest request) {
        Map<String, String> bypassApiUrls = this.settings.getBypassApiUrls();
        HttpServletRequest req = (HttpServletRequest)request;
        String requestURI = req.getRequestURI();
        boolean bypassUrlFound = false;
        if (bypassApiUrls != null) {
            LOGGER.debug("the bypass urls are not equal to null");
            for (String bypassApiUrl : bypassApiUrls.values()) {
                if (!requestURI.contains(bypassApiUrl = bypassApiUrl.trim())) continue;
                LOGGER.debug("The url is configured for bypassed , so skipping authentication");
                bypassUrlFound = true;
                break;
            }
        }
        return bypassUrlFound;
    }

    public void setRateLimitingHeaders(APIAuditRecord apiAudit, HttpServletResponse response) {
        if (this.settings.getEnableRateLimiting()) {
            HashMap<String, String> headers = apiAudit.getRateLimitingHeaders();
            for (Map.Entry<String, String> header : headers.entrySet()) {
                response.addHeader(header.getKey(), header.getValue());
            }
        }
    }

    public void destroy() {
    }
}

