/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.util;

import com.miniorange.rest.auth.commons.util.MoPluginConstants;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;

public class MoRESTUtils {
    public static String constructKeyCloakEndpoint(String host, String realm) {
        String userinfoEndpoint = MoPluginConstants.EndPointConstants.KEYCLOAK_USERINFO_ENDPOINT.getValue();
        userinfoEndpoint = StringUtils.replace(userinfoEndpoint, "##host##", host);
        userinfoEndpoint = StringUtils.replace(userinfoEndpoint, "##realm##", realm);
        return userinfoEndpoint;
    }

    public static String constructSalesforceEndpoint(String domain) {
        String userinfoEndpoint = MoPluginConstants.EndPointConstants.SALESFORCE_USERINFO_ENDPOINT.getValue();
        userinfoEndpoint = StringUtils.replace(userinfoEndpoint, "##domain##", domain);
        return userinfoEndpoint;
    }

    public static String constructAWSCognitoEndpoint(String domainName) {
        String userinfoEndpoint = MoPluginConstants.EndPointConstants.AWS_COGNITO_USERINFO_ENDPOINT.getValue();
        userinfoEndpoint = StringUtils.replace(userinfoEndpoint, "##domainName##", domainName);
        return userinfoEndpoint;
    }

    public static String constructOktaEndpoint(String domainName) {
        String userinfoEndpoint = MoPluginConstants.EndPointConstants.OKTA_User_Info_ENDPOINT.getValue();
        userinfoEndpoint = StringUtils.replace(userinfoEndpoint, "##domainName##", domainName);
        return userinfoEndpoint;
    }

    public static String sanitizeText(String text) {
        if (StringUtils.isBlank(text)) {
            return text;
        }
        text = Jsoup.parse(text).text();
        return text;
    }
}

