/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.util;

public final class MoPluginConstants {
    public static final String PACKAGE_NAME = "com.miniorange.rest.auth";

    public static enum OauthTokenType {
        AUTHORIZATION_GRANT("Authorization"),
        CLIENT_CRED_GRANT("Client-Creds"),
        JWT("JWT");

        private String value;

        private OauthTokenType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Status {
        SUCCESS,
        FAILED,
        USER_NOT_FOUND;

    }

    public static enum ApiConstants {
        UNIVERSAL_API_KEYS("miniorange.restauth.UNIVERSAL_API_KEYS");

        private String key;

        private ApiConstants(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static interface ActionStatus {
        public static final String SUCCESS = "success";
        public static final String INPUT = "input";
        public static final String ERROR = "error";
    }

    public static enum EndPointConstants {
        KEYCLOAK_USERINFO_ENDPOINT("##host##/auth/realms/##realm##/protocol/openid-connect/userinfo"),
        AZURE_USERINFO_ENDPOINT("https://graph.microsoft.com/v1.0/me"),
        GITHUB_USERINFO_ENDPOINT("https://api.github.com/user"),
        MEETUP_USERINFO_ENDPOINT("https://api.meetup.com/2/member/self/"),
        SLACK_USERINFO_ENDPOINT("https://slack.com/api/users.identity?token="),
        SALESFORCE_USERINFO_ENDPOINT("https://##domain##/services/oauth2/userinfo"),
        AWS_COGNITO_USERINFO_ENDPOINT("https://##domainName##/oauth2/userInfo"),
        GOOGLE_USER_INFO_ENDPOINT("https://www.googleapis.com/oauth2/v1/userinfo?alt=json&"),
        GITLAB_USER_INFO_ENDPOINT("https://gitlab.com/api/v4/user"),
        DISCORD_USER_INFO_ENDPOINT("https://discordapp.com/api/users/@me"),
        FACEBOOK_USER_INFO_ENDPOINT("https://graph.facebook.com/me/?fields=id,name,email,age_range,first_name,gender,last_name,link&access_token="),
        OKTA_User_Info_ENDPOINT("https://##domainName##/oauth2/default/v1/userinfo");

        private String value;

        private EndPointConstants(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Providers {
        KEYCLOAK("Keycloak"),
        AZURE("Azure AD"),
        AZURE_B2C("Azure B2C"),
        GITHUB("Github"),
        GITHUB_ENTERPRISE("Github Enterprise"),
        MEETUP("Meetup"),
        SLACK("Slack"),
        SALESFORCE("Salesforce"),
        AWS_Cognito("AWS Cognito"),
        GOOGLE("Google"),
        GITLAB("Gitlab"),
        FACEBOOK("Facebook"),
        DISCORD("Discord"),
        OKTA("Okta");

        private String name;

        private Providers(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum SettingsConstants {
        OAUTH_PROVIDER("miniorange.restauth.OAUTH_PROVIDER"),
        KEYCLOAK_HOST("miniorange.restauth.KEYCLOAK_HOST"),
        KEYCLOAK_REALM("miniorange.restauth.KEYCLOAK_REALM"),
        SALESFORCE_DOMAIN("miniorange.restauth.SALESFORCE_DOMAIN"),
        AWS_COGNITO_DOMAIN_NAME("miniorange.restauth.AWS_COGNITO_DOMAIN_NAME"),
        OKTA_DOMAIN_NAME("miniorange.restauth.AWS_COGNITO_DOMAIN_NAME"),
        ENABLE_AUTHENTICATION("miniorange.restauth.ENABLE_AUTHENTICATION"),
        INTROSPECTION_ENDPOINT("miniorange.restauth.INTROSPECTION_ENDPOINT"),
        USERNAME_ATTRIBUTE("miniorange.restauth.USERNAME_ATTRIBUTE"),
        DISABLE_BASIC_AUTHENTICATION("miniorange.restauth.DISABLE_BASIC_AUTHENTICATION"),
        ALLOW_PAT_TOKENS("miniorange.restauth.ALLOW_PAT_TOKENS"),
        DISABLE_JIRA_AUTHENTICATION("miniorange.restauth.DISABLE_JIRA_AUTHENTICATION"),
        API_KEY("miniorange.restauth.API_KEY"),
        API_KEYS("miniorange.restauth.API_KEYS"),
        SALT_MAP("miniorange.restauth.SALT_MAP"),
        SET_MAX_EXPIRY_TIME("miniorange.restauth.SET_MAX_EXPIRY_TIME"),
        MAXIMUM_EXPIRY_COUNT("miniorange.restauth.MAXIMUM_EXPIRY_COUNT"),
        MAXIMUM_EXPIRY_INTERVAL("miniorange.restauth.MAXIMUM_EXPIRY_INTERVALS"),
        SET_MAX_TOKENS("miniorange.restauth.SET_MAX_TOKENS"),
        MAXIMUM_TOKEN_COUNT("miniorange.restauth.MAXIMUM_TOKEN_COUNT"),
        IP_RESTRICTION("miniorange.restauth.IP_RESTRICTIONS"),
        GROUP("miniorange.restauth.GROUP"),
        GROUPS("miniorange.restauth.GROUPS"),
        RESTRICT_GROUP_ENABLED("miniorange.restauth.RESTRICT_GROUP_ENABLED"),
        RESTRICT_TOKEN_GENERATION_GROUP_ENABLED("miniorange.restauth.RESTRICT_TOKEN_GENERATION_GROUP_ENABLED"),
        RESTRICT_TOKEN_GENERATION_GROUPS("miniorange.restauth.RESTRICT_TOKEN_GENERATION_GROUPS"),
        RESTRICT_IP_ENABLED("miniorange.restauth.RESTRICT_IP_ENABLED"),
        ENABLE_BASIC_AUTH("miniorange.restauth.ENABLE_BASIC_AUTH"),
        ENABLE_READ_ONLY_GROUPS("miniorange.restauth.ENABLE_READ_ONLY_GROUPS"),
        READ_ONLY_GROUPS("miniorange.restauth.READ_ONLY_GROUPS"),
        DISABLE_POPUP("miniorange.restauth.DISABLE_POPUP"),
        PUBLIC_APIS("miniorange.restauth.PUBLIC_APIS"),
        BYPASS_APIS("miniorange.restauth.BYPASS_APIS_AUTHENTICATION"),
        AUDIT_LOGS("miniorange.restauth.AUDIT_LOGS"),
        GUEST_COOKIE("mo.confluence-sso.guestcookie"),
        AZURE_TENANT_ID("miniorange.restauth.AZURE_TENANT_ID"),
        PUBLIC_KEY("miniorange.restauth.PUBLIC_KEY"),
        ALLOW_USERS_TO_CREATE_TOKENS("miniorange.restauth.ALLOW_USERS_TO_CREATE_TOKENS"),
        ENABLE_AUDIT_LOGS("miniorange.restauth.ENABLE_AUDIT_LOGS"),
        DISABLE_LICENSE_EXPIRING_WARNING("miniorange.restauth.DISABLE_LICENSE_EXPIRING_WARNING"),
        DISABLE_LICENSE_EXPIRED_WARNING("miniorange.restauth.DISABLE_LICENSE_EXPIRED_WARNING"),
        CLIENT_ID("miniorange.restauth.CLIENT_ID"),
        CLIENT_SECRET("miniorange.restauth.CLIENT_SECRET"),
        SCOPE("miniorange.restauth.SCOPE"),
        STATE("miniorange.restauth.STATE"),
        AUTH_URL("miniorange.restauth.AUTH_URL"),
        TOKEN_URL("miniorange.restauth.TOKEN_URL"),
        ENABLE_DEBUG_LOGS("miniorange.restauth.ENABLE_DEBUG_LOGS"),
        ENABLE_HIDE_SENSITIVE_INFORMATION("miniorange.restauth.HIDE_SENSITIVE_INFORMATION"),
        RESTAPI_PLUGIN_SETTINGS_MIGRATED("miniorange.restauth.PLUGIN_SETTINGS_MIGRATION"),
        AUDIT_LOGS_PLUGIN_SETTINGS_MIGRATION("miniorange.restauth.PLUGIN_SETTINGS_MIGRATION_AUDIT_LOGS"),
        AUDIT_LOGS_HANDLER("miniorange.restauth.AUDIT_LOGS_HANDLER"),
        OAUTH_CONFIG_MIGRATION_HANDLED("miniorange.restauth.OAUTH_CONFIG_MIGRATION_HANDLED"),
        SERVICE_ACCOUNT_USERNAME("miniorange.restauth.SERVICE_ACCOUNT_USERNAME"),
        PAST_DAYS_CONFIGURED("miniorange.restauth.PAST_DAYS_CONFIGURED"),
        NO_OF_ENTRIES_IN_AUDIT_LOGS("miniorange.restauth.NO_OF_ENTRIES_IN_AUDIT_LOGS"),
        VIEW_PAST_AUDIT_LOGS("miniorange.restauth.VIEW_PAST_AUDIT_LOGS"),
        SCHEDULER_STATUS("miniorange.restauth.SCHEDULER_STATUS"),
        MO_VALID_OFFLINE_LICENSE_CONFIGURED("miniorange.restauth.VALID_OFFLINE_LICENSING"),
        MO_CUSTOMER_TOKEN("miniorange.restauth.CUSTOMER_TOKEN"),
        MO_OFFLINE_LICENSE_USER_TIER("miniorange.restauth.USER_TIER"),
        MO_OFFLINE_LICENSE_EXPIRY_DATE("miniorange.restauth.OFFLINE_LICENSE_EXPIRY_DATE"),
        MO_OFFLINE_LICENSE_KEY("miniorange.restauth.OFFLINE_LICENSE_KEY"),
        ENABLE_RATE_LIMITING("miniorange.restauth.ENABLE_RATE_LIMITING"),
        NUMBER_OF_REQUEST("miniorange.restauth.NUMBER_OF_REQUEST"),
        RATE_LIMITING_INTERVAL_COUNT("miniorange.restauth.RATE_LIMITING_INTERVAL_COUNT"),
        RATE_LIMITING_INTERVAL("miniorange.restauth.RATE_LIMITING_INTERVAL"),
        RATE_LIMITING_INTERVAL_IN_SECONDS("miniorange.restauth.RATE_LIMITING_INTERVAL_IN_SECONDS"),
        CLIENT_CRED_PROVIDER_NAME("miniorange.restauth.CLIENTCRED_PROVIDER_NAME"),
        CLIENT_CRED_INTROSPECTION_ENDPOINT("miniorange.restauth.CLIENT_CRED_INTROSPECTION_ENDPOINT"),
        CLIENT_CRED_REDIRECT_URI("miniorange.restauth.CLIENT_CRED_REDIRECT_URI"),
        CLIENT_CRED_CLIENT_ID("miniorange.restauth.CLIENT_CRED_CLIENT_ID"),
        CLIENT_CRED_CLIENT_SECRET("miniorange.restauth.CLIENT_CRED_CLIENT_SECRET"),
        CLIENT_CRED_SCOPE("miniorange.restauth.CLIENT_CRED_SCOPE"),
        CLIENT_CRED_SERVICE_ACC_USERNAME("miniorange.restauth.CLIENT_CRED_SERVICE_ACC_USERNAME"),
        JWT_PROVIDER_NAME("miniorange.restauth.JWT_PROVIDER_NAME"),
        JWT_INTROSPECTION_ENDPOINT("miniorange.restauth.JWT_INTROSPECTION_ENDPOINT"),
        JWT_CLIENT_ID("miniorange.restauth.JWT_CLIENT_ID"),
        JWT_PUBLIC_KEY("miniorange.restauth.JWT_PUBLIC_KEY"),
        JWT_USERNAME("miniorange.restauth.JWT_USERNAME"),
        OAUTH_TOKEN_TYPE("miniorange.restauth.OAUTH_TOKEN_TYPE");

        private String key;

        private SettingsConstants(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

