/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.handler.MoRESTPluginHandler;
import com.miniorange.rest.auth.commons.util.MoHttpUtils;
import com.miniorange.rest.auth.commons.util.MoRESTUtils;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoOAuthUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(MoOAuthUtils.class);
    private MoRESTAuthSettings settings;
    private static MoHttpUtils moHttpUtils;
    private static MoRESTPluginHandler pluginHandler;

    public MoOAuthUtils(MoRESTAuthSettings settings, MoHttpUtils moHttpUtils, MoRESTPluginHandler pluginHandler) {
        this.settings = settings;
        MoOAuthUtils.moHttpUtils = moHttpUtils;
        MoOAuthUtils.pluginHandler = pluginHandler;
    }

    public HashMap<String, Object> toMap(JsonObject object, HashMap<String, Object> map) {
        Set keysItr = object.entrySet();
        for (Map.Entry entry : keysItr) {
            Object valueToPutInMap;
            String key = (String)entry.getKey();
            JsonElement value = object.get(key);
            if (value.isJsonArray()) {
                valueToPutInMap = this.toList(value.getAsJsonArray(), map);
                continue;
            }
            if (value.isJsonObject()) {
                valueToPutInMap = this.toMap(value.getAsJsonObject(), map);
                continue;
            }
            if (value.isJsonNull()) continue;
            valueToPutInMap = value.getAsString();
            map.put(key, valueToPutInMap);
        }
        return map;
    }

    public Map<String, Object> toMap(JsonObject object, Map<String, Object> map) throws JsonParseException {
        Set keysItr = object.entrySet();
        for (Map.Entry entry : keysItr) {
            Object valueToPutInMap;
            String key = (String)entry.getKey();
            JsonElement value = object.get(key);
            if (value.isJsonArray()) {
                valueToPutInMap = this.toList(value.getAsJsonArray(), map);
                continue;
            }
            if (value.isJsonArray()) {
                valueToPutInMap = this.toMap(value.getAsJsonObject(), map);
                continue;
            }
            if (value.isJsonNull()) continue;
            valueToPutInMap = value.getAsString();
            map.put(key, value.getAsString());
        }
        return map;
    }

    public List<Object> toList(JsonArray array, HashMap<String, Object> map) throws JsonParseException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.size(); ++i) {
            JsonElement value;
            Object valueToPutInMap = value = array.get(i);
            if (value.isJsonArray()) {
                valueToPutInMap = this.toList(value.getAsJsonArray(), map);
            } else if (value.isJsonArray()) {
                valueToPutInMap = this.toMap(value.getAsJsonObject(), map);
            }
            list.add(valueToPutInMap);
        }
        return list;
    }

    public List<Object> toList(JsonArray array, Map<String, Object> map) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.size(); ++i) {
            JsonElement value;
            Object valueToPutInMap = value = array.get(i);
            if (value.isJsonArray()) {
                valueToPutInMap = this.toList(value.getAsJsonArray(), map);
            } else if (value.isJsonArray()) {
                valueToPutInMap = this.toMap(value.getAsJsonObject(), map);
            }
            list.add(valueToPutInMap);
        }
        return list;
    }

    public static HashMap<String, String> copyToStringValueMap(HashMap<String, Object> input) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : input.entrySet()) {
            ret.put(entry.getKey(), (String)entry.getValue());
        }
        return ret;
    }

    public static HashMap<String, Object> toMapObjects(JsonObject object, HashMap<String, Object> map) throws JsonParseException {
        Set keysItr = object.entrySet();
        for (Map.Entry entry : keysItr) {
            HashMap<String, Object> valueToPutInMap;
            String key = (String)entry.getKey();
            JsonElement value = object.get(key);
            if (value.isJsonArray()) {
                valueToPutInMap = MoOAuthUtils.toMapList(value.getAsJsonArray(), key);
                map.putAll(valueToPutInMap);
                continue;
            }
            if (value.isJsonObject()) {
                JsonObject obj = value.getAsJsonObject();
                if (obj.isJsonNull()) {
                    map.put(key, null);
                    continue;
                }
                HashMap<String, Object> newMap = new HashMap<String, Object>();
                valueToPutInMap = MoOAuthUtils.mapObjectsWithUpdatedKey(obj, newMap, key);
                map.putAll(valueToPutInMap);
                continue;
            }
            try {
                map.put(key, value.getAsString());
            }
            catch (UnsupportedOperationException e) {
                map.put(key, value.toString());
            }
        }
        return map;
    }

    public static HashMap<String, Object> mapObjectsWithUpdatedKey(JsonObject object, HashMap<String, Object> map, String keyName) throws JsonParseException {
        Set keysItr = object.entrySet();
        for (Map.Entry entry : keysItr) {
            HashMap<String, Object> valueToPutInMap;
            String key = (String)entry.getKey();
            JsonElement value = object.get(key);
            key = keyName + '.' + key;
            if (value.isJsonArray()) {
                valueToPutInMap = MoOAuthUtils.toMapList(value.getAsJsonArray(), key);
                map.putAll(valueToPutInMap);
                continue;
            }
            if (value.isJsonObject()) {
                JsonObject obj = value.getAsJsonObject();
                if (obj.isJsonNull()) {
                    map.put(key, null);
                    continue;
                }
                HashMap<String, Object> newMap = new HashMap<String, Object>();
                valueToPutInMap = MoOAuthUtils.mapObjectsWithUpdatedKey(obj, newMap, key);
                map.putAll(valueToPutInMap);
                continue;
            }
            if (value.isJsonNull()) continue;
            map.put(key, value.getAsString());
        }
        return map;
    }

    public static HashMap<String, Object> toMapList(JsonArray array, String key) throws JsonParseException {
        HashMap<String, Object> completeMap = new HashMap<String, Object>();
        ArrayList<String> list = new ArrayList<String>();
        if (array.size() == 0) {
            completeMap.put(key, null);
        } else {
            for (int i = 0; i < array.size(); ++i) {
                HashMap<String, Object> valueToPutInMap;
                JsonElement value = array.get(i);
                if (value.isJsonArray()) {
                    valueToPutInMap = MoOAuthUtils.toMapList(value.getAsJsonArray(), key + '[' + i + ']');
                    completeMap.putAll(valueToPutInMap);
                    continue;
                }
                if (value.isJsonObject()) {
                    JsonObject obj = value.getAsJsonObject();
                    if (obj.isJsonNull()) {
                        completeMap.put(key + '[' + i + ']', null);
                        continue;
                    }
                    HashMap<String, Object> newMap = new HashMap<String, Object>();
                    valueToPutInMap = MoOAuthUtils.mapObjectsWithUpdatedKey(obj, newMap, key + '[' + i + ']');
                    completeMap.putAll(valueToPutInMap);
                    continue;
                }
                list.add(value.getAsString());
            }
            if (list.size() > 0) {
                String temp = (String)list.get(0);
                for (int i = 1; i < list.size(); ++i) {
                    temp = temp + "," + (String)list.get(i);
                }
                completeMap.put(key, temp);
            }
        }
        return completeMap;
    }

    public String jwtTokenVerification(String authorizationToken) {
        LOGGER.debug("Verifying JWT Token");
        String userInfoResponse = "";
        userInfoResponse = !this.settings.getJwtIntrospectionEndpoint().isEmpty() ? this.validateJwt(authorizationToken) : this.decodeJwtToken(authorizationToken);
        LOGGER.debug("response (username/error) - " + userInfoResponse);
        return userInfoResponse;
    }

    public String clientCredTokenVerification(String authorizationToken, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("client cred token verification initiated...");
        String tokenResponse = moHttpUtils.verifyAccessToken(authorizationToken);
        LOGGER.debug("token response is: " + tokenResponse);
        if (tokenResponse.equals("verificationFailed")) {
            MoHttpUtils.sendError(resp, 401, "Token verification failed");
            return "verificationFailed";
        }
        String clientID = this.getClientIDInResponse(tokenResponse);
        return clientID;
    }

    public static String oauthTokenVerification(String authorizationToken, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String userInfoResponse = moHttpUtils.verifyToken(authorizationToken);
        LOGGER.debug("userinfo response is: {}", (Object)userInfoResponse);
        if (userInfoResponse.equals("verificationFailed")) {
            LOGGER.error("verification failed...");
            MoHttpUtils.sendError(resp, 401, "Token verification failed");
            return null;
        }
        String username = pluginHandler.getUsernameInResponse(userInfoResponse);
        return username;
    }

    public static String deserializePublicKey(String publicKey) {
        LOGGER.debug("Deserializing Public Key");
        String BEGIN_PUBLIC_KEY = "BEGIN PUBLIC KEY";
        String END_PUBLIC_KEY = "END PUBLIC KEY";
        if (StringUtils.isNotBlank(publicKey)) {
            publicKey = StringUtils.remove(publicKey, "\r");
            publicKey = StringUtils.remove(publicKey, "\n");
            publicKey = StringUtils.remove(publicKey, "-");
            publicKey = StringUtils.remove(publicKey, BEGIN_PUBLIC_KEY);
            publicKey = StringUtils.remove(publicKey, END_PUBLIC_KEY);
            publicKey = StringUtils.remove(publicKey, " ");
        }
        return publicKey;
    }

    public String getClientIDInResponse(String tokenResponse) {
        JsonParser parser = new JsonParser();
        JsonObject tokenInfoData = parser.parse(tokenResponse).getAsJsonObject();
        HashMap<String, Object> tokenDetailsMap = new HashMap<String, Object>();
        HashMap<String, String> tokenInfoMap = MoOAuthUtils.copyToStringValueMap(MoOAuthUtils.toMapObjects(tokenInfoData, tokenDetailsMap));
        LOGGER.debug("User Info Map: {}", tokenInfoMap);
        String clientID = tokenInfoMap.get("client_id");
        return clientID;
    }

    public String decodeJwtToken(String authorizationToken) {
        LOGGER.debug("Decoding the jwt token using Public key");
        try {
            String userinfo;
            DecodedJWT jwt = JWT.decode(authorizationToken);
            String algorithm = jwt.getAlgorithm();
            String isValid = "";
            if (authorizationToken != null && StringUtils.isNotEmpty(this.settings.getJwtPublicKey())) {
                isValid = this.verifyTokenSignature(jwt, this.getPublicKeyObjectFromConfiguredKey(this.settings.getJwtPublicKey()), algorithm);
                if (!StringUtils.equals(isValid, "valid")) {
                    LOGGER.error("Signature validation failed. Please check configured public key");
                    return isValid;
                }
                LOGGER.debug("Signature validation successful");
            }
            if ((userinfo = jwt.getClaim(this.settings.getJwtUsername()).asString()) != null) {
                LOGGER.debug("Valid user found - " + userinfo);
                return userinfo;
            }
            LOGGER.debug("Username parameter in response is empty");
            return "invalidToken";
        }
        catch (Exception e) {
            LOGGER.debug("Error occured while validating JWT : " + e);
            return "invalidToken";
        }
    }

    public String validateJwt(String authorizationToken) {
        LOGGER.debug("Validating the JWT token using introspection endpoint");
        authorizationToken = MoRESTUtils.sanitizeText(authorizationToken);
        String introspectionUrl = this.settings.getJwtIntrospectionEndpoint();
        String clientId = this.settings.getJwtClientId();
        String publicKey = this.settings.getJwtPublicKey();
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("token", authorizationToken));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("content-type", "application/x-www-form-urlencoded");
        headers.put("accept", "application/json");
        headers.put("cert", publicKey);
        headers.put("client_id", clientId);
        String encodedClientId = Base64.getEncoder().encodeToString(clientId.getBytes());
        headers.put("Authorization", "Basic " + encodedClientId);
        String response = MoHttpUtils.sendPostRequest(introspectionUrl, parameters, headers);
        try {
            JsonParser parser = new JsonParser();
            JsonObject jsonResponse = parser.parse(response).getAsJsonObject();
            if (jsonResponse.get("active").getAsBoolean()) {
                return jsonResponse.get(this.settings.getJwtUsername()).getAsString();
            }
            LOGGER.debug("Token has been expired.");
            return "expiredToken";
        }
        catch (NullPointerException e) {
            LOGGER.debug("Error while parsing the response: parameter missing in response");
            return "invalidToken";
        }
        catch (Exception e) {
            LOGGER.debug("Unknown exception occurs while validating the response ", (Throwable)e);
            return "invalidToken";
        }
    }

    private String verifyTokenSignature(DecodedJWT JWTToken, PublicKey publicKey, String signatureAlgorithm) {
        try {
            LOGGER.debug("Public Key's Algorithm :  " + publicKey.getAlgorithm());
            LOGGER.debug("Algorithm used to sign JWT : " + signatureAlgorithm);
            Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)publicKey);
            if (StringUtils.equalsIgnoreCase(signatureAlgorithm, "RS512")) {
                algorithm = Algorithm.RSA512((RSAPublicKey)publicKey);
            } else if (StringUtils.equalsIgnoreCase(signatureAlgorithm, "RSA384")) {
                algorithm = Algorithm.RSA384((RSAPublicKey)publicKey);
            }
            JWTVerifier verifier = JWT.require(algorithm).build();
            DecodedJWT verifiedJWT = verifier.verify(JWTToken.getToken());
            LOGGER.debug("Signature Verified");
            return "valid";
        }
        catch (TokenExpiredException e) {
            LOGGER.error("Token has been expired.");
            return "expiredToken";
        }
        catch (JWTVerificationException e) {
            LOGGER.error("Singnature verification failed ", (Throwable)e);
            return "invalidToken";
        }
        catch (Exception e) {
            LOGGER.error("Unknown exception occurs while verifying Singnature ", (Throwable)e);
            return "invalidToken";
        }
    }

    public PublicKey getPublicKeyObjectFromConfiguredKey(String configuredKey) {
        LOGGER.debug("Getting public key object from configured key");
        PublicKey publicKey = null;
        try {
            configuredKey = MoOAuthUtils.deserializePublicKey(configuredKey);
            byte[] publicBytes = org.apache.commons.codec.binary.Base64.decodeBase64((String)configuredKey);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            publicKey = keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            LOGGER.debug("An error occured while generating public key object from configured key ", (Throwable)e);
        }
        return publicKey;
    }
}

