/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.exceptions.MoPluginException;
import com.miniorange.rest.auth.commons.util.MoRESTUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ProxySelector;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoHttpUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(MoHttpUtils.class);
    public static final String CONTENT_TYPE_JSON = "application/json";
    private final MoRESTAuthSettings settings;

    public MoHttpUtils(MoRESTAuthSettings settings) {
        this.settings = settings;
    }

    public String verifyToken(String accessToken) {
        accessToken = MoRESTUtils.sanitizeText(accessToken);
        String introspectionUrl = this.settings.getIntrospectionEndpoint();
        HashMap<String, String> headers = new HashMap<String, String>();
        LOGGER.debug("Oauth provider = " + this.settings.getOAuthProvider());
        if (this.settings.getOAuthProvider().equals("Azure AD") && !this.verifyAzureADTenantID(accessToken).booleanValue()) {
            return "verificationFailed";
        }
        headers.put("Authorization", "Bearer " + accessToken);
        headers.put("content-type", CONTENT_TYPE_JSON);
        headers.put("accept", CONTENT_TYPE_JSON);
        headers.put("Authorization", "Bearer " + accessToken);
        return MoHttpUtils.sendGetRequest(introspectionUrl, null, headers);
    }

    private Boolean verifyAzureADTenantID(String accessToken) {
        LOGGER.debug("verifying azure ad tenant id");
        String configuredTenantID = this.settings.getAzureADTenantID();
        String tokenPayload = accessToken.split("\\.")[1];
        try {
            String decodedTokenPayload = new String(org.apache.commons.codec.binary.Base64.decodeBase64((byte[])tokenPayload.getBytes()), StandardCharsets.UTF_8);
            JsonParser parser = new JsonParser();
            JsonObject payloadJson = (JsonObject)parser.parse(decodedTokenPayload);
            if (payloadJson.get("tid").toString().replace("\"", "").equals(configuredTenantID)) {
                return true;
            }
            LOGGER.error("Invalid Tenant ID found in the token.");
            return false;
        }
        catch (Exception e) {
            LOGGER.debug("Could not find azure tenant id with exception = " + e);
            return false;
        }
    }

    public static String sendGetRequest(String url, Map<String, String> parameter, Map headers) throws MoPluginException {
        try {
            LOGGER.debug("MoHttpUtils sendGetRequest Sending GET request to " + url);
            CloseableHttpClient httpClient = MoHttpUtils.getHttpClient();
            HttpGet getRequest = new HttpGet(url);
            if (headers != null) {
                Iterator iterator = headers.entrySet().iterator();
                if (!headers.isEmpty()) {
                    while (iterator.hasNext()) {
                        Map.Entry pairs = iterator.next();
                        getRequest.setHeader(pairs.getKey().toString(), pairs.getValue().toString());
                    }
                }
            }
            String value = String.valueOf(getRequest.getFirstHeader("Authorization"));
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)getRequest);
            LOGGER.debug("Response for HTTP Request: " + response.toString() + " and Status Code: " + response.getStatusLine().getStatusCode());
            if (response.getStatusLine().getStatusCode() == 200 && response.getEntity() != null) {
                LOGGER.debug("Response Entity found. Reading Response payload.");
                String data = IOUtils.toString((Reader)new InputStreamReader(response.getEntity().getContent()));
                LOGGER.debug("Data Received in Response {}", (Object)data);
                httpClient.close();
                return data;
            }
            httpClient.close();
            throw new MoPluginException(MoPluginException.PluginErrorCode.INVALID_TOKEN, MoPluginException.PluginErrorCode.INVALID_TOKEN.getMessage());
        }
        catch (MoPluginException e) {
            throw new MoPluginException(e.getErrorCode(), e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new MoPluginException(MoPluginException.PluginErrorCode.UNKNOWN, e.getMessage(), e);
        }
    }

    private static CloseableHttpClient getHttpClient() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        HttpClientBuilder builder = HttpClientBuilder.create();
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        }).build();
        SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionFactory);
        Registry registry = RegistryBuilder.create().register("https", (Object)sslConnectionFactory).register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
        BasicHttpClientConnectionManager ccm = new BasicHttpClientConnectionManager((Lookup)registry);
        builder.setConnectionManager((HttpClientConnectionManager)ccm);
        SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        CloseableHttpClient httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).setConnectionManager((HttpClientConnectionManager)ccm).build();
        return httpclient;
    }

    public static Cookie createCookie(String url, String cookieName, String cookieValue, Boolean isHttpOnly) {
        Cookie cookie = new Cookie(cookieName, cookieValue);
        cookie.setPath("/");
        cookie.setSecure(StringUtils.isNotBlank(url) && url.length() > 7 && url.substring(0, 8).equalsIgnoreCase("https://"));
        cookie.setHttpOnly(isHttpOnly.booleanValue());
        return cookie;
    }

    public static String sendPostRequest(String url, List<NameValuePair> data, Map<String, String> headers) {
        try {
            CloseableHttpClient httpClient = MoHttpUtils.getHttpClient();
            HttpPost postRequest = new HttpPost(url);
            if (headers != null) {
                Iterator<Map.Entry<String, String>> iterator = headers.entrySet().iterator();
                if (!headers.isEmpty()) {
                    while (iterator.hasNext()) {
                        Map.Entry<String, String> pairs = iterator.next();
                        postRequest.setHeader(pairs.getKey().toString(), pairs.getValue().toString());
                    }
                }
            }
            postRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(data));
            LOGGER.debug("POST Authn Request : " + postRequest.toString());
            return MoHttpUtils.executePostRequest(httpClient, postRequest);
        }
        catch (Exception e) {
            return "Failed";
        }
    }

    public static String executePostRequest(CloseableHttpClient httpClient, HttpPost postRequest) {
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)postRequest);
            LOGGER.debug("Response Code : " + response.getStatusLine().getStatusCode());
            if (response.getEntity() != null) {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                String status = "";
                while ((output = br.readLine()) != null) {
                    status = status + output;
                }
                LOGGER.debug("status : " + status);
                httpClient.close();
                return status;
            }
            httpClient.close();
            return "";
        }
        catch (Exception e) {
            return "Failed";
        }
    }

    public static URI getUri(HttpServletRequest req) {
        StringBuffer sb = req.getRequestURL();
        if (req.getQueryString() != null) {
            sb.append("?");
            sb.append(req.getQueryString());
        }
        return URI.create(sb.toString());
    }

    public static void sendError(HttpServletResponse response, int errorCode, String errorMessage) throws IOException {
        JsonObject json = new JsonObject();
        JsonObject error = new JsonObject();
        error.addProperty("status", "ERROR");
        error.addProperty("message", errorMessage);
        json.add("error", (JsonElement)error);
        response.setContentType(CONTENT_TYPE_JSON);
        response.setStatus(errorCode);
        response.getOutputStream().write(json.toString().getBytes());
        response.getOutputStream().close();
    }

    public static void sendResponse(HttpServletResponse response, JsonObject data) throws IOException {
        response.setStatus(200);
        response.setContentType(CONTENT_TYPE_JSON);
        response.getOutputStream().write(data.toString().getBytes());
        response.getOutputStream().close();
    }

    public static void sendResponse(HttpServletResponse response, String data) throws IOException {
        response.setStatus(200);
        response.setContentType(CONTENT_TYPE_JSON);
        response.getOutputStream().write(data.getBytes());
        response.getOutputStream().close();
    }

    public String screenAuthorizationToken(String token) {
        if (token == null || token.equals("")) {
            return "";
        }
        if (token.length() <= 4) {
            token.replaceAll(".", "*");
            return token;
        }
        StringBuilder sb = new StringBuilder(token);
        int start = 2;
        int end = sb.length() - 2;
        int maskLength = end - start;
        if (maskLength == 0) {
            token.replaceAll(".", "*");
            return token;
        }
        StringBuilder maskString = new StringBuilder(maskLength);
        for (int i = 0; i < maskLength; ++i) {
            maskString.append("*");
        }
        return token.substring(0, start) + maskString.toString() + token.substring(start + maskLength);
    }

    public Boolean bypassApiUrls(ServletRequest request) {
        Map<String, String> bypassApiUrls = this.settings.getBypassApiUrls();
        HttpServletRequest req = (HttpServletRequest)request;
        String requestURI = req.getRequestURI();
        boolean bypassUrlFound = false;
        if (bypassApiUrls != null) {
            for (String bypassApiUrl : bypassApiUrls.values()) {
                if (!requestURI.contains(bypassApiUrl = bypassApiUrl.trim())) continue;
                LOGGER.debug("The url is configured for bypassed , so skipping authentication");
                bypassUrlFound = true;
                break;
            }
        }
        return bypassUrlFound;
    }

    public String verifyAccessToken(String accessToken) {
        accessToken = MoRESTUtils.sanitizeText(accessToken);
        String ClientID = this.settings.getClientCredClientId();
        String temp = this.settings.getClientCredClientId() + ":" + this.settings.getClientCredClientSecret();
        String token = Base64.getEncoder().encodeToString(temp.getBytes());
        String introspectionUrl = this.settings.getClientCredIntrospectionEndpoint();
        ArrayList<NameValuePair> postParameters = new ArrayList<NameValuePair>();
        HashMap<String, String> headers = new HashMap<String, String>();
        LOGGER.debug("Oauth provider = " + this.settings.getOAuthProvider());
        headers.put("content-type", "application/x-www-form-urlencoded");
        headers.put("token_type_hint", "access");
        headers.put("client_id", "" + ClientID);
        headers.put("Authorization", "Basic " + token);
        postParameters.add((NameValuePair)new BasicNameValuePair("token", accessToken));
        String response = MoHttpUtils.sendPostRequest(introspectionUrl, postParameters, headers);
        return response;
    }
}

