/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.util;

import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoHashUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoHashUtils.class);

    public static String hash(String text, byte[] salt) {
        byte[] hash = null;
        try {
            PBEKeySpec spec = new PBEKeySpec(text.toCharArray(), salt, 65536, 128);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            hash = factory.generateSecret(spec).getEncoded();
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            LOGGER.error("An error occurred while generating the hash ", (Throwable)e);
        }
        return new String(hash, StandardCharsets.UTF_8);
    }

    public static String createSalt() {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[16];
        random.nextBytes(salt);
        return new String(salt, StandardCharsets.UTF_8);
    }
}

