/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.mail.Email;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.miniorange.rest.auth.commons.util.PlatformUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraUtils
implements PlatformUtils {
    public static Logger LOGGER = LoggerFactory.getLogger(JiraUtils.class);
    private WebSudoManager webSudoManager;
    private UserUtils userUtils;
    private JiraHome jiraHome = (JiraHome)ComponentAccessor.getComponent(JiraHome.class);

    public JiraUtils() {
    }

    public JiraUtils(WebSudoManager webSudoManager, UserUtils userUtils) {
        this.webSudoManager = webSudoManager;
        this.userUtils = userUtils;
    }

    @Override
    public String getBaseUrl() {
        return ComponentAccessor.getApplicationProperties().getString("jira.baseurl");
    }

    @Override
    public void enforceWebsudo(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.webSudoManager.willExecuteWebSudoRequest(request);
        }
        catch (WebSudoSessionException w) {
            LOGGER.debug("Enforcing Websudo Protection");
        }
    }

    @Override
    public void sendAPIKeyByEmail(String apiKey, String username) {
        try {
            ApplicationUser user = UserUtils.getUser((String)username);
            LOGGER.debug("user email = " + user);
            String userEmail = user.getEmailAddress();
            String subject = "API Key for your JIRA REST APIs";
            String message = apiKey + " is your API Key for JIRA";
            Email email = new Email(userEmail);
            email.setSubject(subject);
            email.setBody(message);
            email.setMimeType("text/html");
            SingleMailQueueItem mailItem = new SingleMailQueueItem(email);
            ComponentAccessor.getMailQueue().addItem((MailQueueItem)mailItem);
        }
        catch (Exception e) {
            LOGGER.debug("Cound not send the mail with exception = " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void downloadDebugLogs(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            File folder = this.jiraHome.getLogDirectory();
            File jiraLogFile = null;
            for (File f : folder.listFiles()) {
                if (!f.isFile() || !StringUtils.equals(f.getName(), "atlassian-jira.log")) continue;
                jiraLogFile = f;
                break;
            }
            resp.setHeader("Content-Disposition", "attachment; filename=\"atlassian-jira.log\"");
            resp.setHeader("Cache-Control", "max-age=0");
            resp.setHeader("Pragma", "");
            resp.setContentType("text/plain");
            FileUtils.copyFile((File)jiraLogFile.getAbsoluteFile(), (OutputStream)resp.getOutputStream());
        }
        catch (Exception e) {
            LOGGER.debug("exception occurred while downloading the file = " + e);
        }
    }
}

