/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.util;

import com.atlassian.confluence.security.websudo.WebSudoManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.mail.Email;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.atlassian.spring.container.ContainerManager;
import com.miniorange.rest.auth.commons.util.PlatformUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceUtils
implements PlatformUtils {
    public static Logger LOGGER = LoggerFactory.getLogger(ConfluenceUtils.class);
    private WebSudoManager webSudoManager;
    private UserAccessor userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
    private MultiQueueTaskManager taskManager = (MultiQueueTaskManager)ContainerManager.getComponent((String)"taskManager");
    private BootstrapManager bootstrapManager = (BootstrapManager)ContainerManager.getComponent((String)"bootstrapManager");

    public ConfluenceUtils() {
    }

    public ConfluenceUtils(WebSudoManager webSudoManager, MultiQueueTaskManager taskManager) {
        this.webSudoManager = webSudoManager;
    }

    @Override
    public String getBaseUrl() {
        SettingsManager settingsManager = (SettingsManager)ContainerManager.getComponent((String)"settingsManager");
        return settingsManager.getGlobalSettings().getBaseUrl();
    }

    @Override
    public void sendAPIKeyByEmail(String apiKey, String username) {
        try {
            ConfluenceUserImpl user = (ConfluenceUserImpl)this.userAccessor.getUserByName(username);
            String userEmail = user.getEmail();
            LOGGER.debug("user email = " + userEmail);
            String subject = "API Key for your Confluence REST APIs";
            String message = apiKey + " is your API Key for Confluence";
            Email email = new Email(userEmail).setSubject(subject).setBody(message);
            SingleMailQueueItem mailQueueItem = new SingleMailQueueItem(email);
            this.taskManager.addTask("mail", () -> ((SingleMailQueueItem)mailQueueItem).send());
            LOGGER.debug("Mail sent successfully");
        }
        catch (Exception e) {
            LOGGER.debug("Could not send the email with exception : " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void downloadDebugLogs(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("inside debug logs confluence utils");
        try {
            File dataFolder = this.bootstrapManager.getLocalHome();
            File logsFolder = null;
            File confluenceLogFile = null;
            for (File f : dataFolder.listFiles()) {
                if (!f.isDirectory() || !StringUtils.equals(f.getName(), "logs")) continue;
                logsFolder = f;
                break;
            }
            for (File f : logsFolder.listFiles()) {
                if (!f.isFile() || !StringUtils.equals(f.getName(), "atlassian-confluence.log")) continue;
                confluenceLogFile = f;
                break;
            }
            resp.setHeader("Content-Disposition", "attachment; filename=\"atlassian-confluence.log\"");
            resp.setHeader("Cache-Control", "max-age=0");
            resp.setHeader("Pragma", "");
            resp.setContentType("text/plain");
            FileUtils.copyFile((File)confluenceLogFile, (OutputStream)resp.getOutputStream());
        }
        catch (Exception e) {
            LOGGER.debug("Exception Occured in Confluence Uitls" + e);
        }
    }

    @Override
    public void enforceWebsudo(HttpServletRequest request, HttpServletResponse response) {
    }
}

