/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.servlet;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.handler.MoOfflineLicenseHandler;
import com.miniorange.rest.auth.commons.handler.MoRESTPluginHandler;
import com.miniorange.rest.auth.commons.util.MoHttpUtils;
import com.miniorange.rest.auth.commons.util.MoRESTUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoUserRestriction
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoUserRestriction.class);
    private final TemplateRenderer templateRenderer;
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final WebSudoManager webSudoManager;
    private final MoRESTPluginHandler restPluginHandler;
    private MoOfflineLicenseHandler moOfflineLicenseHandler;
    private final I18nResolver i18nResolver;
    private final MoRESTAuthSettings settings;

    public MoUserRestriction(TemplateRenderer templateRenderer, UserManager userManager, LoginUriProvider loginUriProvider, WebSudoManager webSudoManager, MoRESTPluginHandler restPluginHandler, MoOfflineLicenseHandler moOfflineLicenseHandler, I18nResolver i18nResolver, MoRESTAuthSettings settings) {
        this.templateRenderer = templateRenderer;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.webSudoManager = webSudoManager;
        this.restPluginHandler = restPluginHandler;
        this.moOfflineLicenseHandler = moOfflineLicenseHandler;
        this.i18nResolver = i18nResolver;
        this.settings = settings;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null || !this.isAdministrator()) {
            this.redirectToLogin(req, resp);
            return;
        }
        try {
            this.webSudoManager.willExecuteWebSudoRequest(req);
        }
        catch (WebSudoSessionException e) {
            LOGGER.debug("admin session expired. Redirecting for websudo protection");
            this.webSudoManager.enforceWebSudoProtection(req, resp);
            return;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("req", req);
        context.put("restrictGroupEnabled", this.settings.getRestrictGroupEnabled());
        context.put("group", this.settings.getGroup());
        ArrayList groupList = (ArrayList)this.settings.getGroups();
        context.put("groups", groupList);
        context.put("groupList", groupList);
        context.put("readOnlyGroupsEnabled", this.settings.getReadOnlyGroupsEnabled());
        ArrayList readOnlyGroupsList = (ArrayList)this.settings.getReadOnlyGroups();
        context.put("readOnlyGroups", readOnlyGroupsList);
        context.put("readOnlyGroupsList", readOnlyGroupsList);
        context.put("restrictTokenGenerationGroupEnabled", this.settings.getRestrictTokenGenerationGroupEnabled());
        ArrayList restrictTokenGenerationGroupsList = (ArrayList)this.settings.getRestrictTokenGenerationGroups();
        context.put("restrictTokenGenerationGroupsList", restrictTokenGenerationGroupsList);
        context.put("oauthType", this.settings.getOauthTokenType());
        context.put("isDatacenter", this.settings.isDatacenter());
        resp.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("vm/userrestriction.vm", context, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null || !this.isAdministrator()) {
            MoHttpUtils.sendError(resp, 403, this.i18nResolver.getText("restauth.error.forbidden"));
        }
        Boolean restrictGroupEnabled = BooleanUtils.toBoolean(req.getParameter("restrictGroupEnabled"));
        Boolean readOnlyGroupsEnabled = BooleanUtils.toBoolean(req.getParameter("readOnlyGroupsEnabled"));
        Boolean restrictTokenGenerationGroupEnabled = BooleanUtils.toBoolean(req.getParameter("restrictTokenGenerationGroupEnabled"));
        String group = req.getParameter("group");
        String groups = req.getParameter("groups");
        String readOnlyGroups = req.getParameter("readOnlyGroups");
        String restrictTokenGenerationGroups = req.getParameter("restrictTokenGenerationGroups");
        ArrayList<String> groupList = new ArrayList<String>();
        ArrayList<String> readOnlyGroupsList = new ArrayList();
        ArrayList<String> restrictTokenGenerationGroupsList = new ArrayList();
        if (restrictGroupEnabled.booleanValue() && groups.isEmpty()) {
            MoHttpUtils.sendError(resp, 400, "Select Groups to Allow Access to API");
            return;
        }
        groupList.add(this.settings.getGroup());
        LOGGER.debug("Groups : " + groups);
        groupList = this.settings.convertSelect2StringToList(groups);
        if (readOnlyGroupsEnabled.booleanValue() && readOnlyGroups.isEmpty()) {
            MoHttpUtils.sendError(resp, 400, "Select Groups to Enable Read-only Access");
            return;
        }
        readOnlyGroupsList = this.settings.convertSelect2StringToList(readOnlyGroups);
        if (restrictTokenGenerationGroupEnabled.booleanValue() && restrictTokenGenerationGroups.isEmpty()) {
            MoHttpUtils.sendError(resp, 400, "Select Groups to Allow Token Generation");
            return;
        }
        restrictTokenGenerationGroupsList = this.settings.convertSelect2StringToList(restrictTokenGenerationGroups);
        this.restPluginHandler.saveUserRestrictionSettings(restrictGroupEnabled, readOnlyGroupsEnabled, group, groupList, readOnlyGroupsList, restrictTokenGenerationGroupEnabled, restrictTokenGenerationGroupsList);
    }

    private boolean isAdministrator() {
        UserProfile userProfile = this.userManager.getRemoteUser();
        return this.userManager.isAdmin(userProfile.getUserKey());
    }

    private void redirectToLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String LoginUri = MoRESTUtils.sanitizeText(this.loginUriProvider.getLoginUri(MoHttpUtils.getUri(req)).toASCIIString());
        resp.sendRedirect(LoginUri);
    }
}

