/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.servlet;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.gson.JsonObject;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.handler.MoRESTPluginHandler;
import com.miniorange.rest.auth.commons.util.MoHttpUtils;
import com.miniorange.rest.auth.commons.util.MoRESTUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoTokenSettings
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoTokenSettings.class);
    private final TemplateRenderer templateRenderer;
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final WebSudoManager webSudoManager;
    private final MoRESTPluginHandler restPluginHandler;
    private final I18nResolver i18nResolver;
    private final MoRESTAuthSettings settings;

    public MoTokenSettings(TemplateRenderer templateRenderer, UserManager userManager, LoginUriProvider loginUriProvider, WebSudoManager webSudoManager, MoRESTPluginHandler restPluginHandler, I18nResolver i18nResolver, MoRESTAuthSettings settings) {
        this.templateRenderer = templateRenderer;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.webSudoManager = webSudoManager;
        this.restPluginHandler = restPluginHandler;
        this.i18nResolver = i18nResolver;
        this.settings = settings;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null || !this.isAdministrator()) {
            this.redirectToLogin(req, resp);
            return;
        }
        try {
            this.webSudoManager.willExecuteWebSudoRequest(req);
        }
        catch (WebSudoSessionException e) {
            LOGGER.debug("admin session expired. Redirecting for websudo protection");
            this.webSudoManager.enforceWebSudoProtection(req, resp);
            return;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("req", req);
        context.put("isAdmin", this.isAdministrator());
        context.put("setMaxExpiryTime", this.settings.getMaxExpiryTime());
        context.put("maximumExpiryCount", this.settings.getMaximumExpiryCount());
        context.put("platform", this.i18nResolver.getText("my.plugin.platform"));
        context.put("maximumExpiryInterval", this.settings.getMaximumExpiryInterval());
        context.put("setMaxTokens", this.settings.getMaxToken());
        context.put("maximumTokenCount", this.settings.getMaximumTokenCount());
        context.put("oauthType", this.settings.getOauthTokenType());
        resp.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("vm/tokensettings.vm", context, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean manageAPIKeyExpirySubmitted;
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null) {
            this.redirectToLogin(req, resp);
            return;
        }
        String maxExpiryTime = StringUtils.defaultIfBlank(req.getParameter("maximum-expiry-count"), "1");
        if (maxExpiryTime.isEmpty() || Integer.parseInt(maxExpiryTime) <= 0) {
            MoHttpUtils.sendError(resp, 400, "Invalid expiry count");
        }
        if (manageAPIKeyExpirySubmitted = BooleanUtils.toBoolean(req.getParameter("manage-api-keys-expiry-form-submitted"))) {
            this.saveMaxAPIKeyExpiry(req, resp);
        }
        boolean manageAPIKeyMaxTokensSubmitted = BooleanUtils.toBoolean(req.getParameter("manage-api-keys-max-tokens-form-submitted"));
        LOGGER.debug("Maximum Token form : " + req.getParameter("manage-api-keys-max-tokens-form-submitted"));
        if (manageAPIKeyMaxTokensSubmitted) {
            this.saveMaxTokensPerUser(req, resp);
        }
        JsonObject response = this.createResponse();
        MoHttpUtils.sendResponse(resp, response);
    }

    private void saveMaxAPIKeyExpiry(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean setMaxExpiryTime = BooleanUtils.toBoolean(req.getParameter("set-max-expiry"));
        String maximumExpiryCount = req.getParameter("maximum-expiry-count");
        String maximumExpiryInterval = req.getParameter("maximum-expiry-interval");
        this.restPluginHandler.saveMaxExpiry(setMaxExpiryTime, maximumExpiryCount, maximumExpiryInterval);
    }

    private void saveMaxTokensPerUser(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean setMaxToken = BooleanUtils.toBoolean(req.getParameter("set-max-tokens"));
        String maximumTokenCount = req.getParameter("maximum-token-count");
        this.restPluginHandler.saveMaxTokensPerUser(setMaxToken, maximumTokenCount);
        LOGGER.debug("Setting :" + req.getParameter("set-max-tokens") + req.getParameter("maximum-token-count"));
    }

    private JsonObject createResponse() {
        JsonObject data = new JsonObject();
        data.addProperty("Success", "API Key Settings Saved Successfully");
        return data;
    }

    private boolean isAdministrator() {
        UserProfile userProfile = this.userManager.getRemoteUser();
        return this.userManager.isAdmin(userProfile.getUserKey());
    }

    private void redirectToLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String LoginUri = MoRESTUtils.sanitizeText(this.loginUriProvider.getLoginUri(MoHttpUtils.getUri(req)).toASCIIString());
        resp.sendRedirect(LoginUri);
    }
}

