/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.servlet;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.util.MoHttpUtils;
import com.miniorange.rest.auth.commons.util.MoRESTUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MoShowAPITokensInstructionsServlet
extends HttpServlet {
    private final TemplateRenderer templateRenderer;
    private final MoRESTAuthSettings settings;
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;

    public MoShowAPITokensInstructionsServlet(TemplateRenderer templateRenderer, MoRESTAuthSettings settings, UserManager userManager, LoginUriProvider loginUriProvider) {
        this.templateRenderer = templateRenderer;
        this.settings = settings;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null) {
            this.redirectToLogin(req, resp);
            return;
        }
        Boolean isAdmin = this.userManager.isAdmin(user.getUserKey());
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("req", req);
        context.put("isAdmin", isAdmin);
        context.put("settings", this.settings);
        resp.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("vm/apitokensinstructions.vm", context, (Writer)resp.getWriter());
    }

    private void redirectToLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String LoginUri = MoRESTUtils.sanitizeText(this.loginUriProvider.getLoginUri(MoHttpUtils.getUri(req)).toASCIIString());
        resp.sendRedirect(LoginUri);
    }
}

