/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.servlet;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.handler.MoOfflineLicenseHandler;
import com.miniorange.rest.auth.commons.handler.MoRESTPluginHandler;
import com.miniorange.rest.auth.commons.util.MoHttpUtils;
import com.miniorange.rest.auth.commons.util.MoRESTUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoRestrictPublicAPIs
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoRestrictPublicAPIs.class);
    private final TemplateRenderer templateRenderer;
    private final WebSudoManager webSudoManager;
    private final LoginUriProvider loginUriProvider;
    private final UserManager userManager;
    private final MoRESTPluginHandler restPluginHandler;
    private final I18nResolver i18nResolver;
    private final MoRESTAuthSettings settings;
    private MoOfflineLicenseHandler moOfflineLicenseHandler;

    public MoRestrictPublicAPIs(TemplateRenderer templateRenderer, WebSudoManager webSudoManager, MoRESTPluginHandler restPluginHandler, I18nResolver i18nResolver, MoRESTAuthSettings settings, UserManager userManager, LoginUriProvider loginUriProvider, MoOfflineLicenseHandler moOfflineLicenseHandler) {
        this.templateRenderer = templateRenderer;
        this.webSudoManager = webSudoManager;
        this.restPluginHandler = restPluginHandler;
        this.i18nResolver = i18nResolver;
        this.settings = settings;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.moOfflineLicenseHandler = moOfflineLicenseHandler;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("RestrictPublicApis doGet called");
        String platform = this.i18nResolver.getText("my.plugin.platform");
        LOGGER.debug("platform = " + platform);
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("req", request);
        List<String> apiUrls = this.settings.getPublicApiUrlsAsList();
        context.put("apiUrls", apiUrls);
        context.put("platform", platform);
        context.put("oauthType", this.settings.getOauthTokenType());
        context.put("isDatacenter", this.settings.isDatacenter());
        this.templateRenderer.render("vm/restrictpublicapis.vm", context, (Writer)response.getWriter());
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("RestrictPublicApis doPost called");
        String apiUrl = StringUtils.defaultIfBlank(request.getParameter("apiUrl"), "");
        apiUrl = apiUrl.trim();
        LOGGER.debug("apiURl = " + apiUrl);
        if (apiUrl.isEmpty()) {
            LOGGER.debug("No apiUrl is entered");
            MoHttpUtils.sendError(response, 400, "No apiUrl is entered");
            return;
        }
        if (apiUrl.equals("rest") || apiUrl.equals("/rest") || apiUrl.equals("rest/") || apiUrl.equals("/rest/") || apiUrl.equals("/")) {
            LOGGER.error("Entered URI is forbidden");
            MoHttpUtils.sendError(response, 400, "Entered URI is forbidden");
            return;
        }
        Map<String, String> bypassApiUrls = this.settings.getBypassApiUrls();
        if (bypassApiUrls != null && bypassApiUrls.containsValue(apiUrl)) {
            LOGGER.debug("the url is already configured in bypass  urls");
            MoHttpUtils.sendError(response, 400, "Url is already configured in bypass url section");
            return;
        }
        this.settings.setPublicApiUrls(apiUrl);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("RestrictPublicApis doDelete called");
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null) {
            this.redirectToLogin(request, response);
            return;
        }
        String apiUrlId = request.getParameter("id");
        if (StringUtils.isBlank(apiUrlId)) {
            MoHttpUtils.sendError(response, 400, this.i18nResolver.getText("restauth.error.apiUrl.id.empty"));
            return;
        }
        if (!this.isAdministrator()) {
            MoHttpUtils.sendError(response, 403, this.i18nResolver.getText("restauth.error.apikey.id.no.delete.permission"));
            return;
        }
        this.restPluginHandler.deleteApiUrl(apiUrlId);
    }

    private void redirectToLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String LoginUri = MoRESTUtils.sanitizeText(this.loginUriProvider.getLoginUri(MoHttpUtils.getUri(req)).toASCIIString());
        resp.sendRedirect(LoginUri);
    }

    private boolean isAdministrator() {
        UserProfile userProfile = this.userManager.getRemoteUser();
        return this.userManager.isAdmin(userProfile.getUserKey());
    }
}

