/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.servlet;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.handler.MoRESTPluginHandler;
import com.miniorange.rest.auth.commons.handler.UtilDecisionHandler;
import com.miniorange.rest.auth.commons.util.PlatformUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoRestTroubleshootServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoRestTroubleshootServlet.class);
    private MoRESTAuthSettings settings;
    private MoRESTPluginHandler restPluginHandler;
    private TemplateRenderer templateRenderer;
    private final I18nResolver i18nResolver;

    MoRestTroubleshootServlet(MoRESTAuthSettings settings, MoRESTPluginHandler restPluginHandler, TemplateRenderer templateRenderer, I18nResolver i18nResolver) {
        this.settings = settings;
        this.restPluginHandler = restPluginHandler;
        this.templateRenderer = templateRenderer;
        this.i18nResolver = i18nResolver;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String action;
        switch (action = req.getParameter("action")) {
            case "downloadLogs": {
                this.downloadLogs(req, resp);
                break;
            }
            default: {
                resp.setContentType("application/json");
                LOGGER.error(" 405.The requested action is not allowed. Choose valid Action");
                resp.sendError(405, "The requested action is not allowed. Choose valid Action");
                return;
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        Boolean enableDebugLogs = BooleanUtils.toBoolean(req.getParameter("rest-api-enable-debug-logs"));
        this.restPluginHandler.saveTroubleShootSettings(enableDebugLogs);
    }

    private void downloadLogs(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("Download Logs Called");
        String platform = this.i18nResolver.getText("my.plugin.platform");
        PlatformUtils platformUtils = UtilDecisionHandler.getPlatFormUtils(platform);
        platformUtils.downloadDebugLogs(req, resp);
    }
}

