/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.servlet;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.gson.JsonObject;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.handler.MoRESTPluginHandler;
import com.miniorange.rest.auth.commons.util.MoHttpUtils;
import com.miniorange.rest.auth.commons.util.MoRESTUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoRateLimiting
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoRateLimiting.class);
    private final TemplateRenderer templateRenderer;
    private final MoRESTPluginHandler restPluginHandler;
    private final LoginUriProvider loginUriProvider;
    private final UserManager userManager;
    private final WebSudoManager webSudoManager;
    private final MoRESTAuthSettings settings;

    public MoRateLimiting(TemplateRenderer templateRenderer, MoRESTPluginHandler restPluginHandler, UserManager userManager, LoginUriProvider loginUriProvider, WebSudoManager webSudoManager, MoRESTAuthSettings settings) {
        this.templateRenderer = templateRenderer;
        this.restPluginHandler = restPluginHandler;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.webSudoManager = webSudoManager;
        this.settings = settings;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null || !this.isAdministrator()) {
            this.redirectToLogin(req, resp);
            return;
        }
        try {
            this.webSudoManager.willExecuteWebSudoRequest(req);
        }
        catch (WebSudoSessionException e) {
            LOGGER.debug("admin session expired. Redirecting for websudo protection");
            this.webSudoManager.enforceWebSudoProtection(req, resp);
            return;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("req", req);
        context.put("enableRateLimiting", this.settings.getEnableRateLimiting());
        context.put("numberOfRequest", this.settings.getNumberOfRequest());
        context.put("rateLimitingIntervalCount", this.settings.getRateLimitingIntervalCount());
        context.put("rateLimitingInterval", this.settings.getRateLimitingInterval());
        context.put("isDatacenter", this.settings.isDatacenter());
        this.templateRenderer.render("vm/ratelimiting.vm", context, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null || !this.isAdministrator()) {
            this.redirectToLogin(req, resp);
            return;
        }
        this.saveRateLimitingSettings(req, resp);
        JsonObject response = new JsonObject();
        response.addProperty("Success", "Rate Limiting Settings Saved Successfully");
        MoHttpUtils.sendResponse(resp, response);
    }

    private void saveRateLimitingSettings(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean enableRateLimiting = BooleanUtils.toBoolean(req.getParameter("enable-rate-limiting"));
        String numberOfRequests = req.getParameter("max-request-count");
        String intervalCount = req.getParameter("interval-count");
        String interval = req.getParameter("maximum-interval");
        this.restPluginHandler.saveRateLimiting(enableRateLimiting, numberOfRequests, intervalCount, interval);
        LOGGER.debug("Rate Limiting Settings saved successfully.");
    }

    private boolean isAdministrator() {
        UserProfile userProfile = this.userManager.getRemoteUser();
        return this.userManager.isAdmin(userProfile.getUserKey());
    }

    private void redirectToLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String LoginUri = MoRESTUtils.sanitizeText(this.loginUriProvider.getLoginUri(MoHttpUtils.getUri(req)).toASCIIString());
        resp.sendRedirect(LoginUri);
    }
}

