/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.servlet;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.servlet.MoAuthTypeServlet;
import com.miniorange.rest.auth.commons.util.MoHttpUtils;
import com.miniorange.rest.auth.commons.util.MoPluginConstants;
import com.miniorange.rest.auth.commons.util.MoRESTUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoOAuthTypeServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoAuthTypeServlet.class);
    private final TemplateRenderer templateRenderer;
    private final MoRESTAuthSettings settings;
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final I18nResolver i18nResolver;

    public MoOAuthTypeServlet(TemplateRenderer templateRenderer, MoRESTAuthSettings settings, UserManager userManager, LoginUriProvider loginUriProvider, I18nResolver i18nResolver) {
        this.templateRenderer = templateRenderer;
        this.settings = settings;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.i18nResolver = i18nResolver;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOGGER.debug("inside doGET");
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null || !this.isAdministrator()) {
            this.redirectToLogin(req, resp);
            return;
        }
        Boolean isAdmin = this.userManager.isAdmin(user.getUserKey());
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("req", req);
        context.put("isAdmin", isAdmin);
        context.put("settings", this.settings);
        context.put("oauthType", this.settings.getOauthTokenType());
        context.put("platform", this.i18nResolver.getText("my.plugin.platform"));
        resp.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("vm/oauthHome.vm", context, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String type;
        switch (type = req.getParameter("currentSelection")) {
            case "Authorization": {
                this.settings.setOauthTokenType(MoPluginConstants.OauthTokenType.AUTHORIZATION_GRANT.getValue());
                break;
            }
            case "Client-Creds": {
                this.settings.setOauthTokenType(MoPluginConstants.OauthTokenType.CLIENT_CRED_GRANT.getValue());
                break;
            }
            case "JWT": {
                this.settings.setOauthTokenType(MoPluginConstants.OauthTokenType.JWT.getValue());
                break;
            }
        }
    }

    private boolean isAdministrator() {
        UserProfile userProfile = this.userManager.getRemoteUser();
        return this.userManager.isAdmin(userProfile.getUserKey());
    }

    private void redirectToLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String LoginUri = MoRESTUtils.sanitizeText(this.loginUriProvider.getLoginUri(MoHttpUtils.getUri(req)).toASCIIString());
        resp.sendRedirect(LoginUri);
    }
}

