/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.servlet;

import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.gson.JsonObject;
import com.miniorange.rest.auth.commons.MoApiKeysService;
import com.miniorange.rest.auth.commons.MoUserDataService;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.dto.ApiKey;
import com.miniorange.rest.auth.commons.entity.MoApiKeysEntity;
import com.miniorange.rest.auth.commons.entity.MoUserdataEntity;
import com.miniorange.rest.auth.commons.handler.MoOfflineLicenseHandler;
import com.miniorange.rest.auth.commons.handler.MoRESTPluginHandler;
import com.miniorange.rest.auth.commons.util.MoHttpUtils;
import com.miniorange.rest.auth.commons.util.MoPluginConstants;
import com.miniorange.rest.auth.commons.util.MoRESTUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoManageAPITokens
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoManageAPITokens.class);
    private MoOfflineLicenseHandler moOfflineLicenseHandler;
    private final TemplateRenderer templateRenderer;
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final WebSudoManager webSudoManager;
    private final MoRESTPluginHandler restPluginHandler;
    private final I18nResolver i18nResolver;
    private final MoRESTAuthSettings settings;
    private final MoApiKeysService apiKeysService;
    private final MoUserDataService userDataService;
    private MoApiKeysEntity moApiKeysEntity;
    private MoUserdataEntity moUserdataEntity;
    private MoApiKeysEntity[] moApiKeysEntities;

    public MoManageAPITokens(MoOfflineLicenseHandler moOfflineLicenseHandler, TemplateRenderer templateRenderer, UserManager userManager, LoginUriProvider loginUriProvider, WebSudoManager webSudoManager, MoRESTPluginHandler restPluginHandler, I18nResolver i18nResolver, MoRESTAuthSettings settings, MoUserDataService userDataService, MoApiKeysService moApiKeysService) {
        this.moOfflineLicenseHandler = moOfflineLicenseHandler;
        this.templateRenderer = templateRenderer;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.webSudoManager = webSudoManager;
        this.restPluginHandler = restPluginHandler;
        this.i18nResolver = i18nResolver;
        this.settings = settings;
        this.userDataService = userDataService;
        this.apiKeysService = moApiKeysService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null) {
            this.redirectToLogin(req, resp);
            return;
        }
        if (this.isAdministrator()) {
            try {
                this.webSudoManager.willExecuteWebSudoRequest(req);
            }
            catch (WebSudoSessionException e) {
                LOGGER.debug("admin session expired. Redirecting for websudo protection");
                this.webSudoManager.enforceWebSudoProtection(req, resp);
                return;
            }
        }
        Boolean isAzureADConfigPresentWithoutTenantID = false;
        String currentOAuthProvider = StringUtils.defaultIfBlank(this.settings.getOAuthProvider(), "");
        String isTenantIDConfigured = StringUtils.defaultIfBlank(this.settings.getAzureADTenantID(), "");
        if (currentOAuthProvider.equals("Azure AD") && isTenantIDConfigured.isEmpty()) {
            isAzureADConfigPresentWithoutTenantID = true;
        }
        Boolean doNotShowPopUp = this.settings.getDisablePopUp();
        String username = "";
        String userNameToDisplayTokens = StringUtils.defaultIfBlank(req.getParameter("userNameToDisplayTokens"), "");
        username = StringUtils.isNotBlank(userNameToDisplayTokens) && this.isAdministrator() ? userNameToDisplayTokens : user.getUsername();
        SMTPMailServer mailServer = MailFactory.getServerManager().getDefaultSMTPMailServer();
        Boolean allowUsersToCreateTokens = this.settings.getAllowUsersToCreateTokens();
        Boolean isUserAllowedToGenerateBasedOnGroups = this.checkIfUserBelongsToRestrictTokenGenerationGroups(user.getUsername());
        Boolean isMailServerSetup = true;
        if (mailServer == null) {
            isMailServerSetup = false;
        }
        Map<Object, Object> apiKeysList = new HashMap();
        apiKeysList = this.restPluginHandler.getApiKeysAfterMigration(username);
        List<ApiKey> universalKeys = this.restPluginHandler.getApiKeys(MoPluginConstants.ApiConstants.UNIVERSAL_API_KEYS.getKey());
        boolean setMaxExpiryTime = this.settings.getMaxExpiryTime();
        String maximumExpiryCount = this.settings.getMaximumExpiryCount();
        String maximumExpiryInterval = this.settings.getMaximumExpiryInterval();
        Boolean disablePopUp = this.settings.getDisablePopUp();
        Boolean maxTokenEnabled = this.settings.getMaxToken();
        Integer maxTokenCount = Integer.parseInt(this.settings.getMaximumTokenCount());
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("req", req);
        context.put("isAdmin", this.isAdministrator());
        Boolean isOAuthProviderConfigured = StringUtils.isNotBlank(this.settings.getOAuthProvider());
        context.put("platform", this.i18nResolver.getText("my.plugin.platform"));
        context.put("doNotShowPopUp", doNotShowPopUp);
        context.put("isOAuthProviderConfigured", isOAuthProviderConfigured);
        context.put("isAzureADConfigPresentWithoutTenantID", isAzureADConfigPresentWithoutTenantID);
        context.put("isMailServerSetup", isMailServerSetup);
        context.put("allowUsersToCreateTokens", allowUsersToCreateTokens);
        context.put("restrictTokenGenerationGroupEnabled", this.settings.getRestrictTokenGenerationGroupEnabled());
        context.put("isUserAllowedToGenerateBasedOnGroups", isUserAllowedToGenerateBasedOnGroups);
        context.put("apiKeysList", apiKeysList);
        context.put("maxTokenEnabled", maxTokenEnabled);
        context.put("maxTokenCount", maxTokenCount);
        context.put("universalKeys", universalKeys);
        context.put("userNameToDisplayTokens", username);
        context.put("enableAuthentication", this.settings.getEnableAuthentication());
        context.put("settings", this.settings);
        context.put("setMaxExpiryTime", setMaxExpiryTime);
        context.put("maximumExpiryCount", maximumExpiryCount);
        String maximumExpiryIntervalString = this.restPluginHandler.getMaximumExpiryInterval(maximumExpiryInterval);
        context.put("maximumExpiryInterval", maximumExpiryIntervalString);
        context.put("oauthType", this.settings.getOauthTokenType());
        context.put("isDatacenter", this.settings.isDatacenter());
        resp.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("vm/managetokens.vm", context, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null) {
            this.redirectToLogin(req, resp);
            return;
        }
        String name = req.getParameter("name");
        String keyType = req.getParameter("keyType");
        String expiryTime = req.getParameter("expiryTime");
        String expiryIntervalCount = req.getParameter("expiry_interval_count");
        String expiryInterval = req.getParameter("expiry_interval");
        Boolean sendTokenViaEmail = BooleanUtils.toBoolean(req.getParameter("sendTokenViaEmail"));
        LOGGER.debug("sendTokenViaEmail is  " + sendTokenViaEmail);
        if (StringUtils.isBlank(name)) {
            MoHttpUtils.sendError(resp, 400, this.i18nResolver.getText("restauth.error.apikey.name.empty"));
        }
        if (expiryTime.equals("custom") && Integer.parseInt(expiryIntervalCount) < 1) {
            MoHttpUtils.sendError(resp, 403, "Invalid Expiry time");
            return;
        }
        Boolean isUniversal = BooleanUtils.toBoolean(req.getParameter("isUniversal"));
        LOGGER.debug("isUniversal " + isUniversal);
        if (isUniversal.booleanValue() && !this.isAdministrator()) {
            MoHttpUtils.sendError(resp, 403, this.i18nResolver.getText("restauth.error.forbidden"));
            return;
        }
        String username = "";
        if (!this.settings.getAllowUsersToCreateTokens().booleanValue()) {
            username = req.getParameter("userName");
        }
        if (username.isEmpty()) {
            username = user.getUsername();
        }
        LOGGER.debug("username = " + username);
        boolean isExpiryValid = this.isExpiryValid(expiryTime, expiryInterval, expiryIntervalCount);
        if (!isExpiryValid) {
            MoHttpUtils.sendError(resp, 400, this.i18nResolver.getText("restauth.error.apikey.invalid.expiry"));
            return;
        }
        String platform = this.i18nResolver.getText("my.plugin.platform");
        LOGGER.debug("platform = " + platform);
        int apiKeyCount = this.restPluginHandler.getApiKeysAfterMigration(username).size();
        int maxTokenCount = Integer.parseInt(this.settings.getMaximumTokenCount());
        boolean maxTokenEnabled = this.settings.getMaxToken();
        List<ApiKey> universalKeys = this.restPluginHandler.getApiKeys(MoPluginConstants.ApiConstants.UNIVERSAL_API_KEYS.getKey());
        LOGGER.debug("Key count : " + (apiKeyCount + universalKeys.size()));
        if (!this.isAdministrator(username) && maxTokenEnabled && apiKeyCount + universalKeys.size() >= maxTokenCount) {
            LOGGER.debug("Maximum Token count exceeded");
            MoHttpUtils.sendError(resp, 403, "Unable to create new token. Maximum tokens limit reached. Please delete expired/unused tokens to create new ones.");
        } else {
            ApiKey apiKey = this.restPluginHandler.saveApiKey(name, isUniversal != false ? MoPluginConstants.ApiConstants.UNIVERSAL_API_KEYS.getKey() : username, keyType, expiryTime, expiryInterval, expiryIntervalCount, platform, sendTokenViaEmail);
            LOGGER.debug("API Key Generated");
            JsonObject data = this.createApiKeyResponse(apiKey);
            MoHttpUtils.sendResponse(resp, data);
        }
    }

    private boolean isExpiryValid(String expiryTime, String expiryInterval, String expiryIntervalCount) {
        Date maxExpiryDate;
        if (!this.settings.getMaxExpiryTime()) {
            return true;
        }
        if (StringUtils.isBlank(expiryTime)) {
            return false;
        }
        String maximumExpiryCount = this.settings.getMaximumExpiryCount();
        String maximumExpiryInterval = this.settings.getMaximumExpiryInterval();
        Date currentDate = new Date();
        Date inputExpiryDate = this.restPluginHandler.calculateExpiryDate(currentDate, expiryTime, expiryInterval, expiryIntervalCount);
        return !inputExpiryDate.after(maxExpiryDate = this.restPluginHandler.calculateExpiryDate(currentDate, expiryTime, maximumExpiryInterval, maximumExpiryCount));
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String id;
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null) {
            this.redirectToLogin(req, resp);
            return;
        }
        String username = user.getUsername();
        String userNameToDeleteTokens = StringUtils.defaultIfBlank(req.getParameter("currentUserToDisplayTokens"), "");
        if (StringUtils.isNotBlank(userNameToDeleteTokens)) {
            username = userNameToDeleteTokens;
        }
        if (StringUtils.isBlank(id = req.getParameter("id"))) {
            MoHttpUtils.sendError(resp, 400, this.i18nResolver.getText("restauth.error.apikey.id.empty"));
            return;
        }
        Set<String> apiKeyIds = this.restPluginHandler.getApiKeyIds(username);
        Boolean isUniversal = false;
        Boolean result = this.apiKeysService.deleteApiKey(id);
        this.restPluginHandler.deleteApiKey(id, username, isUniversal);
        JsonObject jsonObject = this.createDeleteKeyResponse();
        MoHttpUtils.sendResponse(resp, jsonObject);
    }

    private JsonObject createDeleteKeyResponse() {
        JsonObject deleteKeyResponse = new JsonObject();
        deleteKeyResponse.addProperty("status", "SUCCESS");
        deleteKeyResponse.addProperty("message", "API Key Deleted Successfully");
        return deleteKeyResponse;
    }

    private boolean isAdministrator() {
        UserProfile userProfile = this.userManager.getRemoteUser();
        return this.userManager.isAdmin(userProfile.getUserKey());
    }

    private boolean isAdministrator(String username) {
        UserProfile userProfile = this.userManager.getUserProfile(username);
        if (userProfile != null) {
            return this.userManager.isAdmin(userProfile.getUserKey());
        }
        return false;
    }

    private JsonObject createApiKeyResponse(ApiKey apiKey) {
        JsonObject data = new JsonObject();
        data.addProperty("name", apiKey.getName());
        data.addProperty("key", apiKey.getKey());
        return data;
    }

    private void redirectToLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String LoginUri = MoRESTUtils.sanitizeText(this.loginUriProvider.getLoginUri(MoHttpUtils.getUri(req)).toASCIIString());
        resp.sendRedirect(LoginUri);
    }

    private Boolean checkIfUserBelongsToRestrictTokenGenerationGroups(String username) {
        List restrictTokenGenerationGroupsList = (List)this.settings.getRestrictTokenGenerationGroups();
        if (restrictTokenGenerationGroupsList.isEmpty()) {
            return false;
        }
        for (String restrictTokenGenerationGroup : restrictTokenGenerationGroupsList) {
            if (!this.userManager.isUserInGroup(username, restrictTokenGenerationGroup)) continue;
            return true;
        }
        return false;
    }
}

