/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.servlet;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.handler.MoRESTPluginHandler;
import com.miniorange.rest.auth.commons.util.MoHttpUtils;
import com.miniorange.rest.auth.commons.util.MoOAuthUtils;
import com.miniorange.rest.auth.commons.util.MoRESTUtils;
import java.io.IOException;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoJwt
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoJwt.class);
    private MoRESTAuthSettings settings;
    private final TemplateRenderer templateRenderer;
    private MoRESTPluginHandler pluginHandler;
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final I18nResolver i18nResolver;

    public MoJwt(MoRESTAuthSettings settings, MoRESTPluginHandler pluginHandler, UserManager userManager, TemplateRenderer templateRenderer, LoginUriProvider loginUriProvider, I18nResolver i18nResolver) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.userManager = userManager;
        this.templateRenderer = templateRenderer;
        this.loginUriProvider = loginUriProvider;
        this.i18nResolver = i18nResolver;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null || !this.isAdministrator()) {
            this.redirectToLogin(req, resp);
            return;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("req", req);
        String platform = this.i18nResolver.getText("my.plugin.platform");
        context.put("platform", platform);
        context.put("providerName", this.settings.getJwtProviderName());
        context.put("introspectionEndpoint", this.settings.getJwtIntrospectionEndpoint());
        context.put("clientId", this.settings.getJwtClientId());
        context.put("publicKey", this.settings.getJwtPublicKey());
        context.put("username", this.settings.getJwtUsername());
        context.put("oauthType", this.settings.getOauthTokenType());
        context.put("isDatacenter", this.settings.isDatacenter());
        resp.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("vm/jwt.vm", context, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null || !this.isAdministrator()) {
            MoHttpUtils.sendError(resp, 403, this.i18nResolver.getText("restauth.error.forbidden"));
        }
        String providerName = req.getParameter("providerName");
        String introspectionEndpoint = req.getParameter("introspectionEndpoint");
        String clientId = req.getParameter("clientId");
        String publicKey = req.getParameter("publicKey");
        String username = req.getParameter("username");
        if (!this.validatePublicKey(publicKey).booleanValue()) {
            MoHttpUtils.sendError(resp, 400, "Invalid Public Key");
        } else {
            this.pluginHandler.saveJwtSettings(providerName, introspectionEndpoint, clientId, publicKey, username);
        }
    }

    private boolean isAdministrator() {
        UserProfile userProfile = this.userManager.getRemoteUser();
        return this.userManager.isAdmin(userProfile.getUserKey());
    }

    private void redirectToLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String LoginUri = MoRESTUtils.sanitizeText(this.loginUriProvider.getLoginUri(MoHttpUtils.getUri(req)).toASCIIString());
        resp.sendRedirect(LoginUri);
    }

    private Boolean validatePublicKey(String publickey) {
        String publicCertificate = MoOAuthUtils.deserializePublicKey(publickey);
        byte[] publicBytes = Base64.decodeBase64((String)publicCertificate);
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            keyFactory.generatePublic(keySpec);
            return true;
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }
}

