/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.servlet;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.net.InetAddresses;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.handler.MoOfflineLicenseHandler;
import com.miniorange.rest.auth.commons.handler.MoRESTPluginHandler;
import com.miniorange.rest.auth.commons.servlet.MoUserRestriction;
import com.miniorange.rest.auth.commons.util.MoHttpUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.util.SubnetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoIPRestriction
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoUserRestriction.class);
    private final TemplateRenderer templateRenderer;
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final WebSudoManager webSudoManager;
    private final MoRESTPluginHandler restPluginHandler;
    private final I18nResolver i18nResolver;
    private final MoRESTAuthSettings settings;
    private MoOfflineLicenseHandler moOfflineLicenseHandler;

    public MoIPRestriction(TemplateRenderer templateRenderer, UserManager userManager, LoginUriProvider loginUriProvider, WebSudoManager webSudoManager, MoRESTPluginHandler restPluginHandler, I18nResolver i18nResolver, MoRESTAuthSettings settings, MoOfflineLicenseHandler moOfflineLicenseHandler) {
        this.templateRenderer = templateRenderer;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.webSudoManager = webSudoManager;
        this.restPluginHandler = restPluginHandler;
        this.i18nResolver = i18nResolver;
        this.settings = settings;
        this.moOfflineLicenseHandler = moOfflineLicenseHandler;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null || !this.isAdministrator()) {
            this.redirectToLogin(req, resp);
            return;
        }
        try {
            this.webSudoManager.willExecuteWebSudoRequest(req);
        }
        catch (WebSudoSessionException e) {
            LOGGER.debug("admin session expired. Redirecting for websudo protection");
            this.webSudoManager.enforceWebSudoProtection(req, resp);
            return;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("req", req);
        context.put("restrictIPEnabled", this.settings.getRestrictIPEnabled());
        context.put("restrictedIP", this.settings.getRestrictedIP());
        context.put("isDatacenter", this.settings.isDatacenter());
        context.put("oauthType", this.settings.getOauthTokenType());
        resp.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("vm/iprestriction.vm", context, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null || !this.isAdministrator()) {
            MoHttpUtils.sendError(resp, 403, this.i18nResolver.getText("restauth.error.forbidden"));
        }
        Boolean restrictIPEnabled = BooleanUtils.toBoolean(req.getParameter("restrictIPEnabled"));
        ArrayList<String> restrictedIP = new ArrayList<String>();
        int idTotalIPParameters = Integer.parseInt(StringUtils.defaultIfBlank(req.getParameter("idTotalIPParameters"), "0"));
        LOGGER.debug("idTotalIPParameters   " + idTotalIPParameters);
        String ip1 = req.getParameter("val");
        this.verifyIp(ip1, resp);
        for (int i = 0; i < idTotalIPParameters; ++i) {
            String ip;
            block7: {
                ip = req.getParameter("restrictedIP[" + i + "]");
                if (!StringUtils.isNotEmpty(ip)) continue;
                if (ip.contains("/")) {
                    try {
                        SubnetUtils subnetUtils = new SubnetUtils(ip);
                        break block7;
                    }
                    catch (Exception e) {
                        LOGGER.debug("Invalid Ip address ");
                        LOGGER.debug(e.getMessage());
                        MoHttpUtils.sendError(resp, 403, this.i18nResolver.getText("restauth.error.iprestriction"));
                        continue;
                    }
                }
                if (!InetAddresses.isInetAddress((String)ip)) {
                    MoHttpUtils.sendError(resp, 403, this.i18nResolver.getText("restauth.error.iprestriction"));
                    continue;
                }
            }
            restrictedIP.add(ip.trim());
        }
        if (ip1 == null) {
            this.restPluginHandler.saveIPRestrictionSettings(restrictIPEnabled, restrictedIP);
        }
    }

    private void verifyIp(String ip, HttpServletResponse resp) throws IOException {
        if (StringUtils.isNotEmpty(ip)) {
            if (ip.contains("/")) {
                try {
                    SubnetUtils subnetUtils = new SubnetUtils(ip);
                }
                catch (Exception e) {
                    LOGGER.debug("Invalid Ip address ");
                    LOGGER.debug(e.getMessage());
                    MoHttpUtils.sendError(resp, 403, this.i18nResolver.getText("restauth.error.iprestriction"));
                }
            } else if (!InetAddresses.isInetAddress((String)ip)) {
                MoHttpUtils.sendError(resp, 403, this.i18nResolver.getText("restauth.error.iprestriction"));
            }
        }
    }

    private boolean isAdministrator() {
        UserProfile userProfile = this.userManager.getRemoteUser();
        return this.userManager.isAdmin(userProfile.getUserKey());
    }

    private void redirectToLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.sendRedirect(this.loginUriProvider.getLoginUri(MoHttpUtils.getUri(req)).toASCIIString());
    }
}

