/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.servlet;

import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.handler.MoOfflineLicenseHandler;
import com.miniorange.rest.auth.commons.handler.MoRESTPluginHandler;
import com.miniorange.rest.auth.commons.util.MoHttpUtils;
import com.miniorange.rest.auth.commons.util.MoRESTUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoGlobalSettings
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoGlobalSettings.class);
    private final TemplateRenderer templateRenderer;
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final WebSudoManager webSudoManager;
    private final MoRESTPluginHandler restPluginHandler;
    private final I18nResolver i18nResolver;
    private final MoRESTAuthSettings settings;
    private MoOfflineLicenseHandler moOfflineLicenseHandler;

    public MoGlobalSettings(TemplateRenderer templateRenderer, UserManager userManager, LoginUriProvider loginUriProvider, WebSudoManager webSudoManager, MoRESTPluginHandler restPluginHandler, I18nResolver i18nResolver, MoRESTAuthSettings settings, MoOfflineLicenseHandler moOfflineLicenseHandler) {
        this.templateRenderer = templateRenderer;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.webSudoManager = webSudoManager;
        this.restPluginHandler = restPluginHandler;
        this.i18nResolver = i18nResolver;
        this.settings = settings;
        this.moOfflineLicenseHandler = moOfflineLicenseHandler;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null || !this.isAdministrator()) {
            this.redirectToLogin(req, resp);
            return;
        }
        try {
            this.webSudoManager.willExecuteWebSudoRequest(req);
        }
        catch (WebSudoSessionException e) {
            LOGGER.debug("admin session expired. Redirecting for websudo protection");
            this.webSudoManager.enforceWebSudoProtection(req, resp);
            return;
        }
        SMTPMailServer mailServer = MailFactory.getServerManager().getDefaultSMTPMailServer();
        Boolean allowUsersToCreateTokens = this.settings.getAllowUsersToCreateTokens();
        Boolean isMailServerSetup = true;
        if (mailServer == null) {
            isMailServerSetup = false;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("req", req);
        context.put("enableAuthentication", this.settings.getEnableAuthentication());
        context.put("isDatacenter", this.settings.isDatacenter());
        context.put("isMailServerSetup", isMailServerSetup);
        context.put("allowUsersToCreateTokens", allowUsersToCreateTokens);
        context.put("disableBasicAuthentication", this.settings.getDisableBasicAuthentication());
        context.put("allowPATTokens", this.settings.getAllowPATTokens());
        context.put("oauthType", this.settings.getOauthTokenType());
        resp.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("vm/globalsettings.vm", context, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null || !this.isAdministrator()) {
            MoHttpUtils.sendError(resp, 403, this.i18nResolver.getText("restauth.error.forbidden"));
        }
        Boolean enableAuthentication = BooleanUtils.toBoolean(req.getParameter("enableAuthentication"));
        Boolean allowUsersToCreateTokens = BooleanUtils.toBoolean(req.getParameter("allowUsersToCreateTokens"));
        Boolean disableBasicAuthentication = BooleanUtils.toBoolean(req.getParameter("disableBasicAuthentication"));
        Boolean allowPATTokens = BooleanUtils.toBoolean(req.getParameter("allowPATTokens"));
        this.restPluginHandler.saveGlobalSettings(enableAuthentication, disableBasicAuthentication, allowUsersToCreateTokens, allowPATTokens);
    }

    private boolean isAdministrator() {
        UserProfile userProfile = this.userManager.getRemoteUser();
        return this.userManager.isAdmin(userProfile.getUserKey());
    }

    private void redirectToLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String LoginUri = MoRESTUtils.sanitizeText(this.loginUriProvider.getLoginUri(MoHttpUtils.getUri(req)).toASCIIString());
        resp.sendRedirect(LoginUri);
    }

    public TemplateRenderer getTemplateRenderer() {
        return this.templateRenderer;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }
}

