/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.servlet;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.gson.Gson;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.dto.AuditLog;
import com.miniorange.rest.auth.commons.util.MoHttpUtils;
import com.miniorange.rest.auth.commons.util.MoRESTUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoExportLogsServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoExportLogsServlet.class);
    private final MoRESTAuthSettings settings;
    private final I18nResolver i18nResolver;
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;

    public MoExportLogsServlet(MoRESTAuthSettings settings, UserManager userManager, LoginUriProvider loginUriProvider, I18nResolver i18nResolver) {
        this.settings = settings;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.i18nResolver = i18nResolver;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null || !this.isAdministrator()) {
            this.redirectToLogin(request, response);
            return;
        }
        String platform = this.i18nResolver.getText("my.plugin.platform");
        try {
            CSVPrinter printer = new CSVPrinter(response.getWriter(), CSVFormat.DEFAULT);
            Gson gson = new Gson();
            String fileName = "./mO_" + platform + "_REST_API_AuditLogs.csv";
            String logType = request.getParameter("logType");
            printer.printRecord("Username", "Date", "API URL", "Request Type", "Status");
            if (StringUtils.isBlank(logType)) {
                List<AuditLog> auditLogs = this.settings.getAuditLogsListAfterMigration();
                LOGGER.debug("Size of audit logs is " + auditLogs.size());
                for (AuditLog auditLog : auditLogs) {
                    long timeInMilliSeconds = auditLog.getDate().getTime();
                    Date auditLogCreation = new Date(timeInMilliSeconds);
                    printer.printRecord(auditLog.getUsername(), auditLogCreation, auditLog.getApiUrl(), auditLog.getRequestType(), auditLog.getStatus());
                }
            } else {
                List<String> auditLogsList = this.settings.getAuditLogsList();
                for (String auditLogEntry : auditLogsList) {
                    auditLogEntry = auditLogEntry.replaceAll("^\\\"|\\\"$", "");
                    AuditLog auditLog = (AuditLog)gson.fromJson(auditLogEntry, AuditLog.class);
                    printer.printRecord(auditLog.getUsername(), auditLog.getDate(), auditLog.getApiUrl(), auditLog.getRequestType(), auditLog.getStatus());
                }
            }
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            response.setHeader("Cache-Control", "max-age=0");
            LOGGER.debug("Logs exported Successfully");
        }
        catch (Exception e) {
            LOGGER.error("Exception Occurred while exporting logs = " + e);
            this.sendErrorResponse("Error occurred while exporting logs", response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
    }

    private boolean isAdministrator() {
        UserProfile userProfile = this.userManager.getRemoteUser();
        return this.userManager.isAdmin(userProfile.getUserKey());
    }

    private void redirectToLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String LoginUri = MoRESTUtils.sanitizeText(this.loginUriProvider.getLoginUri(MoHttpUtils.getUri(req)).toASCIIString());
        resp.sendRedirect(LoginUri);
    }

    private void sendSuccessFullResponse(String result, HttpServletResponse resp) throws IOException {
        result = MoRESTUtils.sanitizeText(result);
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes(StandardCharsets.UTF_8));
            resp.getOutputStream().close();
        }
    }

    private void sendErrorResponse(String errorMessages, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(500);
        resp.getOutputStream().write(errorMessages.getBytes(StandardCharsets.UTF_8));
        resp.getOutputStream().close();
    }
}

