/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.servlet;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoConfigureTokenViaRestApi
extends HttpServlet {
    private MoRESTAuthSettings moRESTAuthSettings;
    private TemplateRenderer templateRenderer;
    private I18nResolver i18nResolver;
    private UserManager userManager;
    private static final Logger LOGGER = LoggerFactory.getLogger(MoConfigureTokenViaRestApi.class);

    public MoConfigureTokenViaRestApi(MoRESTAuthSettings moRESTAuthSettings, TemplateRenderer templateRenderer, I18nResolver i18nResolver, UserManager userManager) {
        this.moRESTAuthSettings = moRESTAuthSettings;
        this.templateRenderer = templateRenderer;
        this.i18nResolver = i18nResolver;
        this.userManager = userManager;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("MoConfigureTokenViaRestAPI servlet is called from doGet");
        HashMap<String, Object> context = new HashMap<String, Object>();
        String platform = this.i18nResolver.getText("my.plugin.platform");
        context.put("isAdmin", this.isAdministrator());
        context.put("req", request);
        context.put("baseUrl", this.moRESTAuthSettings.getBaseUrl());
        context.put("platform", platform);
        context.put("oauthType", this.moRESTAuthSettings.getOauthTokenType());
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("/vm/apitokensviaApi.vm", context, (Writer)response.getWriter());
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
    }

    private Boolean isAdministrator() {
        UserProfile userProfile = this.userManager.getRemoteUser();
        return this.userManager.isAdmin(userProfile.getUserKey());
    }
}

