/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.servlet;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.handler.MoOfflineLicenseHandler;
import com.miniorange.rest.auth.commons.handler.MoRESTPluginHandler;
import com.miniorange.rest.auth.commons.util.MoHttpUtils;
import com.miniorange.rest.auth.commons.util.MoRESTUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoConfigureByPassUrl
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoConfigureByPassUrl.class);
    private final TemplateRenderer templateRenderer;
    private final MoRESTAuthSettings moRESTAuthSettings;
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final MoRESTPluginHandler restPluginHandler;
    private final I18nResolver i18nResolver;
    private MoOfflineLicenseHandler moOfflineLicenseHandler;

    public MoConfigureByPassUrl(TemplateRenderer templateRenderer, MoRESTAuthSettings moRESTAuthSettings, UserManager userManager, LoginUriProvider loginUriProvider, MoRESTPluginHandler restPluginHandler, I18nResolver i18nResolver, MoOfflineLicenseHandler moOfflineLicenseHandler) {
        this.templateRenderer = templateRenderer;
        this.moRESTAuthSettings = moRESTAuthSettings;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.restPluginHandler = restPluginHandler;
        this.i18nResolver = i18nResolver;
        this.moOfflineLicenseHandler = moOfflineLicenseHandler;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("Configure ByPaased Url Serlvet called");
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("oauthType", this.moRESTAuthSettings.getOauthTokenType());
        context.put("req", request);
        String platform = this.i18nResolver.getText("my.plugin.platform");
        List<String> bypassapiUrls = this.moRESTAuthSettings.getByPassApiUrlsAsList();
        for (String apiUrl : bypassapiUrls) {
            LOGGER.debug("the apiUrl is" + apiUrl);
        }
        context.put("bypassUrl", bypassapiUrls);
        context.put("platform", platform);
        context.put("isDatacenter", this.moRESTAuthSettings.isDatacenter());
        this.templateRenderer.render("vm/configureBypassUrl.vm", context, (Writer)response.getWriter());
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("MoConfigureByPassUrl doPost called");
        String bypassUrl = StringUtils.defaultIfBlank(request.getParameter("action"), "");
        LOGGER.debug("the bypassed url is :" + bypassUrl);
        if (bypassUrl.isEmpty()) {
            LOGGER.debug("No bypassUrl is entered");
            MoHttpUtils.sendError(response, 400, "No apiUrl is entered");
            return;
        }
        if (bypassUrl.equals("rest") || bypassUrl.equals("/rest") || bypassUrl.equals("rest/") || bypassUrl.equals("/rest/") || bypassUrl.equals("/")) {
            LOGGER.error("Entered URI is forbidden");
            MoHttpUtils.sendError(response, 400, "Entered URI is forbidden");
            return;
        }
        Map<Object, Object> apiurls = new HashMap();
        if (this.moRESTAuthSettings.getPublicApiUrls() != null && (apiurls = this.moRESTAuthSettings.getPublicApiUrls()).containsValue(bypassUrl = bypassUrl.trim())) {
            LOGGER.debug("the url is already configured in public api url");
            MoHttpUtils.sendError(response, 400, "Url is already configured in restrict public api");
            return;
        }
        this.moRESTAuthSettings.setByPassApiUrl(bypassUrl);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String bypassurlId;
        LOGGER.debug("delete servlet is called");
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null) {
            this.redirectToLogin(request, response);
        }
        if (StringUtils.isBlank(bypassurlId = request.getParameter("id"))) {
            MoHttpUtils.sendError(response, 400, "ID of API URL can't be empty");
            return;
        }
        if (!this.isAdministrator()) {
            MoHttpUtils.sendError(response, 403, "You don't have the permission to delete this key");
            return;
        }
        this.restPluginHandler.deteteByPassApiUrl(bypassurlId);
    }

    private void redirectToLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String LoginUri = MoRESTUtils.sanitizeText(this.loginUriProvider.getLoginUri(MoHttpUtils.getUri(req)).toASCIIString());
        resp.sendRedirect(LoginUri);
    }

    private boolean isAdministrator() {
        UserProfile userProfile = this.userManager.getRemoteUser();
        return this.userManager.isAdmin(userProfile.getUserKey());
    }
}

