/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.servlet;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.gson.Gson;
import com.miniorange.rest.auth.commons.MoAuditService;
import com.miniorange.rest.auth.commons.MoAuditTrackerService;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.dto.AuditLog;
import com.miniorange.rest.auth.commons.handler.MoOfflineLicenseHandler;
import com.miniorange.rest.auth.commons.scheduler.AuditLogScheduler;
import com.miniorange.rest.auth.commons.util.MoHttpUtils;
import com.miniorange.rest.auth.commons.util.MoRESTUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoAuditLogServet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoAuditLogServet.class);
    private final TemplateRenderer templateRenderer;
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final MoRESTAuthSettings settings;
    private final I18nResolver i18nResolver;
    private final WebSudoManager webSudoManager;
    private MoAuditService moAuditService;
    private MoOfflineLicenseHandler moOfflineLicenseHandler;
    private Integer prevIndex;
    private Integer lastIndex;
    private Integer nextIndex;
    private Integer startIndex;
    private Integer endIndex;
    private Integer currentIndex;
    private MoAuditTrackerService moAuditTrackerService;
    private AuditLogScheduler auditLogScheduler;

    public MoAuditLogServet(TemplateRenderer templateRenderer, UserManager userManager, MoRESTAuthSettings settings, LoginUriProvider loginUriProvider, I18nResolver i18nResolver, WebSudoManager webSudoManager, MoAuditService moAuditService, MoOfflineLicenseHandler moOfflineLicenseHandler, MoAuditTrackerService moAuditTrackerService, AuditLogScheduler auditLogScheduler) {
        this.templateRenderer = templateRenderer;
        this.userManager = userManager;
        this.settings = settings;
        this.loginUriProvider = loginUriProvider;
        this.i18nResolver = i18nResolver;
        this.webSudoManager = webSudoManager;
        this.moAuditService = moAuditService;
        this.moOfflineLicenseHandler = moOfflineLicenseHandler;
        this.moAuditTrackerService = moAuditTrackerService;
        this.auditLogScheduler = auditLogScheduler;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null || !this.isAdministrator()) {
            this.redirectToLogin(request, response);
            return;
        }
        try {
            this.webSudoManager.willExecuteWebSudoRequest(request);
        }
        catch (WebSudoSessionException e) {
            LOGGER.debug("admin session expired. Redirecting for websudo protection");
            this.webSudoManager.enforceWebSudoProtection(request, response);
            return;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        ArrayList auditLogs = new ArrayList();
        Boolean enableAuditLogs = this.settings.getEnableAuditLogs();
        ArrayList auditLogObjectsList = new ArrayList();
        List<Object> auditLogObjectsListAfterFilters = new ArrayList();
        this.currentIndex = Integer.valueOf(StringUtils.defaultIfBlank(request.getParameter("currentIndex"), "1"));
        String filterLogsByPeriod = StringUtils.defaultIfBlank(request.getParameter("filterLogsByPeriod"), "All Days");
        LOGGER.debug("FilterLogsByPeriod:-" + filterLogsByPeriod);
        int logsPerPage = 20;
        int auditLogsSize = 0;
        int totalLogs = 0;
        try {
            Date period;
            if (filterLogsByPeriod.equals("All Days")) {
                LOGGER.debug("Displaying Audit Logs for all days");
                period = new Date(0L);
            } else {
                Calendar calendar = Calendar.getInstance();
                long timeMilliSecs = calendar.getTimeInMillis();
                long filterDays = NumberUtils.createInteger(filterLogsByPeriod).intValue();
                long filterDaysInMilliSecs = filterDays * 86400000L;
                long timeInPast = timeMilliSecs - filterDaysInMilliSecs;
                period = new Date(timeInPast);
            }
            auditLogObjectsListAfterFilters = this.settings.getPaginatedAuditLogs(period, this.currentIndex, logsPerPage);
            auditLogsSize = auditLogObjectsListAfterFilters.size();
            totalLogs = this.moAuditTrackerService.getAuditEntriesCountByDateFilter(period);
            this.setAuditIndexes(this.currentIndex, totalLogs);
            int start = (this.currentIndex - 1) * 20;
            int end = NumberUtils.min(new int[]{start + 20, auditLogsSize});
            context.put("isDatacenter", this.settings.isDatacenter());
            context.put("auditLogObjectsList", auditLogObjectsListAfterFilters);
            context.put("filterLogsByPeriod", filterLogsByPeriod);
            context.put("maxUsersPerPage", logsPerPage);
            context.put("enableAuditLogs", enableAuditLogs);
            context.put("auditLogsSize", auditLogsSize);
            context.put("start", start);
            context.put("startIndex", this.startIndex);
            context.put("totalLogs", totalLogs);
            context.put("lastIndex", this.lastIndex);
            context.put("prevCounter", this.prevIndex);
            context.put("endIndex", this.endIndex);
            context.put("nextIndex", this.nextIndex);
            context.put("currentIndex", this.currentIndex);
            context.put("endIndex", this.endIndex);
            context.put("viewPastAuditLogs", this.settings.viewPastAuditLogs());
            context.put("schedulerStatus", this.settings.getSchedulerStatus());
            context.put("pastDays", this.settings.getPastDaysConfigured());
            context.put("numberOfEntries", this.settings.getNumberOfEntries());
            context.put("oauthType", this.settings.getOauthTokenType());
            context.put("req", request);
            response.setContentType("text/html;charset=utf-8");
            this.templateRenderer.render("vm/auditlog.vm", context, (Writer)response.getWriter());
        }
        catch (Exception e) {
            LOGGER.error("An exception occurred in loading ");
        }
    }

    private List<AuditLog> getAllLogs(List<AuditLog> auditLogs, int startIndex, int endIndex) {
        ArrayList<AuditLog> auditLogObjectsList = new ArrayList<AuditLog>();
        Gson gson = new Gson();
        if (auditLogs != null) {
            for (int counter = startIndex; counter < Math.min(auditLogs.size(), endIndex); ++counter) {
                AuditLog auditLogObject = auditLogs.get(counter);
                auditLogObjectsList.add(auditLogObject);
            }
        }
        return auditLogObjectsList;
    }

    private void setAuditIndexes(Integer currentIndex, Integer tableSize) {
        this.lastIndex = tableSize % 20 != 0 ? Integer.valueOf(tableSize / 20 + 1) : Integer.valueOf(tableSize / 20);
        if (tableSize == 20) {
            this.lastIndex = 1;
        }
        this.prevIndex = currentIndex == 1 ? 1 : currentIndex - 1;
        this.nextIndex = currentIndex == this.lastIndex ? this.lastIndex : currentIndex + 1;
        this.startIndex = currentIndex - 1 == 0 ? 1 : currentIndex - 1;
        this.endIndex = Integer.min(this.lastIndex, currentIndex + 1);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            UserProfile user = this.userManager.getRemoteUser();
            if (user == null || !this.isAdministrator()) {
                MoHttpUtils.sendError(response, 403, this.i18nResolver.getText("restauth.error.forbidden"));
            }
            Integer pastDaysConfigured = Integer.valueOf(request.getParameter("pastDays"));
            LOGGER.debug("Past Days configured are " + pastDaysConfigured);
            Integer numberOfEntries = Integer.valueOf(request.getParameter("numberOfEntries"));
            LOGGER.debug("Number of Entries that will retain are " + numberOfEntries);
            this.settings.setPastDaysConfigured(pastDaysConfigured);
            this.settings.setNumberOfEntries(numberOfEntries);
            this.settings.setSchedulerStatus(false);
            this.auditLogScheduler.unschedule();
            this.auditLogScheduler.schedule();
            MoHttpUtils.sendResponse(response, "Saved Successfully.");
        }
        catch (Exception e) {
            LOGGER.error("An Exception occurred in saving the Auto Deletion settings of Audit Logs" + e.getMessage());
            MoHttpUtils.sendError(response, 403, this.i18nResolver.getText("restauth.error.insaving"));
        }
    }

    private boolean isAdministrator() {
        UserProfile userProfile = this.userManager.getRemoteUser();
        return this.userManager.isAdmin(userProfile.getUserKey());
    }

    private void redirectToLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String LoginUri = MoRESTUtils.sanitizeText(this.loginUriProvider.getLoginUri(MoHttpUtils.getUri(req)).toASCIIString());
        resp.sendRedirect(LoginUri);
    }
}

