/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.servlet;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.miniorange.rest.auth.commons.MoAuditService;
import com.miniorange.rest.auth.commons.MoAuditTrackerService;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.exceptions.MoPluginException;
import com.miniorange.rest.auth.commons.handler.MoRESTPluginHandler;
import com.miniorange.rest.auth.commons.handler.UtilDecisionHandler;
import com.miniorange.rest.auth.commons.scheduler.AuditLogScheduler;
import com.miniorange.rest.auth.commons.util.MoHttpUtils;
import com.miniorange.rest.auth.commons.util.MoRESTUtils;
import com.miniorange.rest.auth.commons.util.PlatformUtils;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Level;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoAjaxHandler
extends HttpServlet {
    private static Logger LOGGER = LoggerFactory.getLogger(MoAjaxHandler.class);
    private MoRESTAuthSettings settings;
    private I18nResolver i18nResolver;
    private MoRESTPluginHandler pluginHandler;
    private PluginLicenseManager pluginLicenseManager;
    private CrowdService crowdService;
    private MoAuditService moAuditService;
    private MoAuditTrackerService moAuditTrackerService;
    private AuditLogScheduler auditLogScheduler;

    public MoAjaxHandler(MoRESTAuthSettings settings, I18nResolver i18nResolver, MoRESTPluginHandler pluginHandler, CrowdService crowdService, PluginLicenseManager pluginLicenseManager, MoAuditService moAuditService, MoAuditTrackerService moAuditTrackerService, AuditLogScheduler auditLogScheduler) {
        this.settings = settings;
        this.i18nResolver = i18nResolver;
        this.pluginHandler = pluginHandler;
        this.crowdService = crowdService;
        this.pluginLicenseManager = pluginLicenseManager;
        this.moAuditService = moAuditService;
        this.moAuditTrackerService = moAuditTrackerService;
        this.auditLogScheduler = auditLogScheduler;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String action = req.getParameter("action");
        String referer = req.getHeader("referer");
        LOGGER.debug("inside get ajax");
        LOGGER.debug("Referer Header: {}", (Object)referer);
        LOGGER.info(String.valueOf(this.i18nResolver.getText("my.plugin.platform").equals("jira")));
        if (this.i18nResolver.getText("my.plugin.platform").equals("jira")) {
            PlatformUtils platformUtils = UtilDecisionHandler.getPlatFormUtils(this.i18nResolver.getText("my.plugin.platform"));
            URL jiraUrl = new URL(platformUtils.getBaseUrl());
            if (StringUtils.isBlank(referer)) {
                LOGGER.error("403. Access Denied. Referer cannot be blank.");
                resp.sendError(403, "Access Denied. Referer cannot be blank.");
                return;
            }
            URL refererUrl = new URL(referer);
            if (!StringUtils.equals(jiraUrl.getHost(), refererUrl.getHost())) {
                LOGGER.error("403. Access Denied.You are not allowed to use this endpoint.");
                resp.sendError(403, "Access Denied. You are not allowed to use this endpoint.");
            }
        }
        if (StringUtils.isBlank(action)) {
            action = "";
        }
        switch (action) {
            case "fetchUsers": {
                this.fetchUsers(req, resp);
                break;
            }
            case "fetchGroups": {
                this.fetchGroups(req, resp);
                break;
            }
            case "disablePopUp": {
                this.disablePopUp(req, resp);
                break;
            }
            case "clearLogs": {
                this.clearLogs(req, resp);
                break;
            }
            case "enableDebugLogs": {
                this.enableDebugLogs(req, resp);
                break;
            }
            case "enableAuditLogs": {
                this.enableAuditLogs(req, resp);
                break;
            }
            case "getLicenseValidity": {
                this.getLicenseValidity(req, resp);
                break;
            }
            case "enableSensitiveInformation": {
                this.hideSensitiveInformation(req, resp);
                break;
            }
            case "introspectionCall": {
                this.sendRequestToIntrospectionEndpoint(req, resp);
                break;
            }
            default: {
                resp.setContentType("text/html");
                LOGGER.error(" 405.The requested action is not allowed. Choose valid Action");
                resp.sendError(405, "The requested action is not allowed. Choose valid Action");
            }
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String action = req.getParameter("action");
        String referer = req.getHeader("referer");
        LOGGER.debug("inside post ajax");
        LOGGER.debug("Referer Header: {}", (Object)referer);
        LOGGER.info(String.valueOf(this.i18nResolver.getText("my.plugin.platform").equals("jira")));
        if (this.i18nResolver.getText("my.plugin.platform").equals("jira")) {
            PlatformUtils platformUtils = UtilDecisionHandler.getPlatFormUtils(this.i18nResolver.getText("my.plugin.platform"));
            URL jiraUrl = new URL(platformUtils.getBaseUrl());
            if (StringUtils.isBlank(referer)) {
                LOGGER.error("403. Access Denied. Referer cannot be blank.");
                resp.sendError(403, "Access Denied. Referer cannot be blank.");
                return;
            }
            URL refererUrl = new URL(referer);
            if (!StringUtils.equals(jiraUrl.getHost(), refererUrl.getHost())) {
                LOGGER.error("403. Access Denied.You are not allowed to use this endpoint.");
                resp.sendError(403, "Access Denied. You are not allowed to use this endpoint.");
            }
        }
        if (StringUtils.isBlank(action)) {
            action = "";
        }
        switch (action) {
            case "disableLicenseWarning": {
                this.disableLicenseWarning(req, resp);
                break;
            }
            default: {
                resp.setContentType("text/html");
                LOGGER.error(" 405.The requested action is not allowed. Choose valid Action");
                resp.sendError(405, "The requested action is not allowed. Choose valid Action");
            }
        }
    }

    private void sendRequestToIntrospectionEndpoint(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String url = request.getParameter("endpoint");
            String token = request.getParameter("token");
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Bearer " + token);
            headers.put("content-type", "application/json");
            headers.put("accept", "application/json");
            String result = MoHttpUtils.sendGetRequest(url, null, headers);
            this.sendSuccessFullResponse(result, response);
        }
        catch (MoPluginException e) {
            this.sendErrorResponse(e.getMessage(), response);
        }
        catch (Exception e) {
            this.sendErrorResponse("Unable to perform operation", response);
        }
    }

    private void clearLogs(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("inside Clear Logs");
        this.moAuditTrackerService.clearAllAuditLogs();
    }

    private void enableAuditLogs(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("inside enable audit logs");
        Boolean enableAuditLogs = BooleanUtils.toBoolean(req.getParameter("enableAuditLogs"));
        this.settings.setEnableAuditLogs(enableAuditLogs);
        if (enableAuditLogs.booleanValue()) {
            this.auditLogScheduler.schedule();
        } else {
            this.auditLogScheduler.unschedule();
        }
        this.sendSuccessFullResponse(JSONObject.quote("Changes Successful"), resp);
    }

    private void hideSensitiveInformation(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Inside Hide Sensitive Information");
        Boolean hideSensitiveInformation = BooleanUtils.toBoolean(request.getParameter("enableSensitiveInformation"));
        this.settings.setHideSensitiveInformation(hideSensitiveInformation);
        this.sendSuccessFullResponse(JSONObject.quote("Changes Successful"), response);
    }

    protected void getLicenseValidity(HttpServletRequest req, HttpServletResponse resp) {
        LOGGER.debug("inside get License Validity");
        try {
            String expiryDateString;
            PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            if (pluginLicense != null && !pluginLicense.isEvaluation() && (expiryDateString = pluginLicense.getExpiryDate().toString()).startsWith("some(") && expiryDateString.endsWith(")")) {
                expiryDateString = expiryDateString.substring(5);
                expiryDateString = expiryDateString.substring(0, expiryDateString.length() - 1);
                DateTime currentDate = new DateTime();
                LOGGER.debug("Current Date is " + currentDate);
                DateTime expiryDate = new DateTime(expiryDateString);
                LOGGER.debug("Expiry Date is " + expiryDate);
                if (!currentDate.isBefore(expiryDate) && !this.settings.getDisableLicenseExpiredWarning().booleanValue()) {
                    LOGGER.debug("License Expired!");
                    JSONObject licenceValidity = new JSONObject();
                    licenceValidity.put("validity", "expired");
                    this.sendSuccessFullResponse(licenceValidity.toString(), resp);
                } else if (currentDate.plusMonths(1).isAfter(expiryDate) && currentDate.isBefore(expiryDate) && !this.settings.getDisableLicenseExpiringWarning().booleanValue()) {
                    LOGGER.debug("License validity less than one month");
                    JSONObject licenceValidity = new JSONObject();
                    licenceValidity.put("validity", "expiring");
                    LOGGER.debug("licenseValidity = " + licenceValidity);
                    this.sendSuccessFullResponse(licenceValidity.toString(), resp);
                }
                if (currentDate.plusMonths(1).isBefore(expiryDate) && (this.settings.getDisableLicenseExpiredWarning().booleanValue() || this.settings.getDisableLicenseExpiringWarning().booleanValue())) {
                    this.settings.setDisableLicenseExpiringWarning(Boolean.FALSE);
                    this.settings.setDisableLicenseExpiredWarning(Boolean.FALSE);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while getting license validity");
        }
    }

    private void enableDebugLogs(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("inside enable debug logs");
        Boolean enableDebugLogs = BooleanUtils.toBoolean(req.getParameter("enableDebugLogs"));
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)"com.miniorange.rest.auth");
        if (enableDebugLogs.booleanValue()) {
            logger.setLevel(Level.DEBUG);
        } else {
            logger.setLevel(Level.INFO);
        }
        this.settings.setEnableDebugLogs(enableDebugLogs);
        this.sendSuccessFullResponse(JSONObject.quote("Changes Successful"), resp);
    }

    protected void disableLicenseWarning(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("Disabling License Warning");
        String licenseStatus = req.getParameter("licenseStatus");
        LOGGER.debug("licenseStatus = " + licenseStatus);
        if (StringUtils.equalsIgnoreCase(licenseStatus, "expiring")) {
            this.settings.setDisableLicenseExpiringWarning(Boolean.TRUE);
        } else if (StringUtils.equalsIgnoreCase(licenseStatus, "expired")) {
            this.settings.setDisableLicenseExpiredWarning(Boolean.TRUE);
        }
        this.sendSuccessFullResponse(JSONObject.quote("Changes Successful"), resp);
    }

    private void disablePopUp(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("inside disable POP UP");
        try {
            Boolean submitted = BooleanUtils.toBoolean(request.getParameter("submitted"));
            LOGGER.debug("submitted = " + submitted);
            if (submitted.booleanValue()) {
                this.settings.setDisablePopUp(true);
                this.sendSuccessFullResponse("success", response);
            }
        }
        catch (IOException e) {
            this.sendErrorResponse("failed with exception " + e, response);
        }
    }

    private void fetchUsers(HttpServletRequest req, HttpServletResponse resp) {
        try {
            String nameSearch = StringUtils.trim(req.getParameter("search"));
            Iterable<User> users = MoRESTPluginHandler.retrieveUsers(nameSearch);
            JsonObject data = new JsonObject();
            JsonArray resultArray = new JsonArray();
            for (User user : users) {
                HashMap<String, String> userResultsMap = new HashMap<String, String>();
                userResultsMap.put("id", user.getName());
                userResultsMap.put("text", user.getDisplayName() + " <" + user.getEmailAddress() + ">");
                Gson gson = new Gson();
                String userResults = gson.toJson(userResultsMap);
                resultArray.add(new JsonParser().parse(userResults));
            }
            data.add("results", (JsonElement)resultArray);
            this.sendSuccessFullResponse(data.toString(), resp);
        }
        catch (IOException e) {
            LOGGER.error("An error occurred while fetching groups ", (Throwable)e);
        }
    }

    private void fetchGroups(HttpServletRequest req, HttpServletResponse resp) {
        try {
            LOGGER.debug("Inside fetchGroups");
            String search = StringUtils.trim(req.getParameter("search"));
            if (StringUtils.equalsIgnoreCase(search, "*")) {
                search = "";
            }
            EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)search)).returningAtMost(10);
            LOGGER.debug("query =  " + query);
            Iterable groups = this.crowdService.search((Query)query);
            JSONObject data = new JSONObject();
            JSONArray resultArray = new JSONArray();
            for (Group groupName : groups) {
                HashMap<String, Object> groupResultsMap = new HashMap<String, Object>();
                groupResultsMap.put("id", groupName.getName());
                groupResultsMap.put("text", groupName.getName());
                resultArray.put(groupResultsMap);
            }
            data.put("results", resultArray);
            LOGGER.debug("resultArray = " + resultArray);
            this.sendSuccessFullResponse(data.toString(), resp);
        }
        catch (JSONException | IOException e) {
            LOGGER.error("An error occurred while fetching groups ", (Throwable)e);
        }
    }

    private void sendSuccessFullResponse(String result, HttpServletResponse resp) throws IOException {
        result = MoRESTUtils.sanitizeText(result);
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes(StandardCharsets.UTF_8));
            resp.getOutputStream().close();
        }
    }

    private void sendErrorResponse(String errorMessages, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(500);
        resp.getOutputStream().write(errorMessages.getBytes(StandardCharsets.UTF_8));
        resp.getOutputStream().close();
    }

    public MoRESTAuthSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoRESTAuthSettings settings) {
        this.settings = settings;
    }

    public MoRESTPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoRESTPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }
}

