/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.servlet;

import com.atlassian.sal.api.message.I18nResolver;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.dao.OAuthRequestParameters;
import com.miniorange.rest.auth.commons.handler.UtilDecisionHandler;
import com.miniorange.rest.auth.commons.util.PlatformUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchAccessToken
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(FetchAccessToken.class);
    private MoRESTAuthSettings settings;
    private final I18nResolver i18nResolver;

    public FetchAccessToken(MoRESTAuthSettings settings, I18nResolver i18nResolver) {
        this.settings = settings;
        this.i18nResolver = i18nResolver;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String action;
        switch (action = req.getParameter("action")) {
            case "configuration": {
                this.fetchTokenForConfiguration(req, resp);
                break;
            }
            case "use": {
                this.fetchTokenForUser(req, resp);
                break;
            }
            default: {
                resp.sendError(400);
            }
        }
    }

    public void fetchTokenForUser(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (StringUtils.isBlank(this.settings.getOAuthProvider())) {
            PrintWriter printWriter = resp.getWriter();
            resp.setContentType("text/html");
            printWriter.println("Please configure an OAuth provider to use this feature");
            printWriter.close();
            return;
        }
        StringBuilder authorizationEndpoint = new StringBuilder();
        authorizationEndpoint.append(this.settings.getAuthUrlForOAuthToken());
        if (authorizationEndpoint.indexOf("?") > -1) {
            if (!StringUtils.endsWith(authorizationEndpoint, "&")) {
                authorizationEndpoint.append("&");
            }
        } else {
            authorizationEndpoint.append("?");
        }
        String authEndpoint = this.settings.getAuthUrlForOAuthToken();
        String tokenEndpoint = this.settings.getTokenUrlForOAuthToken();
        if (StringUtils.isBlank(authEndpoint) || StringUtils.isBlank(tokenEndpoint)) {
            PrintWriter printWriter = resp.getWriter();
            resp.setContentType("text/html");
            printWriter.println("Missing auth/token endpoint");
            printWriter.close();
            return;
        }
        String clientId = this.settings.getClientId();
        String clientSecret = this.settings.getClientSecret();
        String scope = this.settings.getScope();
        String state = this.settings.getState();
        LOGGER.debug("clientId = " + clientId + " clientSecret = " + clientSecret + " scope = " + scope + " state = " + state);
        if (clientId.isEmpty() || clientSecret.isEmpty() || scope.isEmpty()) {
            PrintWriter printWriter = resp.getWriter();
            resp.setContentType("text/html");
            printWriter.println("Please enter valid clientId, clientSecret and scope");
            printWriter.close();
            return;
        }
        this.saveOauthParams(clientId, clientSecret, scope, state);
        String platform = this.i18nResolver.getText("my.plugin.platform");
        PlatformUtils platformUtils = UtilDecisionHandler.getPlatFormUtils(platform);
        String baseUrl = platformUtils.getBaseUrl();
        LOGGER.debug("baseUrl = " + baseUrl);
        String redirectURL = baseUrl + "/plugins/servlet/restauth/token";
        String responseType = "code";
        String includeGrantedScopes = "true";
        String accessType = "offline";
        authorizationEndpoint.append(OAuthRequestParameters.CLIENT_ID + "=").append(clientId).append("&" + OAuthRequestParameters.SCOPE + "=").append(URLEncoder.encode(scope, "UTF-8")).append("&" + OAuthRequestParameters.REDIRECT_URI + "=").append(URLEncoder.encode(redirectURL, "UTF-8")).append("&" + OAuthRequestParameters.STATE_PARAMETER + "=").append(URLEncoder.encode(state, "UTF-8")).append("&" + OAuthRequestParameters.RESPONSE_TYPE + "=").append(responseType).append("&" + OAuthRequestParameters.ACCESS_TYPE + "=").append(accessType).append("&" + OAuthRequestParameters.INCLUDE_GRANTED_SCOPES + "=").append(includeGrantedScopes);
        FetchAccessToken.httpRedirect(resp, authorizationEndpoint.toString());
    }

    public void fetchTokenForConfiguration(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        StringBuilder authorizationEndpoint = new StringBuilder();
        String authEndpoint = StringUtils.defaultIfBlank(req.getParameter("authEndpoint"), "");
        String tokenEndpoint = StringUtils.defaultIfBlank(req.getParameter("tokenEndpoint"), "");
        this.settings.setAuthUrlForOAuthToken(authEndpoint);
        this.settings.setTokenUrlForOAuthToken(tokenEndpoint);
        authorizationEndpoint.append(this.settings.getAuthUrlForOAuthToken());
        if (authorizationEndpoint.indexOf("?") > -1) {
            if (!StringUtils.endsWith(authorizationEndpoint, "&")) {
                authorizationEndpoint.append("&");
            }
        } else {
            authorizationEndpoint.append("?");
        }
        if (StringUtils.isBlank(authEndpoint) || StringUtils.isBlank(tokenEndpoint)) {
            PrintWriter printWriter = resp.getWriter();
            resp.setContentType("text/html");
            printWriter.println("Missing auth/token endpoint");
            printWriter.close();
            return;
        }
        String clientId = StringUtils.defaultIfBlank(req.getParameter("clientID"), "");
        String clientSecret = StringUtils.defaultIfBlank(req.getParameter("clientSecret"), "");
        String scope = StringUtils.defaultIfBlank(req.getParameter("scope"), "");
        String state = StringUtils.defaultIfBlank(req.getParameter("state"), "");
        LOGGER.debug("clientId = " + clientId + " clientSecret = " + clientSecret + " scope = " + scope + " state = " + state);
        if (clientId.isEmpty() || clientSecret.isEmpty() || scope.isEmpty()) {
            PrintWriter printWriter = resp.getWriter();
            resp.setContentType("text/html");
            printWriter.println("Please enter valid clientId, clientSecret and scope");
            printWriter.close();
            return;
        }
        this.saveOauthParams(clientId, clientSecret, scope, state);
        String platform = this.i18nResolver.getText("my.plugin.platform");
        PlatformUtils platformUtils = UtilDecisionHandler.getPlatFormUtils(platform);
        String baseUrl = platformUtils.getBaseUrl();
        LOGGER.debug("baseUrl = " + baseUrl);
        String redirectURL = baseUrl + "/plugins/servlet/restauth/token";
        String responseType = "code";
        String includeGrantedScopes = "true";
        String accessType = "offline";
        authorizationEndpoint.append(OAuthRequestParameters.CLIENT_ID + "=").append(clientId).append("&" + OAuthRequestParameters.SCOPE + "=").append(URLEncoder.encode(scope, "UTF-8")).append("&" + OAuthRequestParameters.REDIRECT_URI + "=").append(URLEncoder.encode(redirectURL, "UTF-8")).append("&" + OAuthRequestParameters.STATE_PARAMETER + "=").append(URLEncoder.encode(state, "UTF-8")).append("&" + OAuthRequestParameters.RESPONSE_TYPE + "=").append(responseType).append("&" + OAuthRequestParameters.ACCESS_TYPE + "=").append(accessType).append("&" + OAuthRequestParameters.INCLUDE_GRANTED_SCOPES + "=").append(includeGrantedScopes);
        FetchAccessToken.httpRedirect(resp, authorizationEndpoint.toString());
    }

    public void saveOauthParams(String clientID, String clientSecret, String scope, String state) {
        this.settings.setClientId(clientID);
        this.settings.setClientSecret(clientSecret);
        this.settings.setScope(scope);
        this.settings.setState(state);
    }

    public static void httpRedirect(HttpServletResponse response, String redirectUrl) throws IOException {
        LOGGER.debug("Redirecting user to " + redirectUrl);
        StringBuffer htmlStart = new StringBuffer("<html><head><script>window.location.href=\"" + redirectUrl + "\"</script></head><body>Please wait while we are redirecting you for authentication...</body></html>");
        response.sendRedirect(redirectUrl);
    }
}

