/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.servlet;

import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.message.I18nResolver;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.dao.OAuthRequestParameters;
import com.miniorange.rest.auth.commons.handler.UtilDecisionHandler;
import com.miniorange.rest.auth.commons.util.PlatformUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ProxySelector;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenCallback
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessTokenCallback.class);
    private final MoRESTAuthSettings settings;
    private final I18nResolver i18nResolver;

    public AccessTokenCallback(MoRESTAuthSettings settings, I18nResolver i18nResolver) {
        this.settings = settings;
        this.i18nResolver = i18nResolver;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String code = request.getParameter("code");
        String tokenResponse = this.getAccessToken(code);
        JSONObject accessTokenEndpointData = new JSONObject(tokenResponse);
        response.setContentType("text/html");
        PrintWriter writer = response.getWriter();
        StringBuffer htmlStart = new StringBuffer();
        if (tokenResponse.contains("error")) {
            htmlStart.append(tokenResponse);
            writer.println(htmlStart);
            writer.close();
        }
        if (StringUtils.isNotBlank(tokenResponse)) {
            try {
                if (accessTokenEndpointData.has("access_token")) {
                    String accessToken = accessTokenEndpointData.getString("access_token");
                    htmlStart = htmlStart.append("<script>var token=\"" + accessToken + "\";navigator.clipboard.writeText(token);</script><div style=\"display:flex; flex-direction:column;\"><div style=\"border:1px solid black; padding: 1em; text-align:center\"><h2>Access Token</h2></div><div id=\"access-token-div\" style=\"word-break: break-all; font-size:small; border:1px solid black; padding: 1em;\">" + accessToken + "</div><div style=\"color: green; border:1px solid black;text-align: center; padding: 1em;\"><h3>Access Token has been copied to Clipboard!</h3></div></div>");
                    writer.println(htmlStart);
                    writer.close();
                } else if (accessTokenEndpointData.has("id_token")) {
                    String accessToken = accessTokenEndpointData.getString("id_token");
                    writer.println(accessToken);
                    writer.close();
                }
            }
            catch (Exception e) {
                LOGGER.debug("Error occurred with exception = " + e);
                htmlStart.append("Unknown error occurred, check the logs for details");
                writer.println(htmlStart);
                writer.close();
            }
        }
    }

    public String getAccessToken(String code) {
        LOGGER.debug("Initiating process to get Access Token / JWT ID Token(OIDC)");
        String tokenEndpoint = this.settings.getTokenUrlForOAuthToken();
        String platform = this.i18nResolver.getText("my.plugin.platform");
        PlatformUtils platformUtils = UtilDecisionHandler.getPlatFormUtils(platform);
        String baseUrl = platformUtils.getBaseUrl();
        String redirectURL = baseUrl + "/plugins/servlet/restauth/token";
        String contentType = "application/x-www-form-urlencoded";
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Accept", "application/json");
        ArrayList<NameValuePair> postParameters = new ArrayList<NameValuePair>();
        postParameters.add((NameValuePair)new BasicNameValuePair(OAuthRequestParameters.REDIRECT_URI, redirectURL));
        postParameters.add((NameValuePair)new BasicNameValuePair(OAuthRequestParameters.GRANT_TYPE, "authorization_code"));
        postParameters.add((NameValuePair)new BasicNameValuePair(OAuthRequestParameters.CODE, code));
        String sendRequestIn = "HttpBody";
        if (StringUtils.equalsIgnoreCase(sendRequestIn, "HttpBody")) {
            LOGGER.debug("Sending client credentials in Body");
            postParameters.add((NameValuePair)new BasicNameValuePair(OAuthRequestParameters.CLIENT_ID, this.settings.getClientId()));
            postParameters.add((NameValuePair)new BasicNameValuePair(OAuthRequestParameters.CLIENT_SECRET, this.settings.getClientSecret()));
        } else {
            LOGGER.debug("Sending client credentials in Header");
            String authString = this.settings.getClientId() + ":" + this.settings.getClientSecret();
            LOGGER.debug("ACCESS AuthorizationValue: " + authString);
            byte[] authEncBytes = Base64.getEncoder().encode(authString.getBytes(StandardCharsets.UTF_8));
            String authStringEnc = new String(authEncBytes);
            String authorizationValue = "Basic " + authStringEnc;
            header.put("Authorization", authorizationValue);
        }
        return AccessTokenCallback.preparePostRequestAndExecute(tokenEndpoint, header, postParameters, contentType);
    }

    private static CloseableHttpClient getHttpClient() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        HttpClientBuilder builder = HttpClientBuilder.create();
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        }).build();
        SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionFactory);
        Registry registry = RegistryBuilder.create().register("https", (Object)sslConnectionFactory).register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
        BasicHttpClientConnectionManager ccm = new BasicHttpClientConnectionManager((Lookup)registry);
        builder.setConnectionManager((HttpClientConnectionManager)ccm);
        SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        CloseableHttpClient httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).setConnectionManager((HttpClientConnectionManager)ccm).build();
        return httpclient;
    }

    public static String executePostRequest(CloseableHttpClient httpClient, HttpPost postRequest) {
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)postRequest);
            LOGGER.debug("Response for HTTP Request: " + response.toString() + " and Status Code: " + response.getStatusLine().getStatusCode());
            if (response.getEntity() != null) {
                String output;
                LOGGER.debug("Response Entity found. Reading Response payload.");
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                String status = "";
                while ((output = br.readLine()) != null) {
                    status = status + output;
                }
                LOGGER.debug("Response payload status : " + status);
                httpClient.close();
                return status;
            }
            LOGGER.debug("Response Entity NOT found. Returning EMPTY string.");
            httpClient.close();
            return "";
        }
        catch (Exception e) {
            LOGGER.error("An exception occured while executing the Post Request ", (Throwable)e);
            return "FAILED";
        }
    }

    public static String preparePostRequestAndExecute(String endPoint, HashMap headers, List<NameValuePair> postParameter, String contentType) {
        try {
            LOGGER.debug("Executing POST Request to endpoint : " + endPoint);
            CloseableHttpClient httpClient = AccessTokenCallback.getHttpClient();
            HttpPost httpPost = new HttpPost(endPoint);
            if (headers != null) {
                Iterator iterator = headers.entrySet().iterator();
                if (!headers.isEmpty()) {
                    while (iterator.hasNext()) {
                        Map.Entry pairs = iterator.next();
                        httpPost.setHeader(pairs.getKey().toString(), pairs.getValue().toString());
                    }
                }
            }
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(postParameter);
            entity.setContentType(contentType);
            httpPost.setEntity((HttpEntity)entity);
            return AccessTokenCallback.executePostRequest(httpClient, httpPost);
        }
        catch (Exception e) {
            LOGGER.error("An error occured while preparing Http Post Request ", (Throwable)e);
            return null;
        }
    }
}

