/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.scheduler;

import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.miniorange.rest.auth.commons.MoAuditTrackerService;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.handler.MoRESTPluginHandler;
import com.miniorange.rest.auth.commons.scheduler.AuditLogSchedulerTask;
import java.time.Instant;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogScheduler
implements LifecycleAware {
    private static final JobId JOB_ID = JobId.of((String)AuditLogSchedulerTask.class.getName());
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)AuditLogSchedulerTask.class.getName());
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditLogScheduler.class);
    long refreshIntervalInMiliseconds = 86400000L;
    private SchedulerService schedulerService;
    private MoAuditTrackerService moAuditTrackerService;
    private MoRESTAuthSettings moRESTAuthSettings;
    private MoRESTPluginHandler moRESTPluginHandler;

    public AuditLogScheduler(SchedulerService schedulerService, MoAuditTrackerService moAuditTrackerService, MoRESTAuthSettings moRESTAuthSettings, MoRESTPluginHandler moRESTPluginHandler) {
        this.schedulerService = schedulerService;
        this.moAuditTrackerService = moAuditTrackerService;
        this.moRESTAuthSettings = moRESTAuthSettings;
        this.moRESTPluginHandler = moRESTPluginHandler;
    }

    public void schedule() {
        LOGGER.info("Scheduling the job for excess logs deletion");
        try {
            this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)new AuditLogSchedulerTask(this.moRESTPluginHandler));
            Date firstRun = Date.from(Instant.now().plusMillis(this.refreshIntervalInMiliseconds));
            JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)this.refreshIntervalInMiliseconds, (Date)Date.from(Instant.now())));
            this.schedulerService.scheduleJob(JOB_ID, jobConfig);
            LOGGER.debug("Job for Auto deletion of logs scheduled successfully");
        }
        catch (Exception e) {
            LOGGER.error("An Exception occurred while scheduling the Job for Auto Deletion of logs");
        }
    }

    public void unschedule() {
        LOGGER.debug("Unschedule called");
        this.schedulerService.unscheduleJob(JOB_ID);
    }

    public void onStart() {
        LOGGER.debug("On start called");
        try {
            if (this.moRESTAuthSettings.isAuditLogsMigrationHandled().booleanValue()) {
                LOGGER.debug("Scheduling the job of auto deletion of logs on server initialization");
                this.schedule();
            }
        }
        catch (Exception e) {
            LOGGER.error("An Exception occurred while Scheduling the job for Auto Deletion of logs ");
        }
    }

    public void onStop() {
        LOGGER.debug("On stop called");
        this.unschedule();
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }
}

