/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.handler;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.miniorange.rest.auth.commons.MoApiKeysService;
import com.miniorange.rest.auth.commons.MoAuditService;
import com.miniorange.rest.auth.commons.MoAuditTrackerService;
import com.miniorange.rest.auth.commons.MoUserDataService;
import com.miniorange.rest.auth.commons.dao.MoRESTAuthSettings;
import com.miniorange.rest.auth.commons.dao.OAuthProviderTokenEndpoints;
import com.miniorange.rest.auth.commons.dao.OauthProviderAuthorizationEndpoints;
import com.miniorange.rest.auth.commons.dto.ApiKey;
import com.miniorange.rest.auth.commons.dto.AuditLog;
import com.miniorange.rest.auth.commons.entity.MoApiKeysEntity;
import com.miniorange.rest.auth.commons.entity.MoUserdataEntity;
import com.miniorange.rest.auth.commons.handler.UtilDecisionHandler;
import com.miniorange.rest.auth.commons.util.MoHashUtils;
import com.miniorange.rest.auth.commons.util.MoOAuthUtils;
import com.miniorange.rest.auth.commons.util.MoPluginConstants;
import com.miniorange.rest.auth.commons.util.MoRESTUtils;
import com.miniorange.rest.auth.commons.util.PlatformUtils;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.util.SubnetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoRESTPluginHandler {
    private static Logger LOGGER = LoggerFactory.getLogger(MoRESTPluginHandler.class);
    private MoRESTAuthSettings settings;
    private static WebSudoManager webSudoManager;
    private static CrowdService crowdService;
    private MoUserdataEntity moUserdataEntity;
    private MoApiKeysEntity apiKeyEntity;
    private MoUserDataService moUserDataService;
    private MoApiKeysService apiKeysService;
    private MoApiKeysEntity[] apiKeysEntities;
    private Map<String, List<String>> apiKeys = new HashMap<String, List<String>>();
    private MoAuditService moAuditService;
    private TransactionTemplate transactionTemplate;
    private MoAuditTrackerService moAuditTrackerService;

    public MoRESTPluginHandler(MoRESTAuthSettings settings, WebSudoManager webSudoManager, CrowdService crowdService, MoUserDataService userDataService, MoApiKeysService moApiKeysService, MoAuditService moAuditService, TransactionTemplate transactionTemplate, MoAuditTrackerService moAuditTrackerService) {
        this.settings = settings;
        MoRESTPluginHandler.webSudoManager = webSudoManager;
        MoRESTPluginHandler.crowdService = crowdService;
        this.moUserDataService = userDataService;
        this.apiKeysService = moApiKeysService;
        this.moAuditService = moAuditService;
        this.transactionTemplate = transactionTemplate;
        this.moAuditTrackerService = moAuditTrackerService;
    }

    public void saveOauthProviderConfig(String oauthProvider, String clientID, String clientSecret, String scope, String state, String usernameAttribute) {
        this.settings.setOAuthProvider(oauthProvider);
        this.settings.setUsernameAttribute(usernameAttribute);
        this.settings.setClientId(clientID);
        this.settings.setClientSecret(clientSecret);
        this.settings.setScope(scope);
        this.settings.setState(state);
    }

    public void saveGlobalSettings(Boolean enableAuthentication, Boolean disableBasicAuthentication, Boolean allowUsersToCreateTokens, Boolean allowPATTokens) {
        this.settings.setEnableAuthentication(enableAuthentication);
        this.settings.setDisableBasicAuthentication(disableBasicAuthentication);
        this.settings.setAllowUsersToCreateTokens(allowUsersToCreateTokens);
        this.settings.setAllowPATTokens(allowPATTokens);
    }

    public void saveTroubleShootSettings(Boolean enableDebugLogs) {
        this.settings.setEnableDebugLogs(enableDebugLogs);
    }

    public void saveUserRestrictionSettings(Boolean restrictGroupEnabled, Boolean readOnlyGroupsEnabled, String group, List<String> groups, List<String> readOnlyGroupsList, Boolean restrictTokenGenerationGroupEnabled, List<String> restrictTokenGenerationGroupsList) {
        this.settings.setRestrictGroupEnabled(restrictGroupEnabled);
        this.settings.setGroup(group);
        this.settings.setGroups(groups);
        this.settings.setReadOnlyGroups(readOnlyGroupsList);
        this.settings.setReadOnlyGroupsEnabled(readOnlyGroupsEnabled);
        this.settings.setRestrictTokenGenerationGroupEnabled(restrictTokenGenerationGroupEnabled);
        this.settings.setRestrictTokenGenerationGroups(restrictTokenGenerationGroupsList);
    }

    public void saveUserRestrictionSettings(Boolean restrictGroupEnabled, String group, List<String> groups) {
        this.settings.setRestrictGroupEnabled(restrictGroupEnabled);
        this.settings.setGroup(group);
        this.settings.setGroups(groups);
    }

    public void saveKeyCloakConfig(String keycloakHost, String keycloakRealm) {
        this.settings.setKeycloakHost(keycloakHost);
        this.settings.setKeycloakRealm(keycloakRealm);
        String authUrl = OauthProviderAuthorizationEndpoints.formKeycloakAuthorizationEndpoint(keycloakHost, keycloakRealm);
        String tokenUrl = OAuthProviderTokenEndpoints.formKeycloakTokenEndpoint(keycloakHost, keycloakRealm);
        this.settings.setAuthUrlForOAuthToken(authUrl);
        this.settings.setTokenUrlForOAuthToken(tokenUrl);
        String introspectionEndpoint = MoRESTUtils.constructKeyCloakEndpoint(keycloakHost, keycloakRealm);
        this.settings.setIntrospectionEndpoint(introspectionEndpoint);
    }

    public void saveAwsCognitoConfig(String domainName) {
        this.settings.setAwsCognitoDomainNam(domainName);
        String introspectionEndpoint = MoRESTUtils.constructAWSCognitoEndpoint(domainName);
        String authUrl = OauthProviderAuthorizationEndpoints.formAWSCognitoAuthorizationEndpoint(domainName);
        String tokenUrl = OAuthProviderTokenEndpoints.formAWSCognitoTokenEndpoint(domainName);
        this.settings.setAuthUrlForOAuthToken(authUrl);
        this.settings.setTokenUrlForOAuthToken(tokenUrl);
        this.settings.setIntrospectionEndpoint(introspectionEndpoint);
    }

    public void saveOkta(String domainName) {
        this.settings.setOktaDomainNam(domainName);
        String introspectionEndpoint = MoRESTUtils.constructOktaEndpoint(domainName);
        this.settings.setIntrospectionEndpoint(introspectionEndpoint);
        String authUrl = OauthProviderAuthorizationEndpoints.formOktaAuthorizationEndpoint(domainName);
        String tokenUrl = OAuthProviderTokenEndpoints.formOktaTokenEndpoint(domainName);
        this.settings.setAuthUrlForOAuthToken(authUrl);
        this.settings.setTokenUrlForOAuthToken(tokenUrl);
    }

    public void saveAzureConfig(String azureAdTenantID) {
        String introspectionEndpoint = MoPluginConstants.EndPointConstants.AZURE_USERINFO_ENDPOINT.getValue();
        this.settings.setAzureADTenantID(azureAdTenantID);
        String azureAdAuthUrl = OauthProviderAuthorizationEndpoints.formAzureADAuthorizationEndpoint(azureAdTenantID);
        String azureAdTokenUrl = OAuthProviderTokenEndpoints.formAzureADTokenEndpoint(azureAdTenantID);
        this.settings.setAuthUrlForOAuthToken(azureAdAuthUrl);
        this.settings.setTokenUrlForOAuthToken(azureAdTokenUrl);
        this.settings.setIntrospectionEndpoint(introspectionEndpoint);
    }

    public void saveRestrictAPIs(String apiUrl) {
        this.settings.setPublicApiUrls(apiUrl);
    }

    public void deleteApiUrl(String id) {
        this.settings.deleteApiUrl(id);
    }

    public void deteteByPassApiUrl(String id) {
        this.settings.deleteByPassUrl(id);
    }

    public void saveGithubConfig() {
        String introspectionEndpoint = MoPluginConstants.EndPointConstants.GITHUB_USERINFO_ENDPOINT.getValue();
        this.settings.setIntrospectionEndpoint(introspectionEndpoint);
        String authUrl = OauthProviderAuthorizationEndpoints.formGitHubAuthorizationEndpoint();
        String TokenUrl = OAuthProviderTokenEndpoints.formGitHubTokenEndpoint();
        this.settings.setAuthUrlForOAuthToken(authUrl);
        this.settings.setTokenUrlForOAuthToken(TokenUrl);
    }

    public void saveMeetupConfig() {
        String introspectionEndpoint = MoPluginConstants.EndPointConstants.MEETUP_USERINFO_ENDPOINT.getValue();
        this.settings.setIntrospectionEndpoint(introspectionEndpoint);
        String authUrl = OauthProviderAuthorizationEndpoints.formMeetupAuthorizationEndpoint();
        String tokenUrl = OAuthProviderTokenEndpoints.formMeetupTokenEndpoint();
        this.settings.setAuthUrlForOAuthToken(authUrl);
        this.settings.setTokenUrlForOAuthToken(tokenUrl);
    }

    public void saveSlackConfig() {
        String introspectionEndpoint = MoPluginConstants.EndPointConstants.SLACK_USERINFO_ENDPOINT.getValue();
        String authUrl = OauthProviderAuthorizationEndpoints.formSlackAuthorizationEndpoint();
        String tokenUrl = OAuthProviderTokenEndpoints.formSlackTokenEndpoint();
        this.settings.setAuthUrlForOAuthToken(authUrl);
        this.settings.setTokenUrlForOAuthToken(tokenUrl);
        this.settings.setIntrospectionEndpoint(introspectionEndpoint);
    }

    public void saveSalesforceConfig(String salesforceDomain) {
        this.settings.setSalesforceDomain(salesforceDomain);
        String introspectionEndpoint = MoRESTUtils.constructSalesforceEndpoint(salesforceDomain);
        String authUrl = OauthProviderAuthorizationEndpoints.formSalesforceAuthorizationEndpoint();
        String tokenUrl = OAuthProviderTokenEndpoints.formSalesforceTokenEndpoint();
        this.settings.setAuthUrlForOAuthToken(authUrl);
        this.settings.setTokenUrlForOAuthToken(authUrl);
    }

    public void saveFacebookConfig() {
        String introspectionEndpoint = MoPluginConstants.EndPointConstants.FACEBOOK_USER_INFO_ENDPOINT.getValue();
        this.settings.setIntrospectionEndpoint(introspectionEndpoint);
        String authUrl = OauthProviderAuthorizationEndpoints.formFacebookAuthorizationEndpoint();
        String tokenUrl = OAuthProviderTokenEndpoints.formFacebookTokenEndpoint();
        this.settings.setAuthUrlForOAuthToken(authUrl);
        this.settings.setTokenUrlForOAuthToken(tokenUrl);
    }

    public void saveDiscordConfig() {
        String introspectionEndpoint = MoPluginConstants.EndPointConstants.DISCORD_USER_INFO_ENDPOINT.getValue();
        this.settings.setIntrospectionEndpoint(introspectionEndpoint);
        String authUrl = OauthProviderAuthorizationEndpoints.formDiscordAuthorizationEndpoint();
        String tokenUrl = OAuthProviderTokenEndpoints.formDiscordTokenEndpoint();
        this.settings.setAuthUrlForOAuthToken(authUrl);
        this.settings.setTokenUrlForOAuthToken(tokenUrl);
    }

    public void saveGoogleConfig() {
        String introspectionEndpoint = MoPluginConstants.EndPointConstants.GOOGLE_USER_INFO_ENDPOINT.getValue();
        String authUrl = OauthProviderAuthorizationEndpoints.formGoogleAuthorizationEndpoint();
        String tokenUrl = OAuthProviderTokenEndpoints.formGoogleTokenEndpoint();
        this.settings.setAuthUrlForOAuthToken(authUrl);
        this.settings.setTokenUrlForOAuthToken(tokenUrl);
        this.settings.setIntrospectionEndpoint(introspectionEndpoint);
    }

    public void saveGitlabConfig() {
        String introspectionEndpoint = MoPluginConstants.EndPointConstants.GITLAB_USER_INFO_ENDPOINT.getValue();
        String authUrl = OauthProviderAuthorizationEndpoints.formGitlabAuthorizationEndpoint();
        String tokenUrl = OAuthProviderTokenEndpoints.formGitlabTokenEndpoint();
        this.settings.setAuthUrlForOAuthToken(authUrl);
        this.settings.setTokenUrlForOAuthToken(tokenUrl);
        this.settings.setIntrospectionEndpoint(introspectionEndpoint);
    }

    public void saveCustomConfig(String introspectionEndpoint, String authEndpoint, String tokenEndpoint) {
        this.settings.setIntrospectionEndpoint(introspectionEndpoint);
        this.settings.setAuthUrlForOAuthToken(authEndpoint);
        this.settings.setTokenUrlForOAuthToken(tokenEndpoint);
    }

    public Boolean isConfigured() {
        String oauthProvider = this.settings.getOauthTokenType();
        return StringUtils.isNotBlank(oauthProvider);
    }

    public void saveJwtConfig(String publicKey) {
        this.settings.setPublicKey(publicKey);
    }

    public boolean isAuthenticationEnabled() {
        return this.settings.getEnableAuthentication();
    }

    public void saveClientCredentialSettings(String oauthProvider, String introspectionUrl, String redirectUri, String clientId, String clientSecret, String username, String scope) {
        this.settings.setClientCredProviderName(oauthProvider);
        this.settings.setClientCredIntrospectionEndpoint(introspectionUrl);
        this.settings.setClientCredRedirectUri(redirectUri);
        this.settings.setClientCredClientId(clientId);
        this.settings.setClientCredClientSecret(clientSecret);
        this.settings.setServiceAccountUsername(username);
        this.settings.setClientCredScope(scope);
    }

    public void saveJwtSettings(String providerName, String introspectionUrl, String clientId, String publicKey, String username) {
        this.settings.setJwtProviderName(providerName);
        this.settings.setJwtIntrospectionEndpoint(introspectionUrl);
        this.settings.setJwtClientId(clientId);
        this.settings.setJwtPublicKey(publicKey);
        this.settings.setJwtUsername(username);
    }

    public String getUsernameInResponse(String userInfoResponse) {
        JsonParser parser = new JsonParser();
        JsonObject userInfoData = parser.parse(userInfoResponse).getAsJsonObject();
        HashMap<String, Object> userDetailsMap = new HashMap<String, Object>();
        HashMap<String, String> userInfoMap = MoOAuthUtils.copyToStringValueMap(MoOAuthUtils.toMapObjects(userInfoData, userDetailsMap));
        LOGGER.debug("User Info Map: {}", userInfoMap);
        String usernameAttribute = this.settings.getUsernameAttribute();
        return userInfoMap.get(usernameAttribute);
    }

    public void deleteLogs() {
        int pastDaysConfigured = Integer.valueOf(this.settings.getPastDaysConfigured());
        int numberOfEntries = Integer.valueOf(this.settings.getNumberOfEntries());
        this.moAuditTrackerService.deleteExcessAuditLogs(pastDaysConfigured, numberOfEntries);
        this.deleteAuditLogsPastDays();
        this.settings.setSchedulerStatus(true);
        LOGGER.debug("Successfully deleted logs");
    }

    public static void enforceWebsudoProtection(HttpServletRequest request, HttpServletResponse response) {
        try {
            webSudoManager.willExecuteWebSudoRequest(request);
        }
        catch (WebSudoSessionException w) {
            LOGGER.debug("Enforcing Websudo Protection");
            webSudoManager.enforceWebSudoProtection(request, response);
        }
    }

    public ApiKey saveApiKey(String name, String username, String keyType, String expiryTime, String expiry_interval, String expiry_interval_count, String platform, Boolean sendTokenViaEmail) {
        LOGGER.debug("inside saveApiKey");
        String key = this.generateRandomAlphaNumericKey(24);
        PlatformUtils platformUtils = UtilDecisionHandler.getPlatFormUtils(platform);
        String prefix = StringUtils.equals(username, MoPluginConstants.ApiConstants.UNIVERSAL_API_KEYS.getKey()) ? "mo-uni-" : "mo-api-";
        LOGGER.debug("prefix is: " + prefix);
        StringBuilder keyBuilder = new StringBuilder(prefix);
        key = keyBuilder.append(key).toString();
        LOGGER.debug("Saving key = " + key);
        byte[] salt = this.settings.getSalt(username);
        String hashedKey = MoHashUtils.hash(key, salt);
        String encodedString = Base64.getEncoder().encodeToString(hashedKey.getBytes());
        if (prefix == "mo-api-") {
            LOGGER.debug("inside mo-api");
            this.createApiKeyInstance(name, encodedString, expiryTime, expiry_interval, expiry_interval_count, username);
            if (StringUtils.isNotBlank(keyType) && StringUtils.equals(keyType, "bearer")) {
                String encodedKey = username + ":" + key;
                key = org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])encodedKey.getBytes());
            }
            if (sendTokenViaEmail.booleanValue()) {
                platformUtils.sendAPIKeyByEmail(key, username);
            }
            ApiKey apiKey = new ApiKey();
            apiKey.setName(name);
            apiKey.setKey(key);
            return apiKey;
        }
        LOGGER.debug("inside mo-uni");
        ApiKey apiKey = this.createApiKeyInstanceForUniversal(name, hashedKey, expiryTime, expiry_interval, expiry_interval_count);
        this.settings.setApiKey(apiKey);
        Map<String, String> apiKeys = this.settings.getApiKeys(username);
        apiKeys.put(apiKey.getId(), apiKey.getKey());
        this.settings.setApiKeys(apiKeys, username);
        if (StringUtils.isNotBlank(keyType) && StringUtils.equals(keyType, "bearer")) {
            String encodedKey = username + ":" + key;
            key = org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])encodedKey.getBytes());
        }
        apiKey.setKey(key);
        return apiKey;
    }

    private void createApiKeyInstance(String name, String hashedKey, String expiryTime, String expiry_interval, String expiry_interval_count, String username) {
        ApiKey apiKey = new ApiKey();
        this.moUserdataEntity = this.moUserDataService.findByUsername(username);
        if (this.moUserdataEntity == null) {
            this.moUserdataEntity = this.moUserDataService.addUserDetails(username);
        }
        UUID id = UUID.randomUUID();
        Calendar now = Calendar.getInstance();
        Date expiryDate = this.calculateExpiryDate(now.getTime(), expiryTime, expiry_interval, expiry_interval_count);
        LOGGER.debug("the expiryDate is " + expiryDate);
        if (expiryDate != null) {
            this.apiKeysService.addApiKeys(this.moUserdataEntity, now.getTime().toString(), hashedKey, name, id.toString(), expiryDate.toString());
        } else {
            this.apiKeysService.addApiKeys(this.moUserdataEntity, now.getTime().toString(), hashedKey, name, id.toString(), "");
        }
    }

    private ApiKey createApiKeyInstanceForUniversal(String name, String hashedKey, String expiryTime, String expiry_interval, String expiry_interval_count) {
        ApiKey apiKey = new ApiKey();
        UUID id = UUID.randomUUID();
        Calendar now = Calendar.getInstance();
        apiKey.setId(id.toString());
        apiKey.setName(name);
        apiKey.setCreationDate(now.getTime());
        apiKey.setKey(hashedKey);
        Date expiryDate = this.calculateExpiryDate(now.getTime(), expiryTime, expiry_interval, expiry_interval_count);
        if (expiryDate != null) {
            apiKey.setExpiryDate(expiryDate);
        }
        return apiKey;
    }

    public Date calculateExpiryDate(Date currentDate, String expiryTime, String expiry_interval, String expiry_interval_count) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(currentDate);
        if (StringUtils.isBlank(expiryTime)) {
            return null;
        }
        cal.add(Integer.parseInt(expiry_interval), Integer.parseInt(expiry_interval_count));
        return cal.getTime();
    }

    public String generateRandomAlphaNumericKey(int bytes) {
        return RandomStringUtils.random(bytes, true, true);
    }

    public List<ApiKey> getApiKeys(String username) {
        Map<String, String> keys = this.settings.getApiKeys(username);
        ArrayList<ApiKey> apiKeys = new ArrayList<ApiKey>();
        ApiKey apiKey = null;
        for (String key : keys.keySet()) {
            apiKey = this.settings.getApiKey(key);
            if (apiKey == null) continue;
            apiKeys.add(apiKey);
        }
        return apiKeys;
    }

    public Map<String, List<String>> getApiKeysAfterMigration(String username) {
        HashMap<String, List<String>> apiKeys = new HashMap<String, List<String>>();
        this.moUserdataEntity = this.moUserDataService.findByUsername(username);
        if (this.moUserdataEntity == null) {
            LOGGER.debug("User wtih username" + username + "has not configured any api token");
            return apiKeys;
        }
        for (MoApiKeysEntity apiKey : this.apiKeysEntities = this.moUserdataEntity.getApiKeys()) {
            apiKeys.put(apiKey.getApiKeyId(), new ArrayList());
            ((List)apiKeys.get(apiKey.getApiKeyId())).add(apiKey.getApiKeyId());
            ((List)apiKeys.get(apiKey.getApiKeyId())).add(apiKey.getName());
            ((List)apiKeys.get(apiKey.getApiKeyId())).add(apiKey.getCreationDate());
            ((List)apiKeys.get(apiKey.getApiKeyId())).add(apiKey.getExpiryDate());
            ((List)apiKeys.get(apiKey.getApiKeyId())).add(apiKey.getKey());
            ((List)apiKeys.get(apiKey.getApiKeyId())).add(apiKey.getLastAccessedTime());
            ((List)apiKeys.get(apiKey.getApiKeyId())).add(apiKey.getWindowStart());
            ((List)apiKeys.get(apiKey.getApiKeyId())).add(apiKey.getWindowSize());
        }
        return apiKeys;
    }

    public Set<String> getApiKeyIds(String username) {
        return this.settings.getApiKeys(username).keySet();
    }

    public Boolean deleteApiKey(String id, String username, boolean isUniversal) {
        this.settings.deleteApiKey(id);
        username = isUniversal ? MoPluginConstants.ApiConstants.UNIVERSAL_API_KEYS.getKey() : username;
        Map<String, String> apiKeys = this.settings.getApiKeys(username);
        apiKeys.remove(id);
        this.settings.setApiKeys(apiKeys, username);
        return true;
    }

    public Boolean updateApiKey(String id, String windowStart, String windowCount) {
        boolean updateApiKey = this.apiKeysService.updateApiKey(id, windowStart, windowCount);
        return updateApiKey;
    }

    public Boolean updateUniKey(String id, String windowStart, String windowCount) {
        try {
            ApiKey key = this.settings.getApiKey(id);
            key.setLastAccessedTime(new Date());
            if (windowStart != null && windowCount != null) {
                key.setWindowStart(windowStart);
                key.setWindowSize(windowCount);
            }
            this.settings.setApiKey(key);
            LOGGER.debug("Updated Last Accessed Timestamp for the Universal Key");
            return true;
        }
        catch (Exception e) {
            LOGGER.error("An Exception occurred while updating Last accessed Timestamp" + e.getMessage());
            return false;
        }
    }

    public static Iterable<User> retrieveUsers(String name) {
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)name)).returningAtMost(10);
        LOGGER.debug("query =  {}", (Object)query);
        Iterable users = crowdService.search((Query)query);
        return users;
    }

    public void saveBasicAuthConfig(Boolean enableBasicAuth, String OktaDomain) {
        this.settings.setEnableBasicAuth(enableBasicAuth);
    }

    public void saveMaxExpiry(boolean setMaxExpiryTime, String maximumExpiryCount, String maximumExpiryInterval) {
        this.settings.setMaxExpiryTime(setMaxExpiryTime);
        this.settings.setMaximumExpiryCount(maximumExpiryCount);
        this.settings.setMaximumExpiryInterval(maximumExpiryInterval);
    }

    public void saveMaxTokensPerUser(boolean setMaxToken, String maximumTokenCount) {
        this.settings.setMaxToken(setMaxToken);
        this.settings.setMaximumTokenCount(maximumTokenCount);
    }

    public void saveIPRestrictionSettings(Boolean restrictIPEnabled, List<String> restrictedIP) {
        this.settings.setRestrictIPEnabled(restrictIPEnabled);
        this.settings.setRestrictedIP(restrictedIP);
    }

    public void saveRateLimiting(boolean enableRateLimiting, String numberOfRequests, String intervalCount, String interval) {
        this.settings.setEnableRateLimitng(enableRateLimiting);
        this.settings.setNumberOfRequest(numberOfRequests);
        this.settings.setRateLimitingIntervalCount(intervalCount);
        this.settings.setRateLimitingInterval(interval);
        switch (interval) {
            case "1": {
                this.settings.setRateLimitingIntervalInSeconds(String.valueOf(Integer.parseInt(intervalCount) * 60));
                break;
            }
            case "2": {
                this.settings.setRateLimitingIntervalInSeconds(String.valueOf(Integer.parseInt(intervalCount) * 60 * 60));
                break;
            }
            default: {
                this.settings.setRateLimitingIntervalInSeconds(String.valueOf(Integer.parseInt(intervalCount) * 60));
            }
        }
    }

    public String getMaximumExpiryInterval(String maximumExpiryInterval) {
        switch (maximumExpiryInterval) {
            case "1": {
                return "Years";
            }
            case "2": {
                return "Months";
            }
        }
        return "Days";
    }

    public void deleteAuditLogsPastDays() {
        List<String> auditLogsList = this.settings.getAuditLogsList();
        ArrayList<String> updatedAuditLogList = new ArrayList<String>();
        long getLogsPastDays = 2L;
        long logsPastDaysInMilliSecs = getLogsPastDays * 86400000L;
        Calendar calendar = Calendar.getInstance();
        long currentTime = calendar.getTimeInMillis();
        long diffInTimeFromCurrentDate = currentTime - logsPastDaysInMilliSecs;
        Date pastDate = new Date(diffInTimeFromCurrentDate);
        Gson gson = new Gson();
        for (String auditLog : auditLogsList) {
            AuditLog auditLogEntry = (AuditLog)gson.fromJson(auditLog, AuditLog.class);
            int dateComparison = auditLogEntry.getDate().compareTo(pastDate);
            if (dateComparison < 0) continue;
            LOGGER.debug("Audit Log Entry date is found ahead or at par with the past date,hence not deleting that");
            updatedAuditLogList.add(auditLog);
        }
        this.settings.setAuditLogsList(updatedAuditLogList);
    }

    public void saveAuditLogs(final String username, final String ipAddress, final String apiUrl, final String requestType, final String status) {
        if (!this.settings.getEnableAuditLogs().booleanValue()) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        long timeInMilliSeconds = calendar.getTimeInMillis();
        final Date date = new Date(timeInMilliSeconds);
        LOGGER.debug("Saving audit logs");
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                MoRESTPluginHandler.this.moAuditTrackerService.addAuditEntries(username, ipAddress, requestType, apiUrl, date, status);
                return null;
            }
        });
    }

    public boolean verifyIp(HttpServletRequest request) {
        List<String> ipAddressList = MoRESTPluginHandler.getCurrentIpAddresses(request);
        LOGGER.debug("ipAddress found = " + ipAddressList.toString());
        if (this.isInStoredIpAddress(ipAddressList, this.settings.getRestrictedIP()).booleanValue()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static List<String> getCurrentIpAddresses(HttpServletRequest request) {
        ArrayList<String> remoteAddressList = new ArrayList<String>();
        String remoteAddress = "";
        if (request != null) {
            remoteAddress = request.getHeader("X-FORWARDED-FOR");
            if (remoteAddress == null) {
                remoteAddress = request.getRemoteAddr();
            }
            remoteAddressList = remoteAddress.contains(",") ? new ArrayList<String>(Arrays.asList(remoteAddress.split(","))) : new ArrayList<String>(Arrays.asList(remoteAddress));
        }
        return remoteAddressList;
    }

    public Boolean isInStoredIpAddress(List<String> ipAddressList, List<String> storedIpAddresses) {
        Iterator<String> iterator = ipAddressList.iterator();
        if (iterator.hasNext()) {
            String ipAddress = iterator.next();
            Boolean isPresent = Boolean.FALSE;
            LOGGER.debug("Current IP Address : " + ipAddress);
            LOGGER.debug("Stored IP Addresses : " + storedIpAddresses);
            try {
                InetAddress address = InetAddress.getByName(ipAddress);
                if (address instanceof Inet6Address) {
                    LOGGER.debug("IP Address Received is IPv6");
                    return Boolean.FALSE;
                }
            }
            catch (UnknownHostException e) {
                LOGGER.debug("Address was a machine name, and couldn't be found");
            }
            int ipSize = 0;
            int ipLength = 0;
            for (String storedIpAddress : storedIpAddresses) {
                String[] segment = storedIpAddress.split("/");
                if (segment.length == 2) {
                    SubnetUtils subnetUtils = new SubnetUtils(storedIpAddress);
                    if (!subnetUtils.getInfo().isInRange(ipAddress) && !StringUtils.equalsIgnoreCase(ipAddress, subnetUtils.getInfo().getBroadcastAddress()) && !StringUtils.equalsIgnoreCase(ipAddress, subnetUtils.getInfo().getNetworkAddress())) continue;
                    LOGGER.debug("IP is matched with stored CIDR IP Range: " + storedIpAddress);
                    isPresent = Boolean.TRUE;
                    break;
                }
                ipLength = storedIpAddress.split("\\*").length;
                if (ipLength > 0) {
                    storedIpAddress = storedIpAddress.replace(".*", "");
                    LOGGER.debug("ipAddress to compare with = " + storedIpAddress);
                }
                if ((ipSize = storedIpAddress.split("\\.").length) == 4) {
                    if (!StringUtils.equalsIgnoreCase(ipAddress, storedIpAddress)) continue;
                    LOGGER.debug("IP is matched with stored IP : " + storedIpAddress);
                    isPresent = Boolean.TRUE;
                    break;
                }
                if (!StringUtils.startsWithIgnoreCase(ipAddress, storedIpAddress + ".")) continue;
                LOGGER.debug("IP is matched with stored IP : " + storedIpAddress);
                isPresent = Boolean.TRUE;
                break;
            }
            return isPresent;
        }
        return Boolean.FALSE;
    }
}

