/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.rest.auth.commons.handler;

import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.miniorange.license.MoLicenseDetails;
import com.miniorange.license.MoLicenseManager;
import com.miniorange.license.constants.MoPluginKey;
import com.miniorange.rest.auth.commons.util.MoEncryptionUtils;
import com.miniorange.rest.auth.commons.util.MoPluginConstants;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoOfflineLicenseHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoOfflineLicenseHandler.class);
    private final I18nResolver i18nResolver;
    private final MoLicenseManager moLicenseManager;
    private PluginSettings pluginSettings;
    private PluginLicenseManager pluginLicenseManager;
    private LicenseHandler licenseHandler;

    public MoOfflineLicenseHandler(I18nResolver i18nResolver, PluginLicenseManager pluginLicenseManager, LicenseHandler licenseHandler, MoLicenseManager moLicenseManager, PluginSettingsFactory pluginSettingsFactory) {
        this.i18nResolver = i18nResolver;
        this.licenseHandler = licenseHandler;
        this.moLicenseManager = moLicenseManager;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public MoLicenseDetails offlineLicenseDetails() {
        String licenseKey = this.getOfflineLicenseKey();
        MoPluginKey pluginKey = null;
        switch (this.i18nResolver.getText("my.plugin.platform")) {
            case "jira": {
                pluginKey = MoPluginKey.JIRA_REST;
                break;
            }
            case "confluence": {
                pluginKey = MoPluginKey.CONFLUENCE_REST;
            }
        }
        String serverId = this.licenseHandler.getServerId();
        LOGGER.debug("server id is: " + serverId);
        MoLicenseDetails moLicenseDetails = this.moLicenseManager.verifyAndFetchDetails(licenseKey, serverId, pluginKey);
        return moLicenseDetails;
    }

    public String getOfflineLicenseKey() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.MO_OFFLINE_LICENSE_KEY.getKey()), "");
    }

    public void setMOCustomerToken(String customerToken) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.MO_CUSTOMER_TOKEN.getKey(), (Object)customerToken);
    }

    public void setMOLicensedUserTier(Integer licensedUserTier) {
        String customerToken = this.getMOCustomerToken();
        String userTier = MoEncryptionUtils.encrypt(customerToken, String.valueOf(licensedUserTier));
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.MO_OFFLINE_LICENSE_USER_TIER.getKey(), (Object)userTier);
    }

    public String getMOCustomerToken() {
        return StringUtils.defaultIfBlank((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.MO_CUSTOMER_TOKEN.getKey()), "NYFz3WIfBEn3DUHx");
    }

    public void setMOLicenseExpiryDate(String expiryDate) {
        String customerToken = this.getMOCustomerToken();
        String encryptedExpiryDate = MoEncryptionUtils.encrypt(customerToken, expiryDate);
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.MO_OFFLINE_LICENSE_EXPIRY_DATE.getKey(), (Object)encryptedExpiryDate);
    }

    public String getMOLicenseExpiryDate() {
        String customerToken = this.getMOCustomerToken();
        String expiryDate = (String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.MO_OFFLINE_LICENSE_EXPIRY_DATE.getKey());
        if (StringUtils.isNotBlank(expiryDate)) {
            String decryptedValue = MoEncryptionUtils.decrypt(customerToken, expiryDate);
            return decryptedValue;
        }
        return "";
    }

    public void setIsValidLicenseFileConfigured(boolean isValidLicenseFileConfigured) {
        this.pluginSettings.put(MoPluginConstants.SettingsConstants.MO_VALID_OFFLINE_LICENSE_CONFIGURED.getKey(), (Object)BooleanUtils.toString(isValidLicenseFileConfigured, "true", "false", "false"));
    }

    public Boolean getIsValidLicenseFileConfigured() {
        return BooleanUtils.toBooleanDefaultIfNull(BooleanUtils.toBoolean((String)this.pluginSettings.get(MoPluginConstants.SettingsConstants.MO_VALID_OFFLINE_LICENSE_CONFIGURED.getKey())), false);
    }

    public Integer getDaysLeftToExpire(String licenseExpireDateString) {
        Integer daysLeft = -1;
        try {
            if (StringUtils.isNotBlank(licenseExpireDateString)) {
                Date licenseExpireDate = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss.SSS").parse(licenseExpireDateString);
                LOGGER.debug("licenseExpireDate = " + licenseExpireDate.toString());
                Date currentDate = new Date();
                LOGGER.debug("currentDate = " + currentDate);
                daysLeft = (int)((licenseExpireDate.getTime() - currentDate.getTime()) / 86400000L);
                if (daysLeft >= 0 && licenseExpireDate.getTime() > currentDate.getTime()) {
                    LOGGER.debug("Days Left to Expire : " + daysLeft);
                    return daysLeft;
                }
                LOGGER.debug("License Expired.");
                return -1;
            }
        }
        catch (Exception e) {
            LOGGER.error("An exception occurs while calculating days left to expire", (Throwable)e);
        }
        return -1;
    }
}

